/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ParentLastClassLoader
extends ClassLoader {
    private String[] jarFiles;
    private Hashtable classes = new Hashtable();

    public ParentLastClassLoader(ClassLoader parent, String[] paths) {
        super(parent);
        this.jarFiles = paths;
    }

    public Class findClass(String name) throws ClassNotFoundException {
        System.out.println("Trying to find");
        throw new ClassNotFoundException();
    }

    protected synchronized Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        System.out.println("Trying to load");
        try {
            System.out.println("Loading class in Child : " + className);
            Class result = null;
            result = (Class)this.classes.get(className);
            if (result != null) {
                return result;
            }
            for (String jarFile : this.jarFiles) {
                try {
                    JarFile jar = new JarFile(jarFile);
                    JarEntry entry = jar.getJarEntry(className.replace(".", "/") + ".class");
                    InputStream is = jar.getInputStream(entry);
                    ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                    int nextValue = is.read();
                    while (-1 != nextValue) {
                        byteStream.write(nextValue);
                        nextValue = is.read();
                    }
                    byte[] classByte = byteStream.toByteArray();
                    result = this.defineClass(className, classByte, 0, classByte.length, null);
                    this.classes.put(className, result);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            result = (Class)this.classes.get(className);
            if (result != null) {
                return result;
            }
            throw new ClassNotFoundException("Not found " + className);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Delegating to parent : " + className);
            return super.loadClass(className, resolve);
        }
    }
}

