/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fm;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FMPXMLExport2 {
    private static final Logger log = Logger.getLogger(FMPXMLExport2.class.getName());
    private OutputStream out;
    private FieldElement[] fields;
    private String layout = "";
    private String databaseName = "";
    private String dateFormatPattern = "MM/dd/yyyy";
    private String timeFormatPattern = "HH:mm:ss";
    private TransformerHandler hd;
    private boolean didWriteHeaders;
    private Integer foundCount;
    private Integer errorCode;
    private DateFormat dateFormat;
    private DateFormat timeFormat;
    private DateFormat timestampFormat;
    private int rowsAdded;
    private Attributes emptyAttributes;
    private AttributesImpl rowAttributes;

    public FMPXMLExport2(OutputStream out, FieldElement[] fields, Integer foundCount) {
        if (out == null) {
            throw new NullPointerException("outputStream must not be null.");
        }
        if (fields == null) {
            throw new NullPointerException("fields must not be null.");
        }
        if (foundCount != null && foundCount < 0) {
            throw new IllegalArgumentException("foundCount must be greater than or equal to zero, or null");
        }
        this.out = out;
        this.fields = fields;
        this.foundCount = foundCount;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public void writeHeadersIfNeeded() {
        if (this.didWriteHeaders) {
            return;
        }
        this.didWriteHeaders = true;
        this.emptyAttributes = new AttributesImpl();
        this.rowAttributes = new AttributesImpl();
        this.rowAttributes.addAttribute("", "", "MODID", "CDATA", "0");
        this.rowAttributes.addAttribute("", "", "RECORDID", "CDATA", "0");
        StreamResult streamResult = new StreamResult(this.out);
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            this.hd = tf.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        Transformer serializer = this.hd.getTransformer();
        serializer.setOutputProperty("encoding", "UTF-8");
        serializer.setOutputProperty("standalone", "no");
        serializer.setOutputProperty("doctype-public", "-//FMI//DTD FMPXMLRESULT//EN");
        serializer.setOutputProperty("indent", "no");
        this.hd.setResult(streamResult);
        try {
            this.hd.startDocument();
            AttributesImpl fmpXmlResultAttributes = new AttributesImpl();
            fmpXmlResultAttributes.addAttribute("", "", "xmlns", "CDATA", "http://www.filemaker.com/fmpxmlresult");
            this.hd.startElement("", "", "FMPXMLRESULT", fmpXmlResultAttributes);
            this.hd.startElement("", "", "ERRORCODE", this.emptyAttributes);
            String errorString = this.rowsAdded > 0 ? "0" : (this.errorCode == null ? "401" : this.errorCode.toString());
            this.appendCharacterData(this.hd, errorString);
            this.hd.endElement("", "", "ERRORCODE");
            AttributesImpl productAttrs = new AttributesImpl();
            productAttrs.addAttribute("", "", "BUILD", "CDATA", "04/09/2007");
            productAttrs.addAttribute("", "", "NAME", "CDATA", "com.prosc.fm.FMPXMLExport2");
            productAttrs.addAttribute("", "", "VERSION", "CDATA", "1.0");
            this.hd.startElement("", "", "PRODUCT", productAttrs);
            this.hd.endElement("", "", "PRODUCT");
            AttributesImpl databaseAttrs = new AttributesImpl();
            databaseAttrs.addAttribute("", "", "DATEFORMAT", "CDATA", this.dateFormatPattern);
            databaseAttrs.addAttribute("", "", "LAYOUT", "CDATA", this.layout);
            databaseAttrs.addAttribute("", "", "NAME", "CDATA", this.databaseName);
            databaseAttrs.addAttribute("", "", "RECORDS", "CDATA", "");
            databaseAttrs.addAttribute("", "", "TIMEFORMAT", "CDATA", this.timeFormatPattern);
            this.hd.startElement("", "", "DATABASE", databaseAttrs);
            this.hd.endElement("", "", "DATABASE");
            this.hd.startElement("", "", "METADATA", this.emptyAttributes);
            AttributesImpl fieldAttrs = new AttributesImpl();
            for (int i = 0; i < this.fields.length; ++i) {
                FieldElement eachField = this.fields[i];
                fieldAttrs.clear();
                fieldAttrs.addAttribute("", "", "EMPTYOK", "CDATA", eachField.emptyOk ? "YES" : "NO");
                fieldAttrs.addAttribute("", "", "MAXREPEAT", "CDATA", String.valueOf(eachField.maxRepeat));
                fieldAttrs.addAttribute("", "", "NAME", "CDATA", eachField.name);
                fieldAttrs.addAttribute("", "", "TYPE", "CDATA", eachField.type);
                this.hd.startElement("", "", "FIELD", fieldAttrs);
                this.hd.endElement("", "", "FIELD");
            }
            this.hd.endElement("", "", "METADATA");
            AttributesImpl resultSetAttrs = new AttributesImpl();
            resultSetAttrs.addAttribute("", "", "FOUND", "CDATA", this.foundCount == null ? "" : String.valueOf(this.foundCount));
            this.hd.startElement("", "", "RESULTSET", resultSetAttrs);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        if (this.foundCount != null && this.rowsAdded != this.foundCount) {
            log.log(Level.WARNING, "foundCount is " + this.foundCount + ", but " + this.rowsAdded + " call(s) to addRow were made before closing the XML document");
        }
        this.writeHeadersIfNeeded();
        try {
            this.hd.endElement("", "", "RESULTSET");
            this.hd.endElement("", "", "FMPXMLRESULT");
            this.hd.endDocument();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        this.out.flush();
        this.out.close();
    }

    private void appendCharacterData(TransformerHandler handler, String data) throws SAXException {
        if (data == null) {
            return;
        }
        char[] ch = data.toCharArray();
        handler.characters(ch, 0, ch.length);
    }

    public void addRow(Object[] objects) throws SAXException {
        if (objects.length != this.fields.length) {
            throw new IllegalArgumentException("Row contains " + objects.length + " value(s), metadata contains " + this.fields.length + " value(s).");
        }
        ++this.rowsAdded;
        this.writeHeadersIfNeeded();
        this.hd.startElement("", "", "ROW", this.rowAttributes);
        for (int i = 0; i < objects.length; ++i) {
            Object eachValue = objects[i];
            this.hd.startElement("", "", "COL", this.emptyAttributes);
            if (this.fields[i].maxRepeat > 1) {
                this.appendRepeatingDataElement(i, eachValue);
            } else {
                this.appendSingleDataElement(i, eachValue);
            }
            this.hd.endElement("", "", "COL");
        }
        this.hd.endElement("", "", "ROW");
    }

    private void appendRepeatingDataElement(int fieldIndex, Object value) throws SAXException {
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                Object o = array[i];
                this.appendSingleDataElement(fieldIndex, o);
            }
        } else if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                this.appendSingleDataElement(fieldIndex, o);
            }
        } else {
            this.appendSingleDataElement(fieldIndex, value);
        }
    }

    private void appendSingleDataElement(int i, Object eachValue) throws SAXException {
        this.hd.startElement("", "", "DATA", this.emptyAttributes);
        this.appendCharacterData(this.hd, this.stringValueForData(eachValue, i));
        this.hd.endElement("", "", "DATA");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String stringValueForData(Object value, int index) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        FieldElement field = this.fields[index];
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "1" : "";
        }
        if (this.canConvertToDate(value)) {
            if (value instanceof Date && field.type.equals("DATE")) {
                return this.getStringValueForDate((Date)value);
            }
            if (value instanceof Date && field.type.equals("TIME")) {
                try {
                    this.timeFormat = DateFormat.getTimeInstance(2);
                    String string = this.timeFormat.format((Date)value);
                    return string;
                }
                finally {
                    this.timeFormat = null;
                }
            }
            if (value instanceof Date && field.type.equals("TIMESTAMP")) {
                return this.getStringValueForTimestamp((Date)value);
            }
            if (field.type.equals("DATE")) {
                return this.getDateFormat().format(value);
            }
            if (field.type.equals("TIME")) {
                return this.getTimeFormat().format(value);
            }
            if (field.type.equals("TIMESTAMP")) {
                return this.getTimestampFormat().format(value);
            }
        }
        return String.valueOf(value);
    }

    private boolean canConvertToDate(Object value) {
        return value instanceof Date || value instanceof Number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringValueForDate(Date date) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            StringBuffer buffer = new StringBuffer();
            this.dateFormat = DateFormat.getDateInstance(3);
            FieldPosition fieldPosition = new FieldPosition(1);
            StringBuffer format = this.dateFormat.format(date, buffer, fieldPosition);
            String string = format.replace(fieldPosition.getBeginIndex(), fieldPosition.getEndIndex(), String.valueOf(calendar.get(1))).toString();
            return string;
        }
        finally {
            this.dateFormat = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringValueForTimestamp(Date date) {
        try {
            this.timeFormat = DateFormat.getTimeInstance(2);
            String timeString = this.timeFormat.format(date);
            String string = this.getStringValueForDate(date) + " " + timeString;
            return string;
        }
        finally {
            this.timeFormat = null;
        }
    }

    private DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat(this.dateFormatPattern);
        }
        return this.dateFormat;
    }

    private DateFormat getTimeFormat() {
        if (this.timeFormat == null) {
            this.timeFormat = new SimpleDateFormat(this.timeFormatPattern);
        }
        return this.timeFormat;
    }

    private DateFormat getTimestampFormat() {
        if (this.timestampFormat == null) {
            this.timestampFormat = DateFormat.getDateTimeInstance(3, 2);
        }
        return this.timestampFormat;
    }

    public int getRowsAdded() {
        return this.rowsAdded;
    }

    public static class FieldElement
    implements Serializable {
        private boolean emptyOk = true;
        private int maxRepeat = 1;
        private String name;
        private String type = "TEXT";
        public static final String TYPE_TEXT = "TEXT";
        public static final String TYPE_NUMBER = "NUMBER";
        public static final String TYPE_DATE = "DATE";
        public static final String TYPE_TIME = "TIME";
        public static final String TYPE_TIMESTAMP = "TIMESTAMP";

        public FieldElement() {
        }

        public FieldElement(String name) {
            this(name, TYPE_TEXT);
        }

        public FieldElement(String name, String type) {
            this(name, type, true, 1);
        }

        public FieldElement(String name, String type, boolean emptyOk, int maxRepeat) {
            if (name == null) {
                throw new NullPointerException("name must not be null.");
            }
            if (!(type.equals(TYPE_TEXT) || type.equals(TYPE_NUMBER) || type.equals(TYPE_DATE) || type.equals(TYPE_TIME) || type.equals(TYPE_TIMESTAMP))) {
                throw new IllegalArgumentException("Invalid type, must be one of TEXT, NUMBER, DATE, TIME or TIMESTAMP");
            }
            if (maxRepeat < 0) {
                throw new IllegalArgumentException("maxRepeat must be > 0.");
            }
            this.name = name;
            this.type = type;
            this.emptyOk = emptyOk;
            this.maxRepeat = maxRepeat;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean isEmptyOk() {
            return this.emptyOk;
        }

        public void setEmptyOk(boolean emptyOk) {
            this.emptyOk = emptyOk;
        }

        public int getMaxRepeat() {
            return this.maxRepeat;
        }

        public void setMaxRepeat(int maxRepeat) {
            this.maxRepeat = maxRepeat;
        }

        public String toString() {
            return "FieldElement{name='" + this.name + '\'' + '}';
        }
    }
}

