/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.database;

import com.prosc.format.FlexibleDateFormat;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class JDBCUtils {
    private static final Logger log = Logger.getLogger(JDBCUtils.class.getName());

    public static void closeQuietly(PreparedStatement ps) {
        try {
            ps.close();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "Unable to close " + ps, e);
        }
    }

    public static void closeQuietly(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Unable to close " + connection, e);
            }
        }
    }

    public static void closeQuietly(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Unable to close " + rs, e);
            }
        }
    }

    public static void populateArgs(PreparedStatement ps, Object[] args) throws SQLException {
        for (int i = 0; i < args.length; ++i) {
            ps.setObject(i + 1, args[i]);
        }
    }

    public static void dumpResultSet(ResultSet rs, @Nullable Appendable output, boolean rewindOneRow) throws SQLException {
        try {
            ResultSetMetaData meta = rs.getMetaData();
            Appendable _output = output == null ? new StringBuilder() : output;
            for (int n = 0; n < meta.getColumnCount(); ++n) {
                _output.append(meta.getColumnName(n + 1) + "\t");
            }
            boolean skipRow = rewindOneRow;
            while (skipRow || rs.next()) {
                _output.append("\n");
                for (int n = 0; n < meta.getColumnCount(); ++n) {
                    _output.append(rs.getObject(n + 1) + "\t");
                }
                skipRow = false;
            }
            if (output == null) {
                log.info(_output.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Collection<? extends String> columnLabelsFor(ResultSet currentRow) throws SQLException {
        ResultSetMetaData metaData = currentRow.getMetaData();
        int columnCount = metaData.getColumnCount();
        ArrayList<String> result = new ArrayList<String>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            result.add(metaData.getColumnLabel(i + 1));
        }
        return result;
    }

    public static Object convertStringToDataType(String text, int dataType) {
        return JDBCUtils.convertObjectToDataType(text, dataType);
    }

    public static Object convertObjectToDataType(Object input, int dataType) {
        switch (dataType) {
            case 2: 
            case 3: {
                return JDBCUtils.convertObjectToBigDecimal(input);
            }
            case -5: {
                return JDBCUtils.convertObjectToLong(input);
            }
            case -7: 
            case 16: {
                return JDBCUtils.convertObjectToBoolean(input);
            }
            case -16: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return JDBCUtils.convertObjectToString(input);
            }
            case 91: {
                return JDBCUtils.convertObjectToDate(input);
            }
            case 8: {
                return JDBCUtils.convertObjectToDouble(input);
            }
            case 6: 
            case 7: {
                return JDBCUtils.convertObjectToFloat(input);
            }
            case 4: {
                return JDBCUtils.convertObjectToInteger(input);
            }
            case 5: {
                return JDBCUtils.convertObjectToShort(input);
            }
            case 92: {
                return JDBCUtils.convertObjectToTime(input);
            }
            case 93: {
                return JDBCUtils.convertObjectToTimestamp(input);
            }
            case -6: {
                return JDBCUtils.convertObjectToByte(input);
            }
        }
        throw new IllegalArgumentException("Unsupported conversion to SQL type " + dataType + "; will return null for input " + String.valueOf(input));
    }

    public static boolean isText(int dataType) {
        return dataType == 12 || dataType == -1 || dataType == 1 || dataType == 2005 || dataType == 2003 || dataType == -9 || dataType == -15;
    }

    public static boolean isNumber(int dataType) {
        return dataType == 3 || dataType == 8 || dataType == 4 || dataType == 6 || dataType == 7 || dataType == -5 || dataType == -7 || dataType == -6 || dataType == 5 || dataType == 2 || dataType == 16;
    }

    public static String convertObjectToString(Object input) {
        if (input == null) {
            return null;
        }
        return String.valueOf(input);
    }

    public static Integer convertObjectToInteger(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof Integer) {
            return (Integer)input;
        }
        if (input instanceof Number) {
            return ((Number)input).intValue();
        }
        if (input instanceof String) {
            return Integer.valueOf((String)input);
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to an integer.");
    }

    public static Float convertObjectToFloat(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof Float) {
            return (Float)input;
        }
        if (input instanceof Number) {
            return Float.valueOf(((Number)input).floatValue());
        }
        if (input instanceof String) {
            return Float.valueOf((String)input);
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to a float.");
    }

    public static Long convertObjectToLong(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof Long) {
            return (Long)input;
        }
        if (input instanceof Number) {
            return ((Number)input).longValue();
        }
        if (input instanceof String) {
            return Long.valueOf((String)input);
        }
        if (input instanceof java.util.Date) {
            return ((java.util.Date)input).getTime();
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to a long.");
    }

    public static Double convertObjectToDouble(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof Double) {
            return (Double)input;
        }
        if (input instanceof Number) {
            return ((Number)input).doubleValue();
        }
        if (input instanceof String) {
            return Double.valueOf((String)input);
        }
        if (input instanceof java.util.Date) {
            return ((java.util.Date)input).getTime();
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to a double.");
    }

    public static BigDecimal convertObjectToBigDecimal(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof BigDecimal) {
            return (BigDecimal)input;
        }
        if (input instanceof String) {
            return new BigDecimal((String)input);
        }
        if (input instanceof Double) {
            return BigDecimal.valueOf((Double)input);
        }
        if (input instanceof Long) {
            return BigDecimal.valueOf((Long)input);
        }
        if (input instanceof Number) {
            return BigDecimal.valueOf(((Number)input).doubleValue());
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to a BigDecimal.");
    }

    public static Boolean convertObjectToBoolean(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof Boolean) {
            return (Boolean)input;
        }
        if (input instanceof Number) {
            return ((Number)input).intValue() != 0;
        }
        if (input instanceof String) {
            return Boolean.valueOf((String)input);
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to a boolean.");
    }

    public static Byte convertObjectToByte(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof Byte) {
            return (Byte)input;
        }
        if (input instanceof Number) {
            return ((Number)input).byteValue();
        }
        if (input instanceof String) {
            return Byte.valueOf((String)input);
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to a byte.");
    }

    public static Short convertObjectToShort(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof Short) {
            return (Short)input;
        }
        if (input instanceof Number) {
            return ((Number)input).shortValue();
        }
        if (input instanceof String) {
            return Short.valueOf((String)input);
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to a short.");
    }

    public static Time convertObjectToTime(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof Time) {
            return (Time)input;
        }
        if (input instanceof Number) {
            return new Time(((Number)input).longValue());
        }
        if (input instanceof String) {
            try {
                java.util.Date date = new SimpleDateFormat("hh:mm:ss").parse((String)input);
                return new Time(date.getTime());
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Could not parse string value '" + input + "' as a time value");
            }
        }
        throw new IllegalArgumentException("Could not convert " + String.valueOf(input) + " to a time.");
    }

    public static Date convertObjectToDate(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof Date) {
            return (Date)input;
        }
        if (input instanceof java.util.Date) {
            return new Date(((java.util.Date)input).getTime());
        }
        if (input instanceof Number) {
            return new Date(((Number)input).longValue());
        }
        if (input instanceof String) {
            try {
                return new Date(new FlexibleDateFormat().parse((String)input).getTime());
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Could not parse string value '" + input + "' as a date value");
            }
        }
        throw new IllegalArgumentException("Could not convert value '" + String.valueOf(input) + "' as a date value");
    }

    public static Timestamp convertObjectToTimestamp(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof Timestamp) {
            return (Timestamp)input;
        }
        if (input instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)input).getTime());
        }
        if (input instanceof Number) {
            return new Timestamp(((Number)input).longValue());
        }
        if (input instanceof String) {
            try {
                return new Timestamp(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse((String)input).getTime());
            }
            catch (ParseException e) {
                try {
                    return new Timestamp(new FlexibleDateFormat().parse((String)input).getTime());
                }
                catch (ParseException e1) {
                    throw new IllegalArgumentException("Could not parse string value '" + input + "' as a timestamp value");
                }
            }
        }
        throw new IllegalArgumentException("Could not convert value '" + String.valueOf(input) + "' as a timestamp value");
    }
}

