/*
 * Decompiled with CFR 0.152.
 */
package motelmateupdater;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import motelmateupdater.CustomProgress;

class MyTeeStream
extends InputStream {
    private final InputStream is;
    private final OutputStream os;
    private long totalBytes;
    private int percent;
    private final long length;
    private final CustomProgress progressMonitor;

    public MyTeeStream(InputStream in, OutputStream out, int length, CustomProgress progressMonitor) {
        this.is = in;
        this.os = out;
        this.totalBytes = 0L;
        this.percent = 0;
        this.length = length;
        this.progressMonitor = progressMonitor;
    }

    public int read() throws IOException {
        int v = this.is.read();
        if (v != -1) {
            ++this.totalBytes;
            this.os.write(v);
            int p = (int)(this.totalBytes * 100L / this.length);
            if (p != this.percent) {
                this.progressMonitor.setProgress(p);
            }
            this.percent = p;
        }
        return v;
    }

    public int read(byte[] b) throws IOException {
        int n = this.is.read(b);
        if (n != -1) {
            this.totalBytes += (long)n;
            this.os.write(b, 0, n);
            int p = (int)(this.totalBytes * 100L / this.length);
            if (p != this.percent) {
                this.progressMonitor.setProgress(p);
            }
            this.percent = p;
        }
        return n;
    }
}

