/*
 * Decompiled with CFR 0.152.
 */
package motelmateupdater;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import motelmateupdater.CustomProgress;
import motelmateupdater.Delete;
import motelmateupdater.Move;
import motelmateupdater.MyStream;
import motelmateupdater.MyTeeStream;
import motelmateupdater.Undo;

public class Main
extends WindowAdapter {
    static final String macDownload = "http://dl.motelmate.co.nz/motelmate/downloads/MMUpdateMac12.zip";
    static final String winDownload = "http://dl.motelmate.co.nz/motelmate/downloads/MMUpdateWin12.zip";
    static final String productName = "MotelMate";
    static final boolean isUpdate = true;
    static File logFile;
    static final SimpleDateFormat dateFormat;
    boolean userCancel = false;
    List<Undo> undoList;
    ZipInputStream zipStream;
    static String location;
    static String separator;

    protected static void errorDialog(String title, String message) {
        JOptionPane.showMessageDialog(null, message, "MotelMate: " + title, 0);
        System.exit(0);
    }

    static final void log(String msg) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(logFile, true);
            fw.write(dateFormat.format(new Date()) + ": " + msg + "\r\n");
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void main(String[] args) throws URISyntaxException {
        String updateURI;
        String jarFile = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getName();
        jarFile = jarFile.substring(0, jarFile.length() - 4);
        jarFile = Pattern.compile("\\W?[^A-Za-z]*$").split(jarFile)[0];
        separator = System.getProperty("file.separator");
        if (separator.equals("/")) {
            location = "/";
            updateURI = macDownload;
            String exeName = location + productName + separator + productName + " For Mac OS X.app";
            String[] shortcut = new String[]{"ln", "-s", exeName, System.getProperty("user.home") + "/Desktop/"};
            String[] execute = new String[]{"open", exeName};
        } else {
            location = "C:\\";
            updateURI = winDownload;
            String exeName = location + productName + separator + productName + " For Windows.exe";
            String script = "Set sh = CreateObject(\"WScript.Shell\")\nSet shortcut = sh.CreateShortcut(\"" + System.getProperty("user.home") + "\\Desktop\\" + productName + " For Windows.lnk\")\nshortcut.TargetPath = \"" + exeName + "\"\nshortcut.Save";
            try {
                FileOutputStream fo = new FileOutputStream(new File(location + productName + "MakeShortcut.vbs"));
                fo.write(script.getBytes());
                fo.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String[] shortcut = new String[]{"wscript.exe", location + productName + "MakeShortcut.vbs"};
            String[] execute = new String[]{exeName};
        }
        new Main(jarFile, location + productName, location + productName + separator + "Extensions", updateURI, !separator.equals("/"));
    }

    public Main(String jarName, String motelMateFolderLocation, String extensionFolderLocation, String updateZipURL, boolean windows) {
        String[] shortcut;
        String[] execute;
        String exeName;
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        Object[] options = new Object[]{"Start Update", "Do Not Update"};
        int n = JOptionPane.showOptionDialog(null, "Please Wait For MotelMate To Quit before clicking the buttons below", "MotelMate: Update System", 0, 3, null, options, options[0]);
        if (n == 1) {
            Main.errorDialog("Update Cancelled", "Update will now close");
        }
        CustomProgress progressMonitor = new CustomProgress(jarName, "Connecting", this);
        this.undoList = new ArrayList<Undo>();
        try {
            ZipEntry entry;
            File motelMateFolder = new File(motelMateFolderLocation);
            File updateFolder = new File(motelMateFolder.getParent(), "MotelMateUpdateArchive");
            File extensionFolder = new File(extensionFolderLocation);
            if (!updateFolder.exists()) {
                updateFolder.mkdir();
            }
            if (!(updateFolder = new File(updateFolder, dateFormat.format(new Date()))).mkdirs()) {
                Main.errorDialog("Folder Creation Error", "Could not create MotelMateUpdateArchive Folder");
            }
            logFile = new File(updateFolder, "log.txt");
            File zipFile = new File(updateFolder, "MotelMateDownload.zip");
            FileOutputStream zfos = new FileOutputStream(zipFile);
            BufferedOutputStream zipFileStream = new BufferedOutputStream(zfos);
            URLConnection connection = new URL(updateZipURL).openConnection();
            int downloadSize = connection.getContentLength();
            progressMonitor.setNote("Downloading");
            MyTeeStream teeStream = new MyTeeStream(connection.getInputStream(), zipFileStream, downloadSize, progressMonitor);
            BufferedInputStream in = new BufferedInputStream(teeStream);
            this.zipStream = new ZipInputStream(in);
            while ((entry = this.zipStream.getNextEntry()) != null) {
                String eName;
                if (entry.isDirectory() || !(eName = entry.getName()).startsWith("_Pictures") || !eName.endsWith(".jpg") && !eName.endsWith(".png") && !eName.endsWith(".gif")) continue;
                try {
                    Main.log("Adding Image For Display: " + eName);
                    progressMonitor.addImage(ImageIO.read(this.zipStream));
                }
                catch (Exception e) {
                    Main.log("Incompatible Image File: " + eName);
                }
            }
            zipFileStream.close();
            progressMonitor.setNote("Installing");
            progressMonitor.setProgress(0);
            MyStream myStream = new MyStream(new BufferedInputStream(new FileInputStream(zipFile)));
            this.zipStream = new ZipInputStream(myStream);
            if (!motelMateFolder.exists()) {
                Main.log("MotelMate folder does not exist: Creating");
                if (!motelMateFolder.mkdirs()) {
                    Main.errorDialog("Folder Creation Error", "Could not create MotelMate Folder");
                }
            }
            Main.log("Downloading " + updateZipURL + " and installing into " + motelMateFolderLocation);
            while ((entry = this.zipStream.getNextEntry()) != null) {
                File dir;
                File uFolder;
                File folder;
                String eName = entry.getName();
                if (eName.startsWith("__MACOSX") || eName.contains("._") || eName.endsWith(".DS_Store")) continue;
                File extensionsUpdateFolder = new File(updateFolder, "Extensions");
                if (eName.startsWith("Extensions")) {
                    if (!extensionsUpdateFolder.exists()) {
                        Main.log("Creating Extensions Folder inside MotelMateUpdateArchive Folder");
                        extensionsUpdateFolder.mkdir();
                        this.undoList.add(new Delete(extensionsUpdateFolder));
                    }
                    if (!extensionFolder.exists()) {
                        Main.log("Creating Extensions Folder inside MotelMate Folder");
                        extensionFolder.mkdir();
                        this.undoList.add(new Delete(extensionFolder));
                    }
                    folder = extensionFolder;
                    uFolder = extensionsUpdateFolder;
                    eName = eName.substring(11);
                } else {
                    folder = motelMateFolder;
                    uFolder = updateFolder;
                }
                if (!entry.isDirectory()) {
                    int len;
                    if (eName.startsWith("_Pictures") && (eName.endsWith(".jpg") || eName.endsWith(".png") || eName.endsWith(".gif"))) continue;
                    Main.log("Found compressed file: " + eName);
                    File f = new File(folder, eName);
                    if (!f.getParentFile().exists()) {
                        Main.log("Parent folder(s) doesn't exist - creating");
                        f.getParentFile().mkdirs();
                    } else if (f.exists()) {
                        Main.log("File already exists - Preparing to move old file into updateFolder");
                        File b = new File(uFolder, eName);
                        if (!b.getParentFile().exists()) {
                            Main.log("Respective updateFolder path doesn't exist - creating");
                            b.getParentFile().mkdirs();
                            this.undoList.add(new Delete(b.getParentFile()));
                        }
                        Main.log("Moving file: " + f.getAbsolutePath() + " to: " + b.getAbsolutePath());
                        if (!f.renameTo(b)) {
                            throw new Exception("Could not move File: " + f.getAbsolutePath() + " to " + b.getAbsolutePath());
                        }
                        f = new File(folder, eName);
                        this.undoList.add(new Move(new File(uFolder, eName), new File(folder, eName)));
                    }
                    Main.log("Saving compressed file: " + f.getAbsolutePath());
                    BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(f));
                    byte[] buffer = new byte[40960];
                    this.undoList.add(new Delete(f));
                    int percent = 0;
                    while ((len = this.zipStream.read(buffer)) > 0) {
                        if (this.userCancel) {
                            return;
                        }
                        output.write(buffer, 0, len);
                        int p = (int)(myStream.getTotalBytes() * 100L / (long)downloadSize);
                        if (p == percent) continue;
                        progressMonitor.setProgress(p);
                        percent = p;
                    }
                    output.close();
                    if (f.length() == 0L) {
                        f.delete();
                        this.undoList.remove(this.undoList.size() - 1);
                        continue;
                    }
                    if (!f.getAbsolutePath().contains("Contents/MacOS/")) continue;
                    f.setExecutable(true, false);
                    continue;
                }
                if (eName.startsWith("_Pictures") || (dir = new File(folder, eName)).exists()) continue;
                dir.mkdir();
                this.undoList.add(new Delete(dir));
            }
            progressMonitor.close();
            Main.log("Update finished");
        }
        catch (Exception ex) {
            if (this.userCancel) {
                return;
            }
            ex.printStackTrace();
            try {
                if (logFile != null) {
                    Main.log("ERROR: " + ex.getMessage());
                }
                progressMonitor.setProgress(0);
                progressMonitor.setNote("Rolling Back");
                this.rollBack();
                progressMonitor.close();
                Main.errorDialog("Update Failed", "An error occurred during update, your MotelMate has been left unchanged.\nPlease contact MotelMate Support on 0800 367 658.\nThe error was:\n" + ex.getMessage());
            }
            catch (Exception e) {
                if (logFile != null) {
                    Main.log("Critical Error");
                }
                Main.errorDialog("Critical Error", "Please contact MotelMate Support on 0800 367 658.  Update Failed: " + ex.getMessage() + "  Rollback Failed: " + e.getMessage());
            }
        }
        if (windows) {
            exeName = location + productName + separator + productName + " For Windows.exe";
            execute = new String[]{exeName};
            String script = "Set sh = CreateObject(\"WScript.Shell\")\nSet shortcut = sh.CreateShortcut(\"" + System.getProperty("user.home") + "\\Desktop\\" + productName + " For Windows.lnk\")\nshortcut.TargetPath = \"" + exeName + "\"\nshortcut.Save";
            try {
                FileOutputStream fo = new FileOutputStream(new File(location + productName + separator + "MakeShortcut.vbs"));
                fo.write(script.getBytes());
                fo.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            shortcut = new String[]{"wscript.exe", location + productName + separator + "MakeShortcut.vbs"};
        } else {
            exeName = location + productName + separator + productName + " For Mac OS X.app";
            shortcut = new String[]{"ln", "-s", exeName, System.getProperty("user.home") + "/Desktop/"};
            execute = new String[]{"open", exeName};
        }
        try {
            Runtime.getRuntime().exec(shortcut);
        }
        catch (Exception ex) {
            Main.errorDialog("Alert", "Could not create Desktop Shortcut: " + ex.getMessage());
        }
        JOptionPane.showMessageDialog(null, "Update Complete", "MotelMate Updater", 1);
        System.exit(0);
        try {
            Runtime.getRuntime().exec(execute);
        }
        catch (Exception ex) {
            Main.errorDialog("Alert", "Could not open MotelMate: " + ex.getMessage());
        }
        System.exit(0);
    }

    protected void rollBack() {
        int size = this.undoList.size();
        for (int x = size - 1; x > -1; --x) {
            this.undoList.get(x).execute();
        }
    }

    public void windowClosing(WindowEvent e) {
        this.userCancel = true;
        try {
            this.zipStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Main.log("User Cancelled Install");
        this.rollBack();
        e.getWindow().setVisible(false);
        Main.errorDialog("Update Aborted", "User cancelled during update, your MotelMate has been left unchanged.\n");
    }

    static {
        dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH.mm.ss");
    }
}

