/*
 * Decompiled with CFR 0.152.
 */
package motelmateupdater;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import motelmateupdater.CustomProgress;
import motelmateupdater.Delete;
import motelmateupdater.Move;
import motelmateupdater.MyStream;
import motelmateupdater.Undo;

public class Main
extends WindowAdapter {
    static File logFile;
    static final SimpleDateFormat dateFormat;
    boolean userCancel = false;
    List<Undo> undoList;
    ZipInputStream zipStream;

    protected static void errorDialog(String title, String message) {
        JOptionPane.showMessageDialog(null, message, "MotelMate: " + title, 0);
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void log(String msg) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(logFile, true);
            fw.write(dateFormat.format(new Date()) + ": " + msg + "\r\n");
        }
        catch (IOException ex) {
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            String updateURI;
            String location;
            String separator = System.getProperty("file.separator");
            if (separator.equals("/")) {
                location = "/";
                updateURI = "http://dl.motelmate.co.nz/motelmate/downloads/MMUpdateMac.zip";
            } else {
                location = "C:\\";
                updateURI = "http://dl.motelmate.co.nz/motelmate/downloads/MMUpdateWin.zip";
            }
            new Main(location + "MotelMate", location + "MotelMate" + separator + "Extensions", updateURI);
        } else {
            new Main(args[0], args[1], args[2]);
        }
    }

    public Main(String motelMateFolderLocation, String extensionFolderLocation, String updateZipURL) {
        Object[] options = new Object[]{"Start Update", "Do Not Update"};
        int n = JOptionPane.showOptionDialog(null, "Please Wait For MotelMate To Quit before clicking the buttons below", "MotelMate: Update System", 0, 3, null, options, options[0]);
        if (n == 1) {
            Main.errorDialog("Update Cancelled", "Update will now close");
        }
        CustomProgress progressMonitor = new CustomProgress("MotelMate Update", "Connecting", this);
        this.undoList = new ArrayList<Undo>();
        try {
            ZipEntry entry;
            URLConnection connection = new URL(updateZipURL).openConnection();
            int downloadSize = connection.getContentLength();
            MyStream myStream = new MyStream(connection.getInputStream());
            BufferedInputStream in = new BufferedInputStream(myStream);
            this.zipStream = new ZipInputStream(in);
            File motelMateFolder = new File(motelMateFolderLocation);
            File extensionFolder = new File(extensionFolderLocation);
            File updateFolder = new File(motelMateFolder.getParent(), "MMUpdateArchive");
            if (!updateFolder.exists()) {
                updateFolder.mkdir();
            }
            if (!(updateFolder = new File(updateFolder, dateFormat.format(new Date()))).mkdirs()) {
                Main.errorDialog("Folder Creation Error", "Could not create MMUpdateArchive Folder");
            }
            logFile = new File(updateFolder, "log.txt");
            if (!motelMateFolder.exists()) {
                Main.log("MotelMate folder does not exist: Creating");
                if (!motelMateFolder.mkdirs()) {
                    Main.errorDialog("Folder Creation Error", "Could not create MotelMate Folder");
                }
            }
            progressMonitor.setNote("Downloading and Installing");
            Main.log("Downloading " + updateZipURL + " and installing into " + motelMateFolderLocation);
            while ((entry = this.zipStream.getNextEntry()) != null) {
                File dir;
                File uFolder;
                File folder;
                String eName = entry.getName();
                if (eName.startsWith("__MACOSX") || eName.contains("._") || eName.endsWith(".DS_Store")) continue;
                File extensionsUpdateFolder = new File(updateFolder, "Extensions");
                if (eName.startsWith("Extensions")) {
                    if (!extensionsUpdateFolder.exists()) {
                        Main.log("Creating Extensions Folder inside MMUpdateArchive Folder");
                        extensionsUpdateFolder.mkdir();
                        this.undoList.add(new Delete(extensionsUpdateFolder));
                    }
                    if (!extensionFolder.exists()) {
                        Main.log("Creating Extensions Folder inside MotelMate Folder");
                        extensionFolder.mkdir();
                        this.undoList.add(new Delete(extensionFolder));
                    }
                    folder = extensionFolder;
                    uFolder = extensionsUpdateFolder;
                    eName = eName.substring(11);
                } else {
                    folder = motelMateFolder;
                    uFolder = updateFolder;
                }
                if (!entry.isDirectory()) {
                    if (eName.startsWith("_Pictures") && eName.endsWith(".jpg") || eName.endsWith(".png") || eName.endsWith(".gif")) {
                        try {
                            Main.log("Adding Image For Display: " + eName);
                            progressMonitor.addImage(ImageIO.read(this.zipStream));
                        }
                        catch (Exception e) {
                            Main.log("Incompatible Image File: " + eName);
                        }
                        continue;
                    }
                    Main.log("Found compressed file: " + eName);
                    File f = new File(folder, eName);
                    if (!f.getParentFile().exists()) {
                        Main.log("Parent folder(s) doesn't exist - creating");
                        f.getParentFile().mkdirs();
                    } else if (f.exists()) {
                        Main.log("File already exists - Preparing to move old file into updateFolder");
                        File b = new File(uFolder, eName);
                        if (!b.getParentFile().exists()) {
                            Main.log("Respective updateFolder path doesn't exist - creating");
                            b.getParentFile().mkdirs();
                            this.undoList.add(new Delete(b.getParentFile()));
                        }
                        Main.log("Moving file: " + f.getAbsolutePath() + " to: " + b.getAbsolutePath());
                        if (!f.renameTo(b)) {
                            throw new Exception("Could not move File: " + f.getAbsolutePath() + " to " + b.getAbsolutePath());
                        }
                        f = new File(folder, eName);
                        this.undoList.add(new Move(new File(uFolder, eName), new File(folder, eName)));
                    }
                    Main.log("Saving compressed file: " + f.getAbsolutePath());
                    FileOutputStream output = new FileOutputStream(f);
                    int len = 0;
                    byte[] buffer = new byte[4096];
                    this.undoList.add(new Delete(f));
                    while ((len = this.zipStream.read(buffer)) > 0) {
                        if (this.userCancel) {
                            return;
                        }
                        output.write(buffer, 0, len);
                        progressMonitor.setProgress((int)(myStream.getTotalBytes() * 100L / (long)downloadSize));
                    }
                    output.close();
                    if (f.length() == 0L) {
                        f.delete();
                        this.undoList.remove(this.undoList.size() - 1);
                        continue;
                    }
                    if (!f.getAbsolutePath().contains("Contents/MacOS/")) continue;
                    f.setExecutable(true, false);
                    continue;
                }
                if (eName.startsWith("_Pictures") || (dir = new File(folder, eName)).exists()) continue;
                dir.mkdir();
                this.undoList.add(new Delete(dir));
            }
            progressMonitor.close();
            Main.log("Update finished");
            JOptionPane.showMessageDialog(null, "Update Successful", "MotelMate: Update Successful", 1);
            System.exit(0);
        }
        catch (Exception ex) {
            if (this.userCancel) {
                return;
            }
            ex.printStackTrace();
            try {
                if (logFile != null) {
                    Main.log("ERROR: " + ex.getMessage());
                }
                progressMonitor.setProgress(0);
                progressMonitor.setNote("Rolling Back");
                this.rollBack();
                progressMonitor.close();
                Main.errorDialog("Update Failed", "An error occurred during update, your MotelMate has been left unchanged.\nPlease contact MotelMate Support on 0800 367 658.\nThe error was:\n" + ex.getMessage());
            }
            catch (Exception e) {
                if (logFile != null) {
                    Main.log("Critical Error");
                }
                Main.errorDialog("Critical Error", "Please contact MotelMate Support on 0800 367 658.  Update Failed: " + ex.getMessage() + "  Rollback Failed: " + e.getMessage());
            }
        }
    }

    protected void rollBack() {
        int size = this.undoList.size();
        for (int x = size - 1; x > -1; --x) {
            this.undoList.get(x).execute();
        }
    }

    public void windowClosing(WindowEvent e) {
        this.userCancel = true;
        try {
            this.zipStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Main.log("User Cancelled Install");
        this.rollBack();
        e.getWindow().setVisible(false);
        Main.errorDialog("Update Aborted", "User cancelled during update, your MotelMate has been left unchanged.\n");
    }

    static {
        dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH.mm.ss");
    }
}

