/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.license.client;

import com.prosc.license.client.DefaultLicenseDecryptor;
import com.prosc.license.client.InvalidLicenseException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class License
implements Serializable,
Comparable<License> {
    private final int orderID;
    private final short productCode;
    private final short version;
    private final long maxReleaseDate;
    private final long expirationDate;
    private final long orderDate;
    private final byte variant;
    private final String encryptedKey;
    private final String registeredTo;
    public static final byte DEMO_VARIANT = 0;
    public static final byte STANDARD_VARIANT = 1;
    public static final byte ENTERPRISE_VARIANT = 2;
    public static final byte DEVELOPER_VARIANT = 3;
    public static final byte DEVELOPER_ENTERPRISE_VARIANT = 4;
    public static final byte FBA_ENTERPRISE_VARIANT = 5;
    public static final byte PROFESSIONAL_EDITION_VARIANT = 6;
    public static final byte FREE_VARIANT = 7;
    public static final int PORTFOLIO_PRODUCT_CODE = 35;
    public static final char ALGORITHM_VERSION_B = 'B';
    public static final char ALGORITHM_VERSION_C = 'C';
    public static final char ALGORITHM_VERSION_D = 'D';

    public License(int orderID, short productCode, short version, byte variant, long orderDate, long expirationDate, long maxReleaseDate, String licenseKey, String companyName) {
        this.orderID = orderID;
        this.productCode = productCode;
        this.version = version;
        this.variant = variant;
        this.orderDate = orderDate;
        this.expirationDate = expirationDate;
        this.maxReleaseDate = maxReleaseDate;
        this.encryptedKey = licenseKey;
        this.registeredTo = companyName;
    }

    public License(String encryptedKey, String registeredTo) throws IllegalArgumentException, InvalidLicenseException {
        DefaultLicenseDecryptor decryptor;
        this.encryptedKey = encryptedKey;
        if (registeredTo != null) {
            registeredTo = registeredTo.trim();
        }
        if (!(decryptor = new DefaultLicenseDecryptor(encryptedKey)).isRegisteredTo(registeredTo)) {
            throw new InvalidLicenseException("The license key is valid, but the registered to name was entered incorrectly.", encryptedKey, registeredTo);
        }
        this.registeredTo = registeredTo;
        this.orderID = decryptor.getOrderId().shortValue();
        this.productCode = decryptor.getProductId().shortValue();
        this.version = decryptor.getVersion().shortValue();
        this.variant = decryptor.getVariant();
        this.orderDate = decryptor.getOrderDate().getTime();
        this.expirationDate = decryptor.getExpirationDate() == null ? Long.MAX_VALUE : decryptor.getExpirationDate().getTime();
        this.maxReleaseDate = decryptor.getMaxReleaseDate();
    }

    public int getOrderID() {
        return this.orderID;
    }

    public short getProductCode() {
        return this.productCode;
    }

    public short getVersion() {
        return this.version;
    }

    public byte getVariant() {
        return this.variant;
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public long getMaxReleaseDate() {
        return this.maxReleaseDate;
    }

    public String getEncryptedKey() {
        return this.encryptedKey;
    }

    public String getRegisteredTo() {
        return this.registeredTo;
    }

    public String getVariantName() {
        return License.variantNameForByte(this.variant);
    }

    public static String variantNameForByte(byte variantByte) {
        switch (variantByte) {
            case 0: {
                return "Demo version";
            }
            case 1: {
                return "Standard License";
            }
            case 2: {
                return "Enterprise License";
            }
            case 3: {
                return "Developer License (Workgroup)";
            }
            case 4: {
                return "Solution Bundling License";
            }
            case 5: {
                return "FBA Member License";
            }
            case 6: {
                return "Professional Edition";
            }
            case 7: {
                return "Free License";
            }
        }
        return "Unknown License Type " + variantByte;
    }

    public boolean isPortfolio() {
        return this.getProductCode() == 35;
    }

    @Override
    public int compareTo(License o) {
        byte other = o.getVariant();
        if (this.variant == 3 && (other == 2 || other == 4)) {
            return -1;
        }
        return this.variant - other;
    }

    public String toString() {
        return "License{orderID=" + this.orderID + ", productCode=" + this.productCode + ", version=" + this.version + ", maxReleaseDate=" + this.maxReleaseDate + ", expirationDate=" + this.expirationDate + ", variant=" + this.variant + ", encryptedKey='" + this.encryptedKey + '\'' + ", registeredTo='" + this.registeredTo + '\'' + '}';
    }

    public long getOrderDate() {
        return this.orderDate;
    }
}

