/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.types;

import com.prosc.fmkit.types.Converter;
import com.prosc.fmkit.types.FMBinary;
import com.prosc.fmkit.types.FMBinaryInterface;
import com.prosc.fmkit.types.FMNumber;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMType;
import com.prosc.fmkit.types.FileReference;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Logger;

public class FMData {
    private static final Logger log = Logger.getLogger(FMData.class.getName());
    private static final int kDTInvalid = 0;
    private static final int kDTText = 1;
    private static final int kDTNumber = 2;
    private static final int kDTDate = 3;
    private static final int kDTTime = 4;
    private static final int kDTTimeStamp = 5;
    private static final int kDTBinary = 6;
    private static final int kDTBoolean = 7;
    private static long FM_EPOCH_OFFSET = 62135683200000L;
    private long cDataToken;

    protected static void registerConverters() {
        FMType.addConverter(new FMDataConverter());
    }

    public FMData(long cDataToken) {
        this.cDataToken = cDataToken;
    }

    public FMData() {
        this.cDataToken = this._createEmptyData();
    }

    private native long _createEmptyData();

    public long getLongData() {
        return this._getLongData(this.cDataToken);
    }

    private native long _getLongData(long var1);

    public double getDoubleData() {
        return this._getDoubleData(this.cDataToken);
    }

    private native double _getDoubleData(long var1);

    public long getCToken() {
        return this.cDataToken;
    }

    public void setStringData(String data) {
        if (data == null) {
            data = "";
        }
        this._setStringData(this.cDataToken, data);
    }

    private native void _setStringData(long var1, String var3);

    public String getStringData() {
        return this._getStringData(this.cDataToken);
    }

    public String toString() {
        return super.toString();
    }

    private native String _getStringData(long var1);

    private native long _getDateValue(long var1);

    public long getDateTimeValue() {
        long secondsSinceFmEpoch = this._getDateTimeValue(this.cDataToken);
        if (secondsSinceFmEpoch == 0L) {
            return 0L;
        }
        long millisSinceFmEpoch = secondsSinceFmEpoch * 1000L;
        long millisSinceUnixEpoch = millisSinceFmEpoch - FM_EPOCH_OFFSET;
        return millisSinceUnixEpoch - (long)TimeZone.getDefault().getOffset(millisSinceUnixEpoch);
    }

    private native long _getDateTimeValue(long var1);

    public void setDateTimeValue(long date) {
        Calendar sharedCalendar = Calendar.getInstance();
        sharedCalendar.setTimeInMillis(date);
        int year = sharedCalendar.get(1);
        int month = sharedCalendar.get(2) + 1;
        int day = sharedCalendar.get(5);
        int hour = sharedCalendar.get(11);
        int minute = sharedCalendar.get(12);
        int second = sharedCalendar.get(13);
        this._setDateValue(this.cDataToken, year, month, day, hour, minute, second);
    }

    private native void _setDateValue(long var1, int var3, int var4, int var5, int var6, int var7, int var8);

    public FMText getFMText() {
        FMText newText = new FMText(this._getFMText(this.cDataToken), this);
        return newText;
    }

    private native long _getFMText(long var1);

    public FMBinaryInterface getFMBinary() {
        String stringData = this.getStringData();
        if (stringData != null && FileReference.isValidReferenceString(stringData)) {
            log.fine("stringData " + stringData + " is a REFERENCE");
            return new FileReference(stringData);
        }
        log.fine("stringData " + stringData + " is a STORED CONTAINER");
        return new FMBinary(this._getFMBinary(this.cDataToken), this);
    }

    private native long _getFMBinary(long var1);

    public void setFMBinary(FMBinary binary) {
        this._setFMBinary(this.cDataToken, binary.cToken());
    }

    private native void _setFMBinary(long var1, long var3);

    public boolean isEmpty() {
        return this._isEmpty(this.cDataToken);
    }

    private native boolean _isEmpty(long var1);

    private native int _getNativeType(long var1);

    public Object getFMType() {
        int nativeType = this._getNativeType(this.cDataToken);
        switch (nativeType) {
            case 0: {
                throw new IllegalStateException("Invalid data type");
            }
            case 2: {
                return new FMNumber(new Double(this.getDoubleData()));
            }
            case 6: {
                return this.getFMBinary();
            }
            case 1: {
                return this.getFMText();
            }
        }
        return this.getFMText();
    }

    private static class FMDataConverter
    implements Converter {
        private FMDataConverter() {
        }

        public boolean canConvertTo(Class targetClass) {
            return targetClass == FMData.class;
        }

        public Object convertData(FMData param, Class targetClass) {
            return param.isEmpty() ? null : param;
        }
    }
}

