/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.fm.FMFileUtils;
import com.prosc.fmkit.Configurable;
import com.prosc.fmkit.FMException;
import com.prosc.fmkit.FMFunction;
import com.prosc.fmkit.FileMakerOperation;
import com.prosc.fmkit.FmCalculationException;
import com.prosc.fmkit.IdleHandler;
import com.prosc.fmkit.MethodScanner;
import com.prosc.fmkit.Plugin;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.StaticFunction;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMType;
import com.prosc.laf.WindowsFontPatch;
import com.prosc.license.client.ExpiredLicenseException;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.Permission;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import sun.awt.EmbeddedFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginBridge {
    public static final short FM_PRO = 0;
    public static final short FM_DEVELOPER = 1;
    public static final short FM_RUNTIME = 2;
    public static final short FM_SERVER = 3;
    public static final short FM_WEB = 4;
    public static final short FM_MOBILE = 5;
    public static final short IDLESTATE_IDLE = 0;
    public static final short IDLESTATE_NOTIDLE = 1;
    public static final short IDLESTATE_SCRIPT_PAUSED = 2;
    public static final short IDLESTATE_SCRIPT_RUNNING = 3;
    public static final short IDLESTATE_UNSAFE = 4;
    public static final short SCRIPT_HALT = 0;
    public static final short SCRIPT_EXIT = 1;
    public static final short SCRIPT_RESUME = 2;
    public static final short SCRIPT_PAUSE = 3;
    public static final short VERSION_40 = 11;
    public static final short VERSION_41 = 12;
    public static final short VERSION_50 = 14;
    public static final short VERSION_60 = 17;
    public static final short VERSION_70 = 50;
    public static final short VERSION_80 = 51;
    public static final short BAD_VERSION = -1;
    public static final short DO_NOT_ENABLE = -2;
    public static final short VERSION_CURRENT = 51;
    public static final short VERSION_MIN = 4;
    public static final short VERSION_MAX = 255;
    private static PluginBridge sharedInstance;
    private static String pluginClassName;
    private static String bundlePath;
    private static String bridgeVersion;
    private static File pluginFile;
    private static short applicationType;
    private static AtomicInteger eventLoopDepth;
    private Exception lastOperationStackTrace;
    private static final Logger log;
    private static final Level DEFAULT_LOG_LEVEL;
    private Thread mainThread = null;
    private short apiVersion;
    private long instanceID;
    private Plugin thePlugin;
    private boolean hasBeenInitialized = false;
    private List<PluginFunction> functionsToRegister;
    private Map<Short, PluginFunction> functionIDMap;
    private final Object fmInvocationLock = new Object();
    private Stack<PluginContext> currentContextStack = new Stack();
    private int callCounter = 0;
    private static long frontWindowRef;
    private boolean isAwtInitialized = false;
    private static final String CR;
    private static File logFile;
    private static File version8lib;
    private Throwable lastErrorComplainedAbout = null;
    private static EmbeddedFrame embeddedFrame;
    private static File pluginJar;
    private static boolean version8Loaded;
    private final LinkedList<FileMakerOperation> operationQueue = new LinkedList();
    private static final byte[] xmlBytePrefix;

    private PluginBridge(Class<? extends Plugin> thePluginClass) {
        try {
            System.setSecurityManager(new SecurityManager(){

                public void checkPermission(Permission perm) {
                    this.checkPermission(perm, null);
                }

                public void checkPermission(Permission perm, Object context) {
                    if ("setSecurityManager".equals(perm.getName())) {
                        String message = "You cannot change the security manager once it is installed by the 360Works plugin library";
                        log.info(message);
                        throw new SecurityException(message);
                    }
                }
            });
            log.info("360Works custom SecurityManager has been installed");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            this.thePlugin = thePluginClass.newInstance();
            this.thePlugin.setPluginBridge(this);
        }
        catch (InstantiationException e) {
            log.log(Level.SEVERE, e.toString(), e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.SEVERE, e.toString(), e);
        }
        catch (ClassCastException e) {
            log.log(Level.SEVERE, e.toString(), e);
        }
        this.functionsToRegister = new LinkedList<PluginFunction>();
        this.functionIDMap = new HashMap<Short, PluginFunction>();
    }

    public static PluginBridge sharedInstance(String bundlePathString, String bridgeVersion, short applicationType, String logpath) {
        if (sharedInstance == null) {
            File bundleFile;
            PluginBridge.applicationType = applicationType;
            bundlePath = bundlePathString;
            PluginBridge.bridgeVersion = bridgeVersion;
            PluginBridge.initLogging(logpath);
            String pathToJarFile = bundlePathString;
            int semicolonIndex = bundlePathString.indexOf(";");
            if (semicolonIndex > 0) {
                pathToJarFile = bundlePathString.substring(semicolonIndex + 1);
                bundlePathString = bundlePathString.substring(0, semicolonIndex);
            }
            if (!(bundleFile = new File(bundlePathString)).exists()) {
                throw new IllegalArgumentException("bundle path does not exist: " + bundleFile.getAbsolutePath());
            }
            try {
                if (bundleFile.isDirectory() && bundleFile.getName().equalsIgnoreCase("Resources")) {
                    PluginBridge.initMac(bundleFile);
                } else if (bundleFile.getName().endsWith(".fmx")) {
                    PluginBridge.initWindows(bundleFile, pathToJarFile);
                } else {
                    String msg = "Unknown bundlePath format '" + bundlePath + "' -- should end in '.fmx' or 'Resources'.";
                    log.log(Level.SEVERE, msg);
                    throw new IllegalArgumentException(msg);
                }
                log.log(Level.FINE, "PluginBridge loaded successfully");
            }
            catch (ClassNotFoundException e) {
                String msg = "Unable to locate current directory context, or could not load plugin class: " + e.getMessage();
                log.log(Level.SEVERE, msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Error e) {
                log.log(Level.SEVERE, e.toString(), e);
                throw e;
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, e.toString(), e);
                throw e;
            }
        }
        if (sharedInstance == null) {
            log.log(Level.SEVERE, "PluginBridge initialization failed");
        }
        return sharedInstance;
    }

    private static void initMac(File bundlePath) throws ClassNotFoundException {
        log.log(Level.FINE, "Initializing MAC plugin");
        pluginJar = new File(bundlePath, "Java/plugin.jar");
        version8lib = new File(bundlePath.getParentFile(), "MacOS/version8lib.jnilib");
        File jniLib = new File(bundlePath.getParentFile(), "MacOS/JaCK3");
        String libPath = jniLib.getAbsolutePath();
        log.log(Level.CONFIG, "Loading dynamic library at {0}", libPath);
        if (!jniLib.exists()) {
            throw new RuntimeException("jnilib file does not exist at path: " + libPath);
        }
        System.load(libPath);
        log.log(Level.CONFIG, "Loading plugin jar at {0}", pluginJar.getAbsolutePath());
        String className = PluginBridge.getPluginClassNameForPluginJar(pluginJar);
        Class<?> pluginClass = Class.forName(className);
        sharedInstance = new PluginBridge(pluginClass);
        pluginFile = bundlePath.getParentFile().getParentFile();
    }

    private static void initWindows(File bundlePath, String pathToJarFile) throws ClassNotFoundException {
        log.log(Level.FINE, "Initializing WIN plugin");
        pluginJar = new File(pathToJarFile);
        String sharedLibPath = bundlePath.getAbsolutePath();
        version8lib = null;
        log.log(Level.CONFIG, "Loading dynamic library at {0}", sharedLibPath);
        System.load(sharedLibPath);
        log.log(Level.CONFIG, "Loading plugin jar at {0}", pluginJar.getAbsolutePath());
        String className = PluginBridge.getPluginClassNameForPluginJar(pluginJar);
        Class<?> pluginClass = Class.forName(className);
        sharedInstance = new PluginBridge(pluginClass);
        pluginFile = bundlePath;
    }

    public static File getPluginFile() {
        return pluginFile;
    }

    public static File getPluginJar() {
        return pluginJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPluginClassNameForPluginJar(File pluginFile) {
        if (pluginClassName == null) {
            try {
                log.log(Level.FINE, "Reading Manifest file to determine plugin className");
                JarFile pluginJarFile = new JarFile(pluginFile, true);
                try {
                    Manifest manifest = pluginJarFile.getManifest();
                    pluginClassName = manifest.getMainAttributes().getValue("pluginClassName");
                    if (pluginClassName == null) {
                        pluginClassName = manifest.getMainAttributes().getValue("main-class");
                    }
                }
                finally {
                    pluginJarFile.close();
                }
            }
            catch (IOException e) {
                String message = "Unable to parse manifest data from " + pluginFile;
                log.severe(message);
                throw new RuntimeException(message, e);
            }
        }
        log.log(Level.CONFIG, "Loading Plugin class named {0}", pluginClassName);
        return pluginClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short fmxInit(short apiVersion, String versionString, long instanceID, boolean unsafeCalls, long cStartScript, long cCurrentEnv) {
        log.fine("fmxInit(" + apiVersion + ", " + applicationType + ", " + versionString + ", " + instanceID + ", " + unsafeCalls + ", " + cStartScript + ", " + cCurrentEnv + ")");
        this.apiVersion = apiVersion;
        this.instanceID = instanceID;
        if (apiVersion < 4) return -1;
        if (apiVersion > 255) {
            return -1;
        }
        if (apiVersion >= 51) {
            try {
                this.loadVersion8Lib();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Unable to load version8lib", e);
            }
        }
        try {
            if (!this.isHeadless()) {
                if (PluginUtils.isMac()) {
                    this.initAwt();
                } else {
                    try {
                        UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
                        new WindowsFontPatch().patch();
                    }
                    catch (UnsupportedLookAndFeelException e) {
                        log.warning("Windows Look and Feel is not installed");
                    }
                }
            }
            String logInfo = "Creating shared PluginBridge instance / " + this.getSystemEnvironment();
            log.info(logInfo);
            log.config("Initialize " + this.thePlugin.getName());
            PluginContext pluginContext = new PluginContext(this, this.thePlugin, unsafeCalls, cStartScript, cCurrentEnv, 0L, Thread.currentThread(), null);
            try {
                this.pushContext(pluginContext);
                this.thePlugin.setApplicationType(applicationType);
                if (!this.thePlugin.isVersionCompatible(apiVersion, applicationType)) {
                    short s = -1;
                    return s;
                }
                this.thePlugin.init(this);
                this.scanFunctions();
                this.registerAllFunctions();
            }
            finally {
                this.popContext();
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, "Could not initialize plugin", e);
            throw e;
        }
        catch (Error e) {
            log.log(Level.SEVERE, "Could not initialize plugin", e);
            throw e;
        }
        this.hasBeenInitialized = true;
        log.config("Return VERSION_CURRENT: 51");
        return 51;
    }

    private void loadVersion8Lib() throws IOException {
        if (version8lib != null) {
            log.config("Loading the version 8 library from " + version8lib);
            try {
                System.load(version8lib.getAbsolutePath());
                version8Loaded = true;
                log.config("Version 8 lib was loaded successfully");
            }
            catch (Throwable t) {
                IOException exception = new IOException("unable to load version8lib");
                exception.initCause(t);
                throw exception;
            }
        } else {
            log.config("version 8 lib is null, will not load");
        }
    }

    public String getSystemEnvironment() {
        return "plugin bridge version " + bridgeVersion + CR + "bundlePath: " + bundlePath + CR + "jvm version: " + System.getProperty("java.vm.version") + " from " + System.getProperty("java.home") + CR + "Operating system info: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " running on " + System.getProperty("os.arch") + " architecture";
    }

    public static File getLogFile() {
        return logFile;
    }

    private static void initLogging(String logpath) {
        if (logpath == null) {
            try {
                logFile = File.createTempFile("360PluginLog", ".log");
            }
            catch (IOException e) {
                logFile = new File("/360PluginLog.log");
                log.log(Level.SEVERE, "Could not create a log file. logpath param is null. Will write to " + logFile, e);
            }
        } else {
            logFile = new File(logpath);
        }
        try {
            Logger proscLog = LogManager.getLogManager().getLogger("com.prosc");
            if (proscLog == null) {
                proscLog = Logger.getLogger("com.prosc");
                proscLog.setLevel(DEFAULT_LOG_LEVEL);
            }
            if (!logFile.canWrite()) {
                log.log(Level.SEVERE, "Cannot write to provided log path: " + logFile);
            } else {
                FileHandler fmkitLogHandler = new FileHandler(logFile.getAbsolutePath(), true);
                fmkitLogHandler.setLevel(Level.ALL);
                fmkitLogHandler.setFormatter(new SimpleFormatter());
                Logger.getLogger("").addHandler(fmkitLogHandler);
                proscLog.log(DEFAULT_LOG_LEVEL, "Will write normal log file to " + logFile);
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Couldn't create fmkit log file.", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fmxIdle(short idleState, boolean unsafeCalls, long cStartScript, long cCurrentEnv) {
        if (unsafeCalls) {
            return;
        }
        try {
            if (this.mainThread == null && (Thread.currentThread().getName().equals("AWT-AppKit") || Thread.currentThread().getName().equals("Thread-0") || Thread.currentThread().getName().equals("main"))) {
                this.mainThread = Thread.currentThread();
            }
            if (Thread.currentThread() != this.mainThread) {
                return;
            }
            PluginContext context = new PluginContext(this, this.thePlugin, unsafeCalls, cStartScript, cCurrentEnv, 0L, Thread.currentThread(), null);
            try {
                this.pushContext(context);
                ((IdleHandler)((Object)this.thePlugin)).doIdle(idleState);
            }
            finally {
                this.popContext();
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Uncaught exception in idle handler", t);
        }
    }

    public void fmxShutdown(boolean unsafeCalls, long cStartScript, long cCurrentEnv) {
        try {
            this.pushContext(new PluginContext(this, this.thePlugin, unsafeCalls, cStartScript, cCurrentEnv, 0L, Thread.currentThread(), null));
            this.thePlugin.shutdown();
            Thread[] activeThreads = new Thread[Thread.activeCount()];
            Thread.enumerate(activeThreads);
            log.info("Shutting down - Active threads: " + Arrays.asList(activeThreads));
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, "Could not shut down plugin", e);
            throw e;
        }
        catch (Error e) {
            log.log(Level.SEVERE, "Could not shut down plugin", e);
            throw e;
        }
        finally {
            this.popContext();
        }
        log.config("Shutting down PluginBridge");
    }

    public void fmxDoAppPreferences(final boolean unsafeCalls, final long cStartScript, final long cCurrentEnv) {
        try {
            if (this.thePlugin instanceof Configurable) {
                if (this.isHeadless()) {
                    log.warning("Cannot show preferences in headless mode");
                    return;
                }
                Runnable pluginTask = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        log.log(Level.CONFIG, "Configuring {0}", PluginBridge.this.thePlugin);
                        try {
                            PluginBridge.this.pushContext(new PluginContext(PluginBridge.this, PluginBridge.this.thePlugin, unsafeCalls, cStartScript, cCurrentEnv, 0L, Thread.currentThread(), null));
                            ((Configurable)((Object)PluginBridge.this.thePlugin)).configure();
                        }
                        catch (Throwable t) {
                            log.log(Level.SEVERE, "Error occurred while configuring plugin preferences", t);
                        }
                        finally {
                            PluginBridge.this.popContext();
                        }
                    }
                };
                this.runTask(pluginTask, true, PluginBridge._getFrontWindowReference());
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Unexpected exception while displaying preferences", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short doFunction(short functionID, long[] parameterTokens, long resultHolderCToken, boolean unsafeCalls, long cStartScript, long cCurrentEnv) {
        final short[] result = new short[1];
        final PluginFunction theFunction = this.functionIDMap.get(functionID);
        try {
            block34: {
                int n;
                log.fine("=== doFunction " + theFunction.getName() + " called on thread: " + Thread.currentThread().getName() + ", eventLoopDepth is " + eventLoopDepth + " ===");
                if (theFunction == null) {
                    throw new FMException(-3, "No function registered for code " + functionID);
                }
                log.log(Level.FINER, "{0} will invoke function {1} with {2} arguments", new Object[]{this, theFunction, parameterTokens.length});
                if (log.isLoggable(Level.FINEST)) {
                    StringBuffer tokens = new StringBuffer("Parameter tokens for call to " + theFunction.getName() + ": ");
                    for (n = 0; n < parameterTokens.length; ++n) {
                        if (n > 0) {
                            tokens.append("; ");
                        }
                        tokens.append("[" + n + "]=" + parameterTokens[n]);
                    }
                    log.finest(tokens.toString());
                }
                Object rawParameters = new FMData[parameterTokens.length];
                for (n = 0; n < parameterTokens.length; ++n) {
                    rawParameters[n] = new FMData(parameterTokens[n]);
                }
                final Object[] parameters = theFunction.convertParams((FMData[])rawParameters);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Parameters: " + Arrays.asList(parameters));
                }
                final PluginContext pluginContext = new PluginContext(this, this.thePlugin, unsafeCalls, cStartScript, 0L, cCurrentEnv, Thread.currentThread(), theFunction);
                log.log(Level.FINER, "Created new PluginContext {0}", pluginContext);
                try {
                    this.pushContext(pluginContext);
                    boolean spawnEventLoop = theFunction.isGuiFunction() && !this.isHeadless();
                    Runnable pluginTask = new Runnable(){

                        public void run() {
                            log.config("=== Executing plugin function " + theFunction.getName() + " on thread " + Thread.currentThread().getName() + " ===");
                            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                            PluginBridge.this.thePlugin.invokeFunctionNoErrors(theFunction, parameters, pluginContext);
                            log.log(Level.FINE, "Invocation of {0} successful on thread {1}", new Object[]{theFunction, Thread.currentThread().getName()});
                            result[0] = 0;
                        }

                        public String toString() {
                            return "Run task for plugin function: " + theFunction;
                        }
                    };
                    this.runTask(pluginTask, spawnEventLoop, PluginBridge._getThreadWindowReference());
                    FMType functionResult = pluginContext.getFunctionResult();
                    if (functionResult == null) {
                        log.log(Level.WARNING, "Function result was null in main thread " + Thread.currentThread().getName() + " for " + theFunction + "; replacing with empty string");
                        functionResult = new FMText("");
                    }
                    log.log(Level.FINE, "Result in main thread " + Thread.currentThread().getName() + ": " + functionResult);
                    FMData resultHolder = new FMData(resultHolderCToken);
                    functionResult.writeToData(resultHolder);
                    if (this.thePlugin.getLastError() == null || this.thePlugin.getLastError() == this.lastErrorComplainedAbout || this.isHeadless() || !this.thePlugin.allowErrorDialogs()) break block34;
                    try {
                        if (this.thePlugin.getLastError() instanceof ExpiredLicenseException || this.getCurrentContext().evaluateExpression("Get(ErrorCaptureState)=0 and not isempty(Get(ScriptName))").getLongData() == 1L) {
                            this.lastErrorComplainedAbout = this.thePlugin.getLastError();
                            final String lastErrorString = this.thePlugin.getLastErrorString();
                            final String title = this.thePlugin.getName() + " Error";
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JOptionPane.showMessageDialog(null, lastErrorString, title, 0);
                                }
                            });
                        }
                    }
                    catch (Throwable e) {
                        log.log(Level.SEVERE, "Unable to show error dialog for " + this.thePlugin.getLastError(), e);
                    }
                }
                finally {
                    this.popContext();
                }
            }
            if (++this.callCounter == 10000) {
                log.fine("Garbage collection");
                System.gc();
                this.callCounter = 0;
            }
        }
        catch (FMException e) {
            log.log(Level.SEVERE, "FMException: " + e.toString(), e);
            result[0] = e.getErrorCode();
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Throwable: " + t.toString(), t);
            result[0] = -1;
        }
        finally {
            log.fine("finished doFunction: " + theFunction.getName());
            Object e = this.fmInvocationLock;
            synchronized (e) {
                if (this.currentContextStack.size() == 0) {
                    PluginBridge._clearMemory();
                }
            }
        }
        return result[0];
    }

    private boolean isScriptRunning(PluginContext context) {
        try {
            return context.evaluateExpression("not IsEmpty(Get(ScriptName))").getLongData() == 1L;
        }
        catch (FmCalculationException e) {
            log.log(Level.WARNING, "Could not determine whether script is running: " + e, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTask(final Runnable task, boolean spawnEventLoop, final long currentWindowRef) throws Exception {
        block16: {
            if (spawnEventLoop) {
                final AtomicBoolean isTaskFinished = new AtomicBoolean(false);
                Runnable guiTask = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            if (eventLoopDepth.intValue() == 1) {
                                PluginBridge.setRootFrameParent(currentWindowRef);
                            } else {
                                log.fine("Don't create root frame parent, because eventLoopDepth is " + eventLoopDepth);
                            }
                            log.fine("task.run start: " + task.toString());
                            task.run();
                            log.fine("task.run stop: " + task.toString());
                        }
                        catch (Throwable t) {
                            log.log(Level.SEVERE, "Error while running GUI task: " + task, t);
                        }
                        finally {
                            log.fine("guiTask finished processing: " + task.toString());
                            if (eventLoopDepth.intValue() == 1) {
                                PluginBridge.finishedRootFrame();
                            }
                            isTaskFinished.set(true);
                            PluginBridge.stopEventLoop();
                        }
                    }
                };
                if (!FMFileUtils.isMac) {
                    PluginBridge.enableWindow(currentWindowRef, false);
                    log.fine("Disabled window " + currentWindowRef + " / " + PluginBridge._getWindowTitle(currentWindowRef) + " / thread ID: " + PluginBridge._getWindowThreadId(currentWindowRef) + " / is child: " + PluginBridge._isChildWindow(currentWindowRef));
                }
                try {
                    this.initAwt();
                    int newDepth = eventLoopDepth.incrementAndGet();
                    log.fine("eventLoopDepth was incremented to " + newDepth + "; Triggering main startEventLoop() for Runnable: " + task);
                    Object eventRunLock = new Object();
                    InvocationEvent event = new InvocationEvent((Object)Toolkit.getDefaultToolkit(), guiTask, eventRunLock, true);
                    log.fine("Posting plugin task to system event queue: " + task);
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(event);
                    while (true) {
                        PluginBridge.startEventLoop();
                        if (isTaskFinished.get() || eventLoopDepth.intValue() > 1) break;
                        log.info("*** Event loop finished before isTaskFinished flag was set; re-entering event loop");
                    }
                    if (eventLoopDepth.intValue() > 0) {
                        log.fine("Main event loop finished; current eventLoopDepth is " + eventLoopDepth + "; decrementing eventLoopDepth. Main thread task: " + task);
                        eventLoopDepth.decrementAndGet();
                    }
                    int extraLoops = 0;
                    while (eventLoopDepth.intValue() != 0) {
                        log.fine("Triggering extra event loop to finish re-entrant calls, extraLoops is now " + ++extraLoops + " and eventLoopDepth is " + eventLoopDepth);
                        PluginBridge.startEventLoop();
                        newDepth = eventLoopDepth.decrementAndGet();
                        log.fine("Decremented eventLoopLock to " + newDepth);
                    }
                    while (extraLoops > 0) {
                        log.fine("Stopping extra event loop to unwind re-entrant calls, there are " + extraLoops + " to unwind");
                        PluginBridge.stopEventLoop();
                        --extraLoops;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("<< FINISHED ALL EVENT LOOPS for " + task + "; eventLoopDepth is " + eventLoopDepth + " >>");
                    }
                    Object object = eventRunLock;
                    synchronized (object) {
                        while (true) {
                            if (isTaskFinished.get()) break;
                            int timeToWait = 5000;
                            eventRunLock.wait(timeToWait);
                            log.warning("We have been waiting " + timeToWait + " milliseconds; may be deadlocked. This can be caused if startEventLoop() exits prematurely and stops pumping events. Will continue to wait, but this will probably not release.");
                        }
                        log.fine("isTaskFinished AtomicBoolean flag is set to true; returning from runTask()");
                    }
                    if (event.getException() != null) {
                        throw event.getException();
                    }
                    break block16;
                }
                finally {
                    if (!FMFileUtils.isMac) {
                        PluginBridge.enableWindow(currentWindowRef, true);
                        PluginBridge._setForegroundWindow(currentWindowRef);
                        log.fine("Enabled and set foreground window " + currentWindowRef + " / " + PluginBridge._getWindowTitle(currentWindowRef) + " / thread ID: " + PluginBridge._getWindowThreadId(currentWindowRef) + " / is child: " + PluginBridge._isChildWindow(currentWindowRef));
                    }
                }
            }
            task.run();
        }
    }

    private static void setRootFrameParent(long currentWindow) {
        log.fine("FrontWindowRef is " + frontWindowRef + " / Current window is " + currentWindow);
        if (FMFileUtils.isMac || currentWindow != frontWindowRef) {
            log.fine("Current window changed from  " + frontWindowRef + "  to " + currentWindow + "; setting root frame parent");
            log.fine(Thread.currentThread() + ": Setting root frame to window " + currentWindow + " / " + PluginBridge._getWindowTitle(currentWindow) + " / thread ID: " + PluginBridge._getWindowThreadId(currentWindow) + " / is child: " + PluginBridge._isChildWindow(currentWindow));
            if (embeddedFrame != null) {
                log.warning("*** setRootFrameParent was called when there is already an embeddedFrame! Disposing.");
                PluginBridge.finishedRootFrame();
            }
            frontWindowRef = currentWindow;
            try {
                Class<?> nativeFrameClass = FMFileUtils.isMac ? Class.forName("apple.awt.CEmbeddedFrame") : Class.forName("sun.awt.windows.WEmbeddedFrame");
                Constructor<?> constructor = nativeFrameClass.getConstructor(Long.TYPE);
                Long peerInfo = frontWindowRef;
                embeddedFrame = (EmbeddedFrame)constructor.newInstance(peerInfo);
                embeddedFrame.pack();
                Method setBoundsMethod = EmbeddedFrame.class.getDeclaredMethod("setBoundsPrivate", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                setBoundsMethod.setAccessible(true);
                setBoundsMethod.invoke((Object)embeddedFrame, 300, 300, 0, 0);
                embeddedFrame.setVisible(true);
                JOptionPane.setRootFrame(embeddedFrame);
            }
            catch (Throwable t) {
                log.log(Level.WARNING, "Could not set the parent for the root frame, modal dialogs will not work correctly", t);
            }
        }
    }

    public static void finishedRootFrame() {
        try {
            log.fine("Disposing embeddedFrame");
            embeddedFrame.dispose();
            embeddedFrame = null;
            frontWindowRef = 0L;
            JOptionPane.setRootFrame(null);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "Could not dispose of root frame", t);
        }
    }

    private void initAwt() {
        if (this.isAwtInitialized) {
            return;
        }
        if (FMFileUtils.isMac) {
            log.fine("initAwt called in Java");
            Runnable startAwt = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Toolkit toolkit = Toolkit.getDefaultToolkit();
                        toolkit.getSystemEventQueue().peekEvent();
                        log.info("Initialized AWT successfully  from " + Thread.currentThread());
                    }
                    finally {
                        PluginBridge.stopEventLoop();
                    }
                }
            };
            Thread awtThread = new Thread(startAwt);
            awtThread.start();
            PluginBridge.startEventLoop();
        } else {
            try {
                Class.forName("sun.awt.windows.WToolkit").getMethod("embeddedInit", new Class[0]).invoke(null, new Object[0]);
                log.info("Initialized AWT successfully from " + Thread.currentThread());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not initialize AWT", e);
            }
        }
        this.isAwtInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushContext(PluginContext pluginContext) {
        LinkedList<FileMakerOperation> queueCopy;
        AbstractList previousCalls;
        Object object = this.fmInvocationLock;
        synchronized (object) {
            if (this.currentContextStack.size() > 0) {
                previousCalls = new ArrayList<PluginFunction>(this.currentContextStack.size());
                for (PluginContext context : this.currentContextStack) {
                    previousCalls.add(context.getWhichFunction());
                }
                log.log(Level.WARNING, "pushContext called with function (" + pluginContext.getWhichFunction() + ") when stack size is " + this.currentContextStack.size() + "; this either means it was called re-entrantly, an idle handler was called without waiting for a return from a previous call, or pop was not called from last invocation. Current thread: " + Thread.currentThread().getName() + "\nPrevious calls: " + previousCalls);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Here is the first operation on the context stack", this.lastOperationStackTrace);
                }
            } else if (log.isLoggable(Level.FINE)) {
                this.lastOperationStackTrace = new RuntimeException("First item on context queue is plugin function: " + pluginContext.getWhichFunction());
            }
            this.currentContextStack.push(pluginContext);
            this.fmInvocationLock.notifyAll();
        }
        previousCalls = this.operationQueue;
        synchronized (previousCalls) {
            queueCopy = new LinkedList<FileMakerOperation>(this.operationQueue);
            this.operationQueue.clear();
        }
        for (FileMakerOperation operation : queueCopy) {
            try {
                operation.run(pluginContext);
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Unexpected error while calling queued FileMakerOperation", e);
            }
        }
        LinkedList<FileMakerOperation> linkedList = this.operationQueue;
        synchronized (linkedList) {
            this.operationQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popContext() {
        Object object = this.fmInvocationLock;
        synchronized (object) {
            try {
                PluginContext context = this.currentContextStack.pop();
                if (context.getWhichFunction() != null) {
                    log.fine("Popped context for function " + context.getWhichFunction());
                }
            }
            catch (EmptyStackException e) {
                log.log(Level.WARNING, "popContext was called with an empty currentContextStack. Current thread: " + Thread.currentThread().getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginContext getCurrentContext() {
        try {
            Object object = this.fmInvocationLock;
            synchronized (object) {
                while (this.currentContextStack.isEmpty()) {
                    this.fmInvocationLock.wait();
                }
                return this.currentContextStack.peek();
            }
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "Plugin was interrupted while waiting for context; returning null", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeFileMakerOperation(FileMakerOperation runnable) throws InterruptedException {
        PluginContext context = this.getCurrentContext();
        if (context.getFilemakerThread() == Thread.currentThread()) {
            runnable.run(context);
        } else {
            LinkedList<FileMakerOperation> linkedList = this.operationQueue;
            synchronized (linkedList) {
                this.operationQueue.addLast(runnable);
                while (this.operationQueue.contains(runnable)) {
                    this.operationQueue.wait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueFileMakerOperation(FileMakerOperation runnable) {
        PluginContext context = this.getCurrentContext();
        if (context.getFilemakerThread() == Thread.currentThread()) {
            runnable.run(context);
        } else {
            LinkedList<FileMakerOperation> linkedList = this.operationQueue;
            synchronized (linkedList) {
                this.operationQueue.addLast(runnable);
            }
        }
    }

    private static void startEventLoop() {
        log.fine("-> Starting event loop from Thread (" + Thread.currentThread().getName() + ")...");
        try {
            PluginBridge._startEventLoop(frontWindowRef);
        }
        catch (Error e) {
            log.log(Level.WARNING, "Error occurred while starting run loop", e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "RuntimeException occurred while starting run loop", e);
            throw e;
        }
        finally {
            log.fine("event loop has finished");
        }
    }

    private static native void _startEventLoop(long var0);

    private static native void _clearMemory();

    private static void stopEventLoop() {
        log.fine("<- Stopping event loop from Thread (" + Thread.currentThread() + ")...");
        PluginBridge._stopEventLoop(frontWindowRef);
        log.fine("Event loop is now stopped");
    }

    private static native void _stopEventLoop(long var0);

    private void scanFunctions() {
        log.log(Level.FINE, "{0} scanning functions", this);
        for (Method eachMethod : MethodScanner.findFMFunctions(this.thePlugin.getClass())) {
            if (eachMethod.getName().equals("invokeFunction") || Modifier.isStatic(eachMethod.getModifiers())) continue;
            try {
                StaticFunction eachFunction = new StaticFunction(eachMethod);
                String prototype = "";
                FMFunction annotation = eachFunction.getTargetMethod().getAnnotation(FMFunction.class);
                if (annotation != null) {
                    prototype = annotation.prototype();
                } else {
                    String prototypeMethodName = eachFunction.getName() + "Prototype";
                    try {
                        Method prototypeMethod = this.thePlugin.getClass().getMethod(prototypeMethodName, new Class[0]);
                        prototype = (String)prototypeMethod.invoke((Object)this.thePlugin, new Object[0]);
                        log.finer("Found prototype method named " + prototypeMethodName + " which returned " + prototype);
                    }
                    catch (NoSuchMethodException e) {
                        log.fine("Couldn't find prototype method: " + prototypeMethodName);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Error when trying to invoke the prototype method", e);
                    }
                }
                eachFunction.setPrototype(prototype);
                int firstBracketIndex = prototype.indexOf(91);
                if (firstBracketIndex == -1) {
                    firstBracketIndex = prototype.indexOf(123);
                }
                if (firstBracketIndex >= 0) {
                    int minArgs = prototype.startsWith("[") || prototype.startsWith("{") ? 0 : prototype.substring(0, firstBracketIndex).split(";").length;
                    eachFunction.setMinArgs(minArgs);
                }
                if (!this.thePlugin.customizeFunction(eachFunction)) continue;
                this.queueFunction(eachFunction);
            }
            catch (FMType.UnsupportedTypeConversionException e) {
                log.log(Level.WARNING, "Can't do conversions for at least one plugin function", e);
            }
        }
    }

    private void queueFunction(PluginFunction theFunction) {
        this.functionsToRegister.add(theFunction);
        if (this.hasBeenInitialized) {
            // empty if block
        }
    }

    private void registerAllFunctions() {
        for (PluginFunction aFunctionsToRegister : this.functionsToRegister) {
            this.registerFunction(aFunctionsToRegister);
        }
    }

    public void registerFunction(PluginFunction theFunction) {
        log.log(Level.FINE, "{0} registering {1}", new Object[]{this, theFunction});
        Short functionId = theFunction.getFunctionID();
        String functionSignature = theFunction.getName();
        if (theFunction.getPrototype().trim().length() > 0) {
            functionSignature = functionSignature + "( " + theFunction.getPrototype() + " )";
        }
        log.fine("Registering function in C++ with params " + this.thePlugin.getShortId().toString() + ", " + theFunction.getFunctionID() + ", " + theFunction.getName() + ", " + functionSignature + ", " + theFunction.getMinArgs() + ", " + theFunction.getMaxArgs() + ", " + theFunction.getFlags());
        PluginFunction oldFunction = this.functionIDMap.get(functionId);
        if (oldFunction != null) {
            log.warning("*** WARNING: function " + theFunction.getName() + " with ID " + functionId + " has already been registered with the function ID for " + oldFunction.getName() + ". " + theFunction.getName() + " will replace it in the function list.");
            this._unregisterFunction(this.thePlugin.getShortId().toString(), theFunction.getFunctionID());
        }
        this._registerFunction(this.thePlugin.getShortId().toString(), theFunction.getFunctionID(), theFunction.getName(), functionSignature, theFunction.getMinArgs(), theFunction.getMaxArgs(), theFunction.getFlags());
        this.functionIDMap.put(functionId, theFunction);
    }

    public void unregisterFunction(short functionId) {
        log.log(Level.FINE, "{0} unregistering function with ID {1}", new Object[]{this, functionId});
        PluginFunction oldFunction = this.functionIDMap.get(functionId);
        if (oldFunction == null) {
            log.warning("*** WARNING: function was never registerd with ID " + functionId + "; it cannot be unregistered.");
        }
        this._unregisterFunction(this.thePlugin.getShortId().toString(), functionId);
        this.functionIDMap.remove(functionId);
    }

    public String[] getClipboardFormats() {
        String[] result;
        if (FMFileUtils.isMac) {
            result = (String[])PluginBridge._getClipboardFormatsMac();
        } else {
            int[] formats = PluginBridge._getClipboardFormatsWin();
            result = new String[formats.length];
            for (int i = 0; i < formats.length; ++i) {
                result[i] = String.valueOf(formats[i]);
            }
        }
        return result;
    }

    public String getBestFileMakerClipboardFormat() {
        String[] preferredFormats = FMFileUtils.isMac ? new String[]{"dyn.agk8zuxnykk", "dyn.agk8zuxngku", "dyn.agk8zuxnqm6", "dyn.agk8zuxnxkq", "dyn.agk8zuxnxnq", "dyn.agk8zuxngm2", "com.apple.traditional-mac-plain-text"} : new String[]{"49547", "49670", "49662", "49633", "49619", "1", "49616", "49677"};
        HashSet<String> availableFormats = new HashSet<String>(Arrays.asList(this.getClipboardFormats()));
        for (String format : preferredFormats) {
            if (!availableFormats.contains(format)) continue;
            return format;
        }
        return null;
    }

    public byte[] getClipboardData(String whichFormat, boolean isFileMaker) {
        byte[] result;
        if (FMFileUtils.isMac) {
            result = PluginBridge._getClipboardDataMac(whichFormat);
        } else {
            byte[] tempResult = PluginBridge._getClipboardData(Integer.valueOf(whichFormat));
            if (isFileMaker && tempResult.length > 4 && !"1".equals(whichFormat)) {
                result = new byte[tempResult.length - 4];
                System.arraycopy(tempResult, 4, result, 0, result.length);
            } else {
                result = tempResult;
            }
        }
        return result;
    }

    public void setClipboardData(String whichFormat, byte[] data, boolean isFileMaker, boolean clearExisting) {
        if (FMFileUtils.isMac) {
            PluginBridge._setClipboardDataMac(whichFormat, data);
        } else {
            if (isFileMaker && !"1".equals(whichFormat)) {
                byte[] newData = new byte[data.length + 4];
                System.arraycopy(xmlBytePrefix, 0, newData, 0, 4);
                System.arraycopy(data, 0, newData, 4, data.length);
                data = newData;
            }
            PluginBridge._setClipboardData(Integer.valueOf(whichFormat), data, clearExisting);
            if (clearExisting && !FMFileUtils.isMac && !"2".equals(whichFormat)) {
                this.setClipboardData("2", new byte[0], false, false);
            }
        }
    }

    private static native int[] _getClipboardFormatsWin();

    private static native Object[] _getClipboardFormatsMac();

    private static native byte[] _getClipboardData(int var0);

    private static native byte[] _getClipboardDataMac(String var0);

    private static native void _setClipboardDataMac(String var0, byte[] var1);

    private static native long _getFrontWindowReference();

    private static native long _getThreadWindowReference();

    private static void enableWindow(long windowRef, boolean enable) {
        PluginBridge._enableWindow(windowRef, enable);
    }

    private static native void _enableWindow(long var0, boolean var2);

    private static native boolean _setForegroundWindow(long var0);

    private static native String _getWindowTitle(long var0);

    private static native long _getWindowThreadId(long var0);

    private static native boolean _isChildWindow(long var0);

    private static native void _setClipboardData(int var0, byte[] var1, boolean var2);

    private native void _registerFunction(String var1, short var2, String var3, String var4, int var5, int var6, int var7);

    private native void _unregisterFunction(String var1, short var2);

    public long getInstanceID() {
        return this.instanceID;
    }

    public Plugin getThePlugin() {
        return this.thePlugin;
    }

    public short getApiVersion() {
        return this.apiVersion;
    }

    private boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    static void clearSharedInstance() {
        log.log(Level.WARNING, "{0} clearing sharedInstance", sharedInstance);
        sharedInstance = null;
        pluginClassName = null;
        bundlePath = null;
    }

    public String toString() {
        return "PluginBridge{instanceID=" + this.instanceID + '}';
    }

    public static boolean isVersion8Loaded() {
        return version8Loaded;
    }

    static {
        eventLoopDepth = new AtomicInteger();
        log = Logger.getLogger(PluginBridge.class.getName());
        DEFAULT_LOG_LEVEL = Level.CONFIG;
        frontWindowRef = 0L;
        CR = System.getProperty("line.separator");
        version8Loaded = false;
        xmlBytePrefix = new byte[]{45, 9, 0, 0};
    }
}

