/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import pGraph.Chart;

class Pie
extends Chart {
    private Font percentFont;
    private Font groupFont;

    public Pie(Font font, Font font2, double[][] dArray, String[] stringArray, Paint[] paintArray, boolean bl) {
        super(dArray, stringArray, paintArray, bl);
        this.percentFont = font2;
        this.groupFont = font;
    }

    public Point2D.Float rotate(float f, float f2, Rectangle2D.Float float_) {
        double d = Math.toRadians(f2);
        return new Point2D.Float((float)(Math.cos(d) * (double)float_.width / 2.0 + (double)float_.x + (double)(float_.width / 2.0f)), (float)(-Math.sin(d) * (double)float_.height / 2.0 + (double)float_.y + (double)(float_.height / 2.0f) + (double)(f2 > 180.0f ? f : 0.0f)));
    }

    public void paint(Graphics2D graphics2D, Rectangle2D.Float float_) {
        int n = (int)Math.ceil(Math.sqrt(this.groupLength));
        int n2 = (int)Math.ceil((float)this.groupLength / (float)n);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.groupFont);
        Rectangle2D.Float float_2 = (Rectangle2D.Float)fontMetrics.getStringBounds("100.0%", graphics2D);
        for (int i = 0; i < this.groupLength; ++i) {
            Rectangle2D.Float float_3 = new Rectangle2D.Float(float_.x + (float_.width + 5.0f) / (float)n * (float)(i % n), float_.y + (float_.height + 5.0f) / (float)n2 * (float)(i / n), (float_.width - (float)((n - 1) * 5)) / (float)n, (float_.height - (float)((n2 - 1) * 5)) / (float)n2);
            if (i < this.groups.length) {
                graphics2D.setFont(this.groupFont);
                graphics2D.setPaint(Color.black);
                graphics2D.drawString(this.groups[i], float_3.x, float_3.y - float_2.y);
                float_3.y += float_2.height + 5.0f;
                float_3.height -= float_2.height + 5.0f;
            }
            FontMetrics fontMetrics2 = null;
            Rectangle2D.Float float_4 = null;
            if (this.percentFont != null) {
                fontMetrics2 = graphics2D.getFontMetrics(this.percentFont);
                float_4 = (Rectangle2D.Float)fontMetrics2.getStringBounds("99.9%", graphics2D);
                float_3.setRect((double)float_3.x + 7.5 + (double)float_4.width, (double)float_3.y + 7.5 + (double)float_4.height, (double)float_3.width - 2.0 * (7.5 + (double)float_4.width), (double)float_3.height - 2.0 * (7.5 + (double)float_4.height));
                graphics2D.setFont(this.percentFont);
            }
            float f = this.inset ? float_3.height * 0.100000024f / (float)n : 0.0f;
            Rectangle2D.Float float_5 = new Rectangle2D.Float(float_3.x, float_3.y, float_3.width, float_3.height - f);
            Rectangle2D.Float float_6 = new Rectangle2D.Float(float_3.x - 5.0f, float_3.y - 5.0f, float_3.width + 10.0f, float_3.height - f + 10.0f);
            double d = 0.0;
            for (int j = 0; j < this.values.length; ++j) {
                float f2;
                if (i >= this.values[j].length) continue;
                float f3 = (float)(d * 360.0 / this.totals[i]);
                float f4 = (float)(this.values[j][i] * 360.0 / this.totals[i]);
                d += this.values[j][i];
                graphics2D.setPaint(this.paints[j]);
                graphics2D.fill(new Arc2D.Float(float_5, f3, f4, 2));
                if (f3 + f4 > 180.0f) {
                    float f5 = Math.max(180.0f, f3);
                    f2 = f4 - f5 + f3;
                    GeneralPath generalPath = new GeneralPath(new Arc2D.Float(float_5, f5, f2, 0));
                    generalPath.append(new Arc2D.Float(float_3.x, float_3.y + f, float_3.width, float_3.height - f, f5 + f2, -f2, 0), true);
                    graphics2D.fill(generalPath);
                }
                if (this.percentFont == null || !(f4 > 1.0f)) continue;
                graphics2D.setPaint(Color.black);
                String string = (float)Math.round(this.values[j][i] / this.totals[i] * 1000.0) / 10.0f + "%";
                f2 = ((Rectangle2D.Float)fontMetrics2.getStringBounds((String)string, (Graphics)graphics2D)).width;
                float f6 = f3 + f4 / 2.0f;
                Rectangle2D.Float float_7 = new Rectangle2D.Float(float_6.x - (f2 + 5.0f) / 2.0f, float_6.y - (float_4.height + 5.0f) / 2.0f, float_6.width + f2 + 5.0f, float_6.height + float_4.height + 5.0f);
                graphics2D.draw(new Line2D.Float(this.rotate(f, f6, float_5), this.rotate(f, f6, float_6)));
                Point2D.Float float_8 = this.rotate(f, f6, float_7);
                graphics2D.drawString(string, float_8.x - f2 / 2.0f, float_8.y - float_4.y / 2.0f);
            }
            graphics2D.setPaint(new Color(0, 0, 0, 128));
            GeneralPath generalPath = new GeneralPath(new Arc2D.Float(float_3.x, float_3.y, float_3.width, float_3.height - f, 180.0f, 180.0f, 0));
            generalPath.append(new Arc2D.Float(float_3.x, float_3.y + f, float_3.width, float_3.height - f, 0.0f, -180.0f, 0), true);
            graphics2D.fill(generalPath);
        }
    }
}

