/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import pGraph.Axes;
import pGraph.Axes2;
import pGraph.Bar;
import pGraph.Chart;
import pGraph.Line;
import pGraph.Pie;
import pGraph.Scatter;
import pGraph.StackBar;
import pGraph.StackLine;

public class Main
extends Applet {
    private HashMap<String, String> pMap;
    private Paint background = Color.white;
    private String title;
    private String[] legend;
    private Font titleFont;
    private Font legendFont = null;
    private Font valueFont;
    private Font groupFont;
    private Paint[] paints;
    private int margin = 5;
    private Chart chart;
    private boolean showValues;
    private static final Font waterMarkFont = new Font("sans-serif", 0, 20);

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 1) {
            byte[] byArray = new Main(stringArray[0]).output();
            System.out.write(byArray, 0, byArray.length);
        } else {
            JOptionPane.showMessageDialog(null, "pGraph 1.42\nDeveloped by Prototec Ltd.\nMarketed and Distributed by Skagerrak Software Ltd.");
        }
    }

    public Main(String string) {
        String[] stringArray;
        this.pMap = new HashMap();
        for (String string2 : stringArray = string.split("&")) {
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length != 2) continue;
            this.pMap.put(stringArray2[0], stringArray2[1]);
        }
    }

    public void outputFile(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(this.output());
        fileOutputStream.close();
    }

    public byte[] output() throws IOException {
        this.init();
        int n = Integer.parseInt(this.getParameter("width", "200"));
        int n2 = Integer.parseInt(this.getParameter("height", "200"));
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        this.paint(bufferedImage.createGraphics(), n, n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private String getParameter(String string, String string2) {
        try {
            if (this.pMap == null) {
                return this.getParameter(string);
            }
            if (this.pMap.containsKey(string)) {
                return this.pMap.get(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public void init() {
        int n;
        int n2;
        String string = this.getParameter("font", "arial");
        int n3 = Integer.parseInt(this.getParameter("titlesize", "18"));
        this.titleFont = new Font(string, 0, n3);
        int n4 = Integer.parseInt(this.getParameter("legendsize", "" + (int)((double)n3 * 0.7)));
        if (n4 > 0) {
            this.legendFont = new Font(string, 0, n4);
        }
        this.valueFont = new Font(string, 0, Integer.parseInt(this.getParameter("valuesize", "" + (int)((double)n3 * 0.6))));
        this.groupFont = new Font(string, 0, Integer.parseInt(this.getParameter("groupsize", "" + (int)((double)n3 * 0.7))));
        this.title = this.getParameter("title", null);
        String string2 = this.getParameter("data", null);
        String[] stringArray = string2 == null ? new String[]{} : string2.split("\\ *\\|\\ *");
        this.legend = new String[stringArray.length];
        string2 = this.getParameter("groups", null);
        String[] stringArray2 = string2 == null ? new String[]{} : string2.split("\\ *\\,\\ *");
        double[][] dArrayArray = new double[stringArray.length][];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            String[] stringArray3 = stringArray[n2].split("\\ *\\,\\ *");
            if (stringArray3.length <= 0) continue;
            this.legend[n2] = stringArray3[0];
            dArrayArray[n2] = new double[stringArray3.length - 1];
            for (int i = 1; i < stringArray3.length; ++i) {
                try {
                    dArrayArray[n2][i - 1] = Double.parseDouble(stringArray3[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    dArrayArray[n2][i - 1] = 0.0;
                }
            }
        }
        this.paints = new Paint[dArrayArray.length];
        n2 = Math.min(this.paints.length, 9);
        for (int i = 0; i < this.paints.length; ++i) {
            float f = 0.8f - (float)((i + n2) / n2 / 2) / (float)((this.paints.length + n2) / n2 / 2) * 0.4f;
            float f2 = i / n2 / 2 % 2 == 0 ? 1.0f : 0.5f;
            float f3 = (float)(i % n2) / (float)n2 / 3.0f + (float)(i % 3) / 3.0f;
            Color color = Color.getHSBColor(f3 * 0.85f, f2, f);
            this.paints[i] = color;
        }
        String string3 = this.getParameter("colours", this.getParameter("c", null));
        String[] stringArray4 = string3 == null ? new String[]{} : string3.split("\\ *\\,\\ *");
        for (n = 0; n < stringArray4.length && n < this.paints.length; n += 1) {
            try {
                this.paints[n] = Color.decode("#" + stringArray4[n]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        n = 0;
        String string4 = this.getParameter("type", this.getParameter("t", "")).toLowerCase();
        if (string4.length() > 1 && string4.substring(0, 2).equals("3d")) {
            n = 1;
            string4 = string4.substring(2, string4.length());
        }
        if (string4.equals("bar") || string4.equals("b")) {
            this.chart = new Bar(dArrayArray, stringArray2, this.paints, n != 0);
        } else if (string4.equals("line") || string4.equals("l")) {
            this.chart = new Line(dArrayArray, stringArray2, this.paints, n != 0);
        } else if (string4.equals("barstack") || string4.equals("bs")) {
            this.chart = new StackBar(dArrayArray, stringArray2, this.paints, n != 0);
        } else if (string4.equals("linestack") || string4.equals("ls")) {
            this.chart = new StackLine(dArrayArray, stringArray2, this.paints, n != 0);
        }
        if (this.chart != null) {
            this.chart = new Axes(this.groupFont, this.valueFont, this.getParameter("xtitle", this.getParameter("x", null)), this.getParameter("ytitle", this.getParameter("y", null)), this.chart);
        } else if (string4.equals("scatter") || string4.equals("s")) {
            this.chart = new Scatter(dArrayArray, stringArray2, this.paints, n != 0, this.getParameter("trend", "").equalsIgnoreCase("true"), this.getParameter("join", "").equals("true"));
            this.chart = new Axes2(this.groupFont, this.valueFont, this.getParameter("xtitle", this.getParameter("x", null)), this.getParameter("ytitle", this.getParameter("y", null)), (Scatter)this.chart);
        } else {
            this.chart = new Pie(this.groupFont, this.showValues ? this.valueFont : null, dArrayArray, stringArray2, this.paints, n != 0);
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.paint(graphics2D, dimension.width, dimension.height);
    }

    public void paint(Graphics2D graphics2D, int n, int n2) {
        Serializable serializable;
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        graphics2D.setPaint(this.background);
        graphics2D.fill(new Rectangle(0, 0, n, n2));
        graphics2D.setPaint(Color.black);
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.margin, this.margin, n - 2 * this.margin, n2 - 2 * this.margin);
        if (this.title != null) {
            serializable = (Rectangle2D.Float)this.getFontMetrics(this.titleFont).getStringBounds(this.title, graphics2D);
            graphics2D.setFont(this.titleFont);
            graphics2D.drawString(this.title, float_.x + (float_.width - ((Rectangle2D.Float)serializable).width) / 2.0f, float_.y - ((Rectangle2D.Float)serializable).y);
            float_.y += ((Rectangle2D.Float)serializable).height + (float)this.margin;
            float_.height -= ((Rectangle2D.Float)serializable).height + (float)this.margin;
        }
        if (this.legend.length > 0 && this.legendFont != null) {
            int n3;
            serializable = this.getFontMetrics(this.legendFont);
            Rectangle2D.Float float_2 = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
            for (n3 = 0; n3 < this.legend.length; ++n3) {
                Rectangle2D.Float float_3 = (Rectangle2D.Float)((FontMetrics)serializable).getStringBounds(this.legend[n3], graphics2D);
                if (!(float_3.width > float_2.width)) continue;
                float_2 = float_3;
            }
            float_.width -= (float)this.margin * 1.5f + float_2.height + float_2.width;
            graphics2D.setFont(this.legendFont);
            for (n3 = 0; n3 < this.legend.length; ++n3) {
                graphics2D.setPaint(this.paints[n3]);
                graphics2D.fill(new Rectangle2D.Float(float_.x + float_.width + (float)this.margin, float_.y + (float)n3 * (float_2.height + 1.0f), float_2.height, float_2.height));
                graphics2D.setPaint(Color.black);
                graphics2D.drawString(this.legend[n3], float_.x + float_.width + (float)this.margin * 1.5f + float_2.height, float_.y + (float)n3 * (float_2.height + 1.0f) - float_2.y);
            }
        }
        this.chart.paint(graphics2D, float_);
    }

    private String registration(String string) {
        try {
            String string2 = new BigInteger(MessageDigest.getInstance("MD5").digest(string.getBytes())).toString(10);
            return string2.substring(1, 5) + '-' + string2.substring(5, 9) + '-' + string2.substring(9, 13) + '-' + string2.substring(13, 17);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }
}

