/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import pGraph.Chart;

class Axes
extends Chart {
    private final int tickWidth = 2;
    private int graphMagnitude;
    private Chart chart;
    private Font axesTitleFont;
    private Font axesFont;
    private double graphMax;
    private double graphMin;
    private double graphRange;
    private double graphStep;
    private String xTitle;
    private String yTitle;

    protected String doubleToString(double d) {
        if (this.graphMagnitude < 0) {
            String string = Integer.toString((int)((d - (double)((int)d)) * Math.pow(10.0, -this.graphMagnitude) + 0.5));
            while (string.length() < -this.graphMagnitude) {
                string = "0" + string;
            }
            return Integer.toString((int)d) + "." + string;
        }
        return Integer.toString((int)d);
    }

    public Axes(Font font, Font font2, String string, String string2, Chart chart) {
        this.axesTitleFont = font;
        this.axesFont = font2;
        this.chart = chart;
        this.xTitle = string;
        this.yTitle = string2;
        this.graphMagnitude = (int)(Math.log(Math.max(Math.abs(chart.max), Math.abs(chart.min))) / Math.log(10.0));
        this.graphStep = Math.pow(10.0, this.graphMagnitude);
        this.graphMax = Math.ceil(chart.max / this.graphStep) * this.graphStep;
        this.graphMin = Math.floor(chart.min / this.graphStep) * this.graphStep;
        this.graphRange = this.graphMax - this.graphMin;
    }

    private void drawDelta(Graphics2D graphics2D, double d, double d2, double d3, double d4) {
        graphics2D.draw(new Line2D.Double(d, d2, d + d3, d2 + d4));
    }

    public void paint(Graphics2D graphics2D, Rectangle2D.Float float_) {
        float f;
        int n;
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.axesFont);
        Rectangle2D.Float float_2 = null;
        Rectangle2D.Float float_3 = null;
        Rectangle2D.Float float_4 = (Rectangle2D.Float)fontMetrics.getStringBounds(this.doubleToString(this.doubleToString(this.graphMax).length() > this.doubleToString(this.graphMin).length() ? this.graphMax : this.graphMin), graphics2D);
        Rectangle2D.Float float_5 = new Rectangle2D.Float(float_.x + float_4.width + 2.0f, float_.y, 4.0f, float_.height);
        if (this.yTitle != null) {
            float_3 = (Rectangle2D.Float)graphics2D.getFontMetrics(this.axesTitleFont).getStringBounds(this.yTitle, graphics2D);
            float_5.x += float_3.height + 5.0f;
        }
        if (this.xTitle != null) {
            float_2 = (Rectangle2D.Float)graphics2D.getFontMetrics(this.axesTitleFont).getStringBounds(this.xTitle, graphics2D);
            float_5.height -= float_2.height + 5.0f;
        }
        if (this.chart.groups.length > 0) {
            float_5.height -= float_4.height + 2.0f + 5.0f;
        }
        Rectangle2D.Float float_6 = new Rectangle2D.Float(float_5.x + 2.0f, float_5.y + 6.0f, float_.width - float_5.x - 6.0f, float_5.height - (float)((this.chart.min < 0.0 ? 6 : 3) * 2));
        float f2 = float_6.width / ((float)this.chart.groupLength * ((float)this.chart.valuesLength + 2.0f));
        if (this.chart.inset) {
            float f3 = f2 / 2.0f;
            float_6.y += f3;
            float_6.height -= f3;
        }
        Rectangle2D.Float float_7 = new Rectangle2D.Float(float_6.x, (float)((double)float_6.y + (this.graphMax - this.chart.max) * (double)float_6.height / this.graphRange), float_6.width, (float)((double)float_6.height * this.chart.range / this.graphRange));
        Rectangle2D.Float float_8 = new Rectangle2D.Float(float_5.x + 2.0f, float_7.y + (float)(this.chart.max * (double)float_7.height / this.chart.range) - 2.0f, float_.width - float_5.x, float_5.width);
        this.chart.paint(graphics2D, float_7);
        graphics2D.setFont(this.axesFont);
        graphics2D.setPaint(Color.black);
        this.drawDelta(graphics2D, float_5.x + float_5.width / 2.0f, float_5.y, 0.0, float_5.height);
        this.drawDelta(graphics2D, float_5.x + float_5.width / 2.0f, float_5.y, -float_5.width / 2.0f, float_5.width);
        this.drawDelta(graphics2D, float_5.x + float_5.width / 2.0f, float_5.y, float_5.width / 2.0f, float_5.width);
        if (this.chart.min < 0.0) {
            this.drawDelta(graphics2D, float_5.x + float_5.width / 2.0f, float_5.y + float_5.height, -float_5.width / 2.0f, -float_5.width);
            this.drawDelta(graphics2D, float_5.x + float_5.width / 2.0f, float_5.y + float_5.height, float_5.width / 2.0f, -float_5.width);
        }
        if ((n = (int)Math.ceil(float_4.height / (f = (float)((double)float_6.height / this.graphRange * this.graphStep)))) != 0) {
            for (int i = (int)(this.graphRange / this.graphStep); i > -1; --i) {
                if (i % n != 0) continue;
                this.drawDelta(graphics2D, float_5.x, float_6.y + f * (float)i, float_5.width, 0.0);
                String string = this.doubleToString(this.graphMax - (double)i * this.graphStep);
                graphics2D.drawString(string, float_8.x - 5.0f - ((Rectangle2D.Float)fontMetrics.getStringBounds((String)string, (Graphics)graphics2D)).width, float_6.y + f * (float)i - float_4.y / 2.0f);
            }
        }
        this.drawDelta(graphics2D, float_8.x, float_8.y + float_8.height / 2.0f, float_8.width, 0.0);
        this.drawDelta(graphics2D, float_8.x + float_8.width, float_8.y + float_8.height / 2.0f, -float_8.height, -float_8.height / 2.0f);
        this.drawDelta(graphics2D, float_8.x + float_8.width, float_8.y + float_8.height / 2.0f, -float_8.height, float_8.height / 2.0f);
        float f4 = ((float)this.chart.valuesLength + 2.0f) / 2.0f * f2 + float_6.x;
        float f5 = f2 * ((float)this.chart.valuesLength + 2.0f);
        for (int i = 0; i < this.chart.groups.length; ++i) {
            if (this.chart.groups[i].length() <= 0) continue;
            this.drawDelta(graphics2D, f4 + (float)i * f5, float_8.y, 0.0, float_8.height);
            Rectangle2D.Float float_9 = (Rectangle2D.Float)fontMetrics.getStringBounds(this.chart.groups[i], graphics2D);
            graphics2D.drawString(this.chart.groups[i], f4 + (float)i * f5 - float_9.width / 2.0f, float_8.y + float_8.height - float_9.y);
        }
        if (this.xTitle != null) {
            graphics2D.setFont(this.axesTitleFont);
            graphics2D.drawString(this.xTitle, float_6.x + (float_6.width - float_2.width) / 2.0f, float_.y + float_.height - 5.0f);
        }
        if (this.yTitle != null) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.rotate(Math.toRadians(-90.0));
            graphics2D.setFont(this.axesTitleFont);
            graphics2D.drawString(this.yTitle, -float_5.y - (float_5.height + float_3.width) / 2.0f, float_.x - float_3.y);
            graphics2D.setTransform(affineTransform);
        }
    }
}

