/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.MetaClass;
import groovy.lang.Range;
import groovy.lang.Reference;
import groovy.lang.Script;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.vmplugin.VMPluginFactory;

public class ClassHelper {
    private static final Class[] classes = new Class[]{Object.class, Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Double.TYPE, Float.TYPE, Void.TYPE, Closure.class, GString.class, List.class, Map.class, Range.class, Pattern.class, Script.class, String.class, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Double.class, Float.class, BigDecimal.class, BigInteger.class, Void.class, Reference.class, Class.class, MetaClass.class};
    private static final String[] primitiveClassNames = new String[]{"", "boolean", "char", "byte", "short", "int", "long", "double", "float", "void"};
    public static final ClassNode DYNAMIC_TYPE;
    public static final ClassNode OBJECT_TYPE;
    public static final ClassNode VOID_TYPE;
    public static final ClassNode CLOSURE_TYPE;
    public static final ClassNode GSTRING_TYPE;
    public static final ClassNode LIST_TYPE;
    public static final ClassNode MAP_TYPE;
    public static final ClassNode RANGE_TYPE;
    public static final ClassNode PATTERN_TYPE;
    public static final ClassNode STRING_TYPE;
    public static final ClassNode SCRIPT_TYPE;
    public static final ClassNode REFERENCE_TYPE;
    public static final ClassNode boolean_TYPE;
    public static final ClassNode char_TYPE;
    public static final ClassNode byte_TYPE;
    public static final ClassNode int_TYPE;
    public static final ClassNode long_TYPE;
    public static final ClassNode short_TYPE;
    public static final ClassNode double_TYPE;
    public static final ClassNode float_TYPE;
    public static final ClassNode Byte_TYPE;
    public static final ClassNode Short_TYPE;
    public static final ClassNode Integer_TYPE;
    public static final ClassNode Long_TYPE;
    public static final ClassNode Character_TYPE;
    public static final ClassNode Float_TYPE;
    public static final ClassNode Double_TYPE;
    public static final ClassNode Boolean_TYPE;
    public static final ClassNode BigInteger_TYPE;
    public static final ClassNode BigDecimal_TYPE;
    public static final ClassNode void_WRAPPER_TYPE;
    public static final ClassNode CLASS_Type;
    public static final ClassNode METACLASS_TYPE;
    public static final ClassNode GENERATED_CLOSURE_Type;
    public static final ClassNode Enum_Type;
    public static final ClassNode Annotation_TYPE;
    public static final ClassNode ELEMENT_TYPE_TYPE;
    private static ClassNode[] types;
    private static ClassNode[] numbers;
    protected static final ClassNode[] EMPTY_TYPE_ARRAY;
    public static final String OBJECT = "java.lang.Object";

    public static ClassNode makeCached(Class c) {
        ClassNode classNode;
        SoftReference<ClassNode> classNodeSoftReference = ClassHelperCache.classCache.get(c);
        if (classNodeSoftReference == null || (classNode = classNodeSoftReference.get()) == null) {
            classNode = new ClassNode(c);
            ClassHelperCache.classCache.put(c, new SoftReference<ClassNode>(classNode));
            VMPluginFactory.getPlugin().setAdditionalClassInformation(classNode);
        }
        return classNode;
    }

    public static ClassNode[] make(Class[] classes) {
        ClassNode[] cns = new ClassNode[classes.length];
        for (int i = 0; i < cns.length; ++i) {
            cns[i] = ClassHelper.make(classes[i]);
        }
        return cns;
    }

    public static ClassNode make(Class c) {
        return ClassHelper.make(c, true);
    }

    public static ClassNode make(Class c, boolean includeGenerics) {
        for (int i = 0; i < classes.length; ++i) {
            if (c != classes[i]) continue;
            return types[i];
        }
        if (c.isArray()) {
            ClassNode cn = ClassHelper.make(c.getComponentType(), includeGenerics);
            return cn.makeArray();
        }
        return ClassHelper.makeWithoutCaching(c, includeGenerics);
    }

    public static ClassNode makeWithoutCaching(Class c) {
        return ClassHelper.makeWithoutCaching(c, true);
    }

    public static ClassNode makeWithoutCaching(Class c, boolean includeGenerics) {
        if (c.isArray()) {
            ClassNode cn = ClassHelper.makeWithoutCaching(c.getComponentType(), includeGenerics);
            return cn.makeArray();
        }
        ClassNode cached = ClassHelper.makeCached(c);
        if (includeGenerics) {
            return cached;
        }
        ClassNode t = ClassHelper.makeWithoutCaching(c.getName());
        t.setRedirect(cached);
        return t;
    }

    public static ClassNode makeWithoutCaching(String name) {
        ClassNode cn = new ClassNode(name, 1, OBJECT_TYPE);
        cn.isPrimaryNode = false;
        return cn;
    }

    public static ClassNode make(String name) {
        int i;
        if (name == null || name.length() == 0) {
            return DYNAMIC_TYPE;
        }
        for (i = 0; i < primitiveClassNames.length; ++i) {
            if (!primitiveClassNames[i].equals(name)) continue;
            return types[i];
        }
        for (i = 0; i < classes.length; ++i) {
            String cname = classes[i].getName();
            if (!name.equals(cname)) continue;
            return types[i];
        }
        return ClassHelper.makeWithoutCaching(name);
    }

    public static ClassNode getWrapper(ClassNode cn) {
        if (!ClassHelper.isPrimitiveType(cn = cn.redirect())) {
            return cn;
        }
        if (cn == boolean_TYPE) {
            return Boolean_TYPE;
        }
        if (cn == byte_TYPE) {
            return Byte_TYPE;
        }
        if (cn == char_TYPE) {
            return Character_TYPE;
        }
        if (cn == short_TYPE) {
            return Short_TYPE;
        }
        if (cn == int_TYPE) {
            return Integer_TYPE;
        }
        if (cn == long_TYPE) {
            return Long_TYPE;
        }
        if (cn == float_TYPE) {
            return Float_TYPE;
        }
        if (cn == double_TYPE) {
            return Double_TYPE;
        }
        if (cn == VOID_TYPE) {
            return void_WRAPPER_TYPE;
        }
        return cn;
    }

    public static ClassNode getUnwrapper(ClassNode cn) {
        if (ClassHelper.isPrimitiveType(cn = cn.redirect())) {
            return cn;
        }
        if (cn == Boolean_TYPE) {
            return boolean_TYPE;
        }
        if (cn == Byte_TYPE) {
            return byte_TYPE;
        }
        if (cn == Character_TYPE) {
            return char_TYPE;
        }
        if (cn == Short_TYPE) {
            return short_TYPE;
        }
        if (cn == Integer_TYPE) {
            return int_TYPE;
        }
        if (cn == Long_TYPE) {
            return long_TYPE;
        }
        if (cn == Float_TYPE) {
            return float_TYPE;
        }
        if (cn == Double_TYPE) {
            return double_TYPE;
        }
        return cn;
    }

    public static boolean isPrimitiveType(ClassNode cn) {
        return cn == boolean_TYPE || cn == char_TYPE || cn == byte_TYPE || cn == short_TYPE || cn == int_TYPE || cn == long_TYPE || cn == float_TYPE || cn == double_TYPE || cn == VOID_TYPE;
    }

    public static boolean isNumberType(ClassNode cn) {
        return cn == Byte_TYPE || cn == Short_TYPE || cn == Integer_TYPE || cn == Long_TYPE || cn == Float_TYPE || cn == Double_TYPE || cn == byte_TYPE || cn == short_TYPE || cn == int_TYPE || cn == long_TYPE || cn == float_TYPE || cn == double_TYPE;
    }

    public static ClassNode makeReference() {
        return ClassHelper.make(Reference.class);
    }

    public static boolean isCachedType(ClassNode type) {
        for (ClassNode cachedType : types) {
            if (cachedType != type) continue;
            return true;
        }
        return false;
    }

    static {
        OBJECT_TYPE = DYNAMIC_TYPE = ClassHelper.makeCached(Object.class);
        VOID_TYPE = ClassHelper.makeCached(Void.TYPE);
        CLOSURE_TYPE = ClassHelper.makeCached(Closure.class);
        GSTRING_TYPE = ClassHelper.makeCached(GString.class);
        LIST_TYPE = ClassHelper.makeWithoutCaching(List.class);
        MAP_TYPE = ClassHelper.makeWithoutCaching(Map.class);
        RANGE_TYPE = ClassHelper.makeCached(Range.class);
        PATTERN_TYPE = ClassHelper.makeCached(Pattern.class);
        STRING_TYPE = ClassHelper.makeCached(String.class);
        SCRIPT_TYPE = ClassHelper.makeCached(Script.class);
        REFERENCE_TYPE = ClassHelper.makeWithoutCaching(Reference.class);
        boolean_TYPE = ClassHelper.makeCached(Boolean.TYPE);
        char_TYPE = ClassHelper.makeCached(Character.TYPE);
        byte_TYPE = ClassHelper.makeCached(Byte.TYPE);
        int_TYPE = ClassHelper.makeCached(Integer.TYPE);
        long_TYPE = ClassHelper.makeCached(Long.TYPE);
        short_TYPE = ClassHelper.makeCached(Short.TYPE);
        double_TYPE = ClassHelper.makeCached(Double.TYPE);
        float_TYPE = ClassHelper.makeCached(Float.TYPE);
        Byte_TYPE = ClassHelper.makeCached(Byte.class);
        Short_TYPE = ClassHelper.makeCached(Short.class);
        Integer_TYPE = ClassHelper.makeCached(Integer.class);
        Long_TYPE = ClassHelper.makeCached(Long.class);
        Character_TYPE = ClassHelper.makeCached(Character.class);
        Float_TYPE = ClassHelper.makeCached(Float.class);
        Double_TYPE = ClassHelper.makeCached(Double.class);
        Boolean_TYPE = ClassHelper.makeCached(Boolean.class);
        BigInteger_TYPE = ClassHelper.makeCached(BigInteger.class);
        BigDecimal_TYPE = ClassHelper.makeCached(BigDecimal.class);
        void_WRAPPER_TYPE = ClassHelper.makeCached(Void.class);
        CLASS_Type = ClassHelper.makeWithoutCaching(Class.class);
        METACLASS_TYPE = ClassHelper.makeCached(MetaClass.class);
        GENERATED_CLOSURE_Type = ClassHelper.makeCached(GeneratedClosure.class);
        Enum_Type = new ClassNode("java.lang.Enum", 0, OBJECT_TYPE);
        Annotation_TYPE = new ClassNode("java.lang.annotation.Annotation", 0, OBJECT_TYPE);
        ELEMENT_TYPE_TYPE = new ClassNode("java.lang.annotation.ElementType", 0, Enum_Type);
        ClassHelper.Enum_Type.isPrimaryNode = false;
        ClassHelper.Annotation_TYPE.isPrimaryNode = false;
        types = new ClassNode[]{OBJECT_TYPE, boolean_TYPE, char_TYPE, byte_TYPE, short_TYPE, int_TYPE, long_TYPE, double_TYPE, float_TYPE, VOID_TYPE, CLOSURE_TYPE, GSTRING_TYPE, LIST_TYPE, MAP_TYPE, RANGE_TYPE, PATTERN_TYPE, SCRIPT_TYPE, STRING_TYPE, Boolean_TYPE, Character_TYPE, Byte_TYPE, Short_TYPE, Integer_TYPE, Long_TYPE, Double_TYPE, Float_TYPE, BigDecimal_TYPE, BigInteger_TYPE, void_WRAPPER_TYPE, REFERENCE_TYPE, CLASS_Type, METACLASS_TYPE, GENERATED_CLOSURE_Type, Enum_Type, Annotation_TYPE};
        numbers = new ClassNode[]{char_TYPE, byte_TYPE, short_TYPE, int_TYPE, long_TYPE, double_TYPE, float_TYPE, Short_TYPE, Byte_TYPE, Character_TYPE, Integer_TYPE, Float_TYPE, Long_TYPE, Double_TYPE, BigInteger_TYPE, BigDecimal_TYPE};
        EMPTY_TYPE_ARRAY = new ClassNode[0];
    }

    static class ClassHelperCache {
        static Map<Class, SoftReference<ClassNode>> classCache = new WeakHashMap<Class, SoftReference<ClassNode>>();

        ClassHelperCache() {
        }
    }
}

