/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.license.client;

import com.prosc.license.client.ExpiredLicenseException;
import com.prosc.license.client.InvalidLicenseException;
import com.prosc.license.client.License;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Registration
implements Serializable {
    private static final Logger log = Logger.getLogger(Registration.class.getName());
    private byte version;
    private short productCode;
    private String licenseKey;
    private License cachedLicense;
    private String companyName;
    private final long createdDate = System.currentTimeMillis();
    private long expirationDate = 0L;
    private boolean requireDemoLicense = false;
    private static final long DEMO_TIMEOUT_MILLIS = 0x6DDD00L;

    public Registration(byte version, short productCode) {
        this.version = version;
        this.productCode = productCode;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
        this.cachedLicense = null;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public void setLicenseKey(String key) {
        this.licenseKey = key;
        this.cachedLicense = null;
    }

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    public void checkLicense() throws InvalidLicenseException {
        boolean isExpired;
        String licenseKey = this.getLicenseKey();
        String companyName = this.getCompanyName();
        if ((licenseKey == null || licenseKey.length() == 0) && this.requireDemoLicense) {
            throw new InvalidLicenseException("This product must be registered with a valid license key.", licenseKey);
        }
        if (this.cachedLicense == null) {
            this.cachedLicense = !(licenseKey != null && licenseKey.length() != 0 || companyName != null && companyName.length() != 0) ? this.createDemoLicense() : this.createLicense(licenseKey, companyName);
            if (this.cachedLicense.getVariant() == 0) {
                log.info("Registered successfully with demo license; will run for two hours after launch.");
                if (this.getExpirationDate() == 0L) {
                    this.setExpirationDate(this.createdDate + 0x6DDD00L);
                    log.log(Level.INFO, "Expiration date " + new Date(this.getExpirationDate()));
                }
                if (this.cachedLicense.getExpirationDate() < this.getExpirationDate()) {
                    this.setExpirationDate(this.cachedLicense.getExpirationDate());
                }
            } else {
                log.fine("Registered successfully.");
                this.setExpirationDate(this.cachedLicense.getExpirationDate());
            }
        }
        boolean bl = isExpired = System.currentTimeMillis() > this.expirationDate || this.cachedLicense.getVariant() == 0 && System.currentTimeMillis() < this.createdDate;
        if (this.cachedLicense.isPortfolio()) {
            if (this.cachedLicense.getVariant() == 0 || this.cachedLicense.getVersion() != 1) {
                throw new InvalidLicenseException("Portfolio licenses cannot use DEMO variants, and cannot have version numbers which are not '1'", this.cachedLicense);
            }
        } else {
            if (this.productCode != this.cachedLicense.getProductCode()) {
                throw new InvalidLicenseException("License key provided is for a different product (expected " + this.productCode + "; found " + this.cachedLicense.getProductCode() + ")", licenseKey, companyName);
            }
            if (this.cachedLicense.getVersion() > 0 && this.cachedLicense.getVersion() < this.version) {
                throw new InvalidLicenseException("License is for an older product version.", licenseKey, companyName);
            }
            if (isExpired) {
                if (this.cachedLicense.getVariant() == 0) {
                    throw new ExpiredLicenseException("DEMO mode expired! (" + this.productCode + ") You can continue to run in demo mode by restarting FileMaker, or you can register with a valid license key from http://www.360works.com.", this.cachedLicense.getEncryptedKey());
                }
                throw new ExpiredLicenseException("This license key expired on " + new Date(this.getExpirationDate()), this.cachedLicense.getEncryptedKey());
            }
        }
    }

    protected License createLicense(String licenseKey, String companyName) throws InvalidLicenseException {
        return new License(licenseKey, companyName);
    }

    protected License createDemoLicense() {
        return new License(0, this.productCode, this.version, 0, System.currentTimeMillis(), System.currentTimeMillis() + 0x6DDD00L, Long.MAX_VALUE, null, null);
    }

    public String getLicenseInfo() {
        try {
            this.checkLicense();
            StringBuffer result = new StringBuffer();
            result.append("Major Version: ").append(this.getVersion()).append("\n");
            result.append("Type: ").append(this.cachedLicense.getVariantName()).append("\n");
            result.append("Registered To: ").append(this.cachedLicense.getRegisteredTo()).append("\n");
            if (this.expirationDate != Long.MAX_VALUE) {
                String expirationLabel = this.cachedLicense.isPortfolio() ? "Portfolio renewal date: " : "Expires on: ";
                result.append(expirationLabel).append(DateFormat.getDateTimeInstance().format(new Date(this.expirationDate))).append("\n");
            }
            return result.toString();
        }
        catch (InvalidLicenseException e) {
            return e.getMessage();
        }
    }

    public License getLicense() {
        if (this.cachedLicense == null) {
            try {
                this.checkLicense();
            }
            catch (InvalidLicenseException e) {
                log.log(Level.FINER, "License is invalid", e);
            }
        }
        return this.cachedLicense;
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(long expirationDate) {
        this.expirationDate = expirationDate;
    }

    public boolean isRequireDemoLicense() {
        return this.requireDemoLicense;
    }

    public void setRequireDemoLicense(boolean requireDemoLicense) {
        this.requireDemoLicense = requireDemoLicense;
    }
}

