/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.license.client;

import com.prosc.license.client.License;

public class InvalidLicenseException
extends Exception {
    private String licenseKey;
    private String licensedTo;

    public InvalidLicenseException(String message, String licenseKey, String licensedTo) {
        super(message);
        this.licenseKey = licenseKey;
        this.licensedTo = licensedTo;
    }

    public InvalidLicenseException(String message, String licenseKey) {
        this(message, licenseKey, null);
    }

    public InvalidLicenseException(String message, License invalidLicense) {
        this(message, invalidLicense.getEncryptedKey(), invalidLicense.getRegisteredTo());
    }

    public InvalidLicenseException(String message, Throwable cause, String licenseKey) {
        super(message, cause);
        this.licenseKey = licenseKey;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public String getLicensedTo() {
        return this.licensedTo;
    }
}

