/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.license.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;

public class ByteArrayParser {
    private ByteArrayInputStream stream;

    public ByteArrayParser(byte[] payload) {
        this.stream = new ByteArrayInputStream(payload);
    }

    public Byte readByte() throws IOException {
        byte value = (byte)this.stream.read();
        if (value == -1) {
            throw new IOException("No more bytes in payload.");
        }
        return new Byte(value);
    }

    public Short readShort() throws IOException {
        return new Short(this.readNumber(2).shortValue());
    }

    public Integer readInteger() throws IOException {
        return new Integer(this.readNumber(4).intValue());
    }

    public Integer readIntegerMidget() throws IOException {
        return new Integer(this.readNumber(3).intValue());
    }

    public Long readLong() throws IOException {
        return new Long(this.readNumber(8).longValue());
    }

    private BigInteger readNumber(int length) throws IOException {
        byte[] bytes = new byte[length];
        int readLength = this.stream.read(bytes);
        if (readLength < length) {
            throw new IOException("No more bytes in payload");
        }
        return new BigInteger(bytes);
    }

    public int bytesRemaining() throws IOException {
        return this.stream.available();
    }
}

