/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.types;

import com.prosc.fmkit.PluginBridge;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.QuadChar;
import com.prosc.fmkit.types.Converter;
import com.prosc.fmkit.types.FMBinaryInterface;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMType;
import com.prosc.fmkit.types.FileReference;
import com.prosc.fmkit.types.InputStreamInfo;
import com.prosc.fmkit.unicode.Compress;
import com.prosc.fmkit.unicode.EndOfInputException;
import com.prosc.fmkit.unicode.Expand;
import com.prosc.fmkit.unicode.IllegalInputException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class FMBinary
extends FMType
implements FMBinaryInterface {
    protected long cToken;
    private static byte magicCookie = (byte)90;
    private List streamTypes;
    private FMData fmData;
    private static final Logger log = Logger.getLogger(FMBinary.class.getName());

    public FMBinary() {
        this.cToken = this._createBinary();
    }

    public FMBinary(long cToken, FMData fmData) {
        this.cToken = cToken;
        this.fmData = fmData;
    }

    public String getAsString() {
        return super.toString();
    }

    public static FMBinary fmBinaryForFile(File file) throws IOException {
        return FMBinary.fmBinaryForFile(file, file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FMBinary fmBinaryForFile(File file, String filename) throws IOException {
        if (filename == null) {
            filename = file.getName();
        }
        log.log(Level.INFO, "Creating container for file " + file);
        FileInputStream in = new FileInputStream(file);
        try {
            FMBinary fMBinary = FMBinary.fmBinaryForData(in, filename, (int)file.length());
            return fMBinary;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FMType fmBinaryForUrl(URL url) throws IOException {
        InputStreamInfo info = PluginUtils.getInputStreamInfoForUrl(url);
        BufferedInputStream in = new BufferedInputStream(info.getStream());
        try {
            FMBinary fMBinary = FMBinary.fmBinaryForData(in, info.getName(), info.getContentType(), (int)info.getLength());
            return fMBinary;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static FMBinary fmBinaryForData(InputStream data, String filename) throws IOException {
        return FMBinary.fmBinaryForData(data, filename, 0);
    }

    public static FMBinary fmBinaryForData(InputStream data, String filename, int size) throws IOException {
        return FMBinary.fmBinaryForData(data, filename, null, size);
    }

    public static FMBinary fmBinaryForData(InputStream data, String filename, String optionalContentType, int size) throws IOException {
        return FMBinary.fmBinaryForData(FMBinary.getInputStreamAsBytes(data, size), filename, optionalContentType);
    }

    public static FMBinary fmBinaryForData(byte[] bytes, String filename, String optionalContentType) throws IOException {
        QuadChar quadChar = FMBinary.getQuadChar(filename, optionalContentType);
        FMBinary result = new FMBinary();
        Dimension dimension = null;
        if (quadChar.isImage()) {
            try {
                dimension = FMBinary.getImageDimensions(bytes);
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Could not calculate image dimensions for " + filename, e);
            }
        }
        if (dimension != null) {
            log.log(Level.FINE, "Returning " + quadChar + " image with dimensions " + dimension.getWidth() + "x" + dimension.getHeight());
            result.addImageData(null, bytes, (short)dimension.getWidth(), (short)dimension.getHeight(), quadChar);
        } else if (quadChar == QuadChar.ImagePICT) {
            result.addDataStream(bytes, QuadChar.ImagePICT);
        } else {
            result.addDataStream(bytes, QuadChar.FileData);
        }
        result.setFileName(filename);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dimension getImageDimensions(byte[] bytes) throws IOException {
        log.log(Level.INFO, "Calculating dimensions for image with length " + bytes.length);
        PluginBridge.initAwt();
        ByteArrayInputStream baos = new ByteArrayInputStream(bytes);
        ImageInputStream in = ImageIO.createImageInputStream(baos);
        try {
            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                try {
                    reader.setInput(in);
                    Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                    reader.dispose();
                    return dimension;
                }
                catch (Throwable throwable) {
                    reader.dispose();
                    throw throwable;
                }
            }
        }
        finally {
            baos.close();
            if (in != null) {
                in.close();
            }
        }
        return null;
    }

    private static QuadChar getQuadChar(String filename, String optionalContentType) {
        QuadChar quadChar = null;
        if (optionalContentType != null) {
            quadChar = QuadChar.forMimeType(optionalContentType);
        }
        if (quadChar == null) {
            quadChar = QuadChar.forFilename(filename);
        }
        return quadChar;
    }

    public static FMBinary fmBinaryForImage(BufferedImage image, String filename) throws IOException {
        if (image == null) {
            return null;
        }
        if (image.getWidth() > Short.MAX_VALUE || image.getHeight() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Image dimension(s) exceed maximum of 32767 pixels");
        }
        if (filename == null || filename.length() == 0) {
            filename = "image";
        }
        if (filename.indexOf(46) == -1) {
            filename = filename + ".jpg";
        }
        FMBinary result = new FMBinary();
        result.setFileName(filename);
        QuadChar qc = QuadChar.forFilename(filename);
        if (!qc.isImage()) {
            throw new IllegalArgumentException("File " + filename + " is not an image");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        ImageIO.write((RenderedImage)image, filename.substring(filename.lastIndexOf(46) + 1), baos);
        result.addImageData(image, baos.toByteArray(), (short)image.getWidth(), (short)image.getHeight(), qc);
        return result;
    }

    public List getStreamTypes() {
        if (this.streamTypes == null) {
            this.streamTypes = new LinkedList();
            int streamCount = this._getStreamCount(this.cToken);
            for (int i = 0; i < streamCount; ++i) {
                String typeString = this._getTypeForIndex(this.cToken, i);
                this.streamTypes.add(new QuadChar(typeString));
            }
        }
        return this.streamTypes;
    }

    public QuadChar getBestQuadChar() {
        QuadChar result = null;
        if (this.getStreamTypes().size() == 0) {
            return null;
        }
        if (this.getStreamTypes().contains(QuadChar.ImageTIFF)) {
            result = QuadChar.ImageTIFF;
        } else if (this.getStreamTypes().contains(QuadChar.ImagePDF)) {
            result = QuadChar.ImagePDF;
        } else if (this.getStreamTypes().contains(QuadChar.ImagePICT)) {
            result = QuadChar.ImagePICT;
        } else if (this.getStreamTypes().contains(QuadChar.ImageGIF)) {
            result = QuadChar.ImageGIF;
        } else if (this.getStreamTypes().contains(QuadChar.ImagePng)) {
            result = QuadChar.ImagePng;
        } else if (this.getStreamTypes().contains(QuadChar.FileData)) {
            result = QuadChar.FileData;
        } else if (this.getStreamTypes().contains(QuadChar.ImageJPEG)) {
            result = QuadChar.ImageJPEG;
        } else {
            for (QuadChar eachQ : this.streamTypes) {
                if (eachQ.equals(QuadChar.FileName) || eachQ.equals(QuadChar.ResourceFork)) continue;
                result = eachQ;
                break;
            }
        }
        return result;
    }

    public InputStream getBestInputStream() {
        if (this.fmData == null || this.fmData.isEmpty()) {
            return null;
        }
        QuadChar bestQ = this.getBestQuadChar();
        if (bestQ != null) {
            return this.getStreamForType(bestQ);
        }
        return null;
    }

    public String asString() {
        try {
            Converter converter = FMType.converterForClass(String.class);
            return (String)converter.convertData(this.fmData, String.class);
        }
        catch (FMType.UnsupportedTypeConversionException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getStreamForType(QuadChar type) {
        return new FMContainerInputStream(this.getStreamTypes().indexOf(type));
    }

    private native int _getStreamCount(long var1);

    private native long _getTotalSize(long var1);

    private native String _getTypeForIndex(long var1, int var3);

    private native void _getData(long var1, int var3, int var4, int var5, byte[] var6);

    private native void _addStream(long var1, String var3, int var4, byte[] var5);

    private native void _removeStream(long var1, String var3);

    private native void _removeAllStreams(long var1);

    private native int _getSize(long var1, int var3);

    long cToken() {
        return this.cToken;
    }

    public long getTotalSize() {
        return this._getTotalSize(this.cToken);
    }

    public void addImageData(BufferedImage img, byte[] data, short width, short height, QuadChar imageType) throws IOException {
        this.addDataStream(data, imageType);
        if (width > 0 && height > 0) {
            this._addSizeData(width, height);
        }
        if (imageType != QuadChar.ImageJPEG && imageType != QuadChar.ImageGIF) {
            if (img == null) {
                img = ImageIO.read(new ByteArrayInputStream(data));
            }
            if (img != null) {
                log.log(Level.FINE, "Adding additional image data by converting from " + imageType + " to JPEG");
                ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
                try {
                    BufferedImage jpgVersion = new BufferedImage(img.getWidth(), img.getHeight(), 1);
                    Graphics graphics = jpgVersion.getGraphics();
                    graphics.setColor(Color.WHITE);
                    graphics.fillRect(0, 0, jpgVersion.getWidth(), jpgVersion.getHeight());
                    graphics.drawImage(img, 0, 0, null);
                    graphics.dispose();
                    ImageIO.write((RenderedImage)jpgVersion, "jpg", baos);
                }
                catch (OutOfMemoryError e) {
                    ImageIO.write((RenderedImage)img, "jpg", baos);
                }
                this.addImageData(img, baos.toByteArray(), (short)img.getWidth(), (short)img.getHeight(), QuadChar.ImageJPEG);
            } else {
                log.log(Level.WARNING, "Unable to generate JPEG representation of image " + imageType);
            }
        }
    }

    private static byte[] getInputStreamAsBytes(InputStream in, int size) throws IOException {
        int bytesRead;
        if (size < 1) {
            int lastBytesRead;
            ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
            byte[] buffer = new byte[8192];
            while ((lastBytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, lastBytesRead);
            }
            out.flush();
            return out.toByteArray();
        }
        byte[] result = new byte[size];
        for (int offset = 0; offset != result.length && (bytesRead = in.read(result, offset, result.length - offset)) != -1; offset += bytesRead) {
        }
        return result;
    }

    private void _addSizeData(short width, short height) {
        byte[] sizeData = new byte[]{(byte)(width >> 8 & 0xFF), (byte)(width & 0xFF), (byte)(height >> 8 & 0xFF), (byte)(height & 0xFF)};
        this.addDataStream(sizeData, QuadChar.ImageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getWidth() {
        short s;
        InputStream stream = this.getStreamForType(QuadChar.ImageSize);
        if (stream == null) {
            return -1;
        }
        try {
            byte[] sizeData = new byte[4];
            stream.read(sizeData);
            int result = sizeData[0] << 8;
            s = (short)(result |= sizeData[1] & 0xFF);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        stream.close();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getHeight() {
        short s;
        InputStream stream = this.getStreamForType(QuadChar.ImageSize);
        if (stream == null) {
            return -1;
        }
        try {
            byte[] sizeData = new byte[4];
            stream.read(sizeData);
            int result = sizeData[2] << 8;
            s = (short)(result |= sizeData[3] & 0xFF);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        stream.close();
        return s;
    }

    public boolean isReference() {
        return false;
    }

    public InputStreamInfo getInputStreamInfo(PluginContext context) {
        FMContainerInputStream bestInputStream = (FMContainerInputStream)this.getBestInputStream();
        long streamSize = bestInputStream.getLength();
        String fileName = this.getFileName();
        if (fileName == null) {
            fileName = "Untitled.jpg";
            try {
                QuadChar qc = this.getBestQuadChar();
                String mimeType = qc.getMimeType();
                fileName = "Untitled." + mimeType.substring(mimeType.indexOf(47) + 1);
                log.log(Level.INFO, "Unknown filename, using " + fileName);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Unable to assign name for file, using " + fileName);
            }
        }
        return new InputStreamInfo(bestInputStream, fileName, streamSize);
    }

    public void setSoundData(byte[] data) {
        this.addDataStream(data, QuadChar.Sound);
    }

    public void addDataStream(byte[] data, QuadChar type) {
        if (this.getStreamTypes().contains(type)) {
            this._removeStream(this.cToken, type.toString());
        }
        this._addStream(this.cToken, type.toString(), data.length, data);
        this.streamTypes = null;
    }

    private native long _createBinary();

    public static boolean canConvertTo(Class targetClass) {
        return targetClass == FMBinary.class;
    }

    public void writeToData(FMData destination) {
        destination.setFMBinary(this);
    }

    protected static void registerConverters() {
        FMType.addConverter(new FMBinaryConverter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileName() {
        String string;
        InputStream fnamStream = this.getStreamForType(QuadChar.FileName);
        try {
            string = this.getFileNameFromBinary(fnamStream);
        }
        catch (Throwable throwable) {
            try {
                fnamStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        fnamStream.close();
        return string;
    }

    private String getFileNameFromBinary(InputStream in) throws IOException {
        byte[] rawBytes = new byte[in.available()];
        if (rawBytes.length == 0) {
            return null;
        }
        int readResult = in.read(rawBytes);
        byte[] xorBytes = new byte[rawBytes.length];
        for (int n = 0; n < rawBytes.length; ++n) {
            xorBytes[n] = (byte)(rawBytes[n] ^ 0x5A);
            if (xorBytes[n] != -128) continue;
            xorBytes[n] = 47;
        }
        Expand expander = new Expand();
        int startMark = 4;
        byte protocolLength = rawBytes[startMark];
        byte pathLength = rawBytes[startMark += protocolLength + 1];
        ++startMark;
        int lastSlash = xorBytes.length;
        while (lastSlash >= startMark && xorBytes[--lastSlash] != 47) {
        }
        String fileString = null;
        try {
            byte[] pathBytes = new byte[lastSlash - startMark + 1];
            System.arraycopy(xorBytes, startMark, pathBytes, 0, pathBytes.length);
            String pathString = expander.expand(pathBytes);
            ++lastSlash;
            byte[] fileBytes = new byte[xorBytes.length - ++lastSlash];
            System.arraycopy(xorBytes, lastSlash, fileBytes, 0, fileBytes.length);
            fileString = expander.expand(fileBytes);
        }
        catch (IllegalInputException e) {
            throw new RuntimeException(e);
        }
        catch (EndOfInputException e) {
            throw new RuntimeException(e);
        }
        return fileString;
    }

    public void setFileName(String name) {
        this._addfnamdata(this.cToken, name);
    }

    private void _addfnamdata(long ctoken, String name) {
        this.setFileNameForBinary("file", "", name);
    }

    private void setFileNameForBinary(String protocol, String folder, String file) {
        Compress compressor = new Compress();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(new byte[]{0, 0, 0, 1});
            out.write(protocol.length());
            out.write(protocol.getBytes());
            out.write(folder.length());
            out.write(this.xor(compressor.compress(folder)));
            out.write(file.length());
            out.write(this.xor(compressor.compress(file)));
            this.addDataStream(out.toByteArray(), QuadChar.FileName);
            out.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] xor(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            byte aByte = bytes[i];
            if (aByte == 47) continue;
            int n = i;
            bytes[n] = (byte)(bytes[n] ^ 0x5A);
        }
        return bytes;
    }

    private static class FMBinaryConverter
    implements Converter {
        private FMBinaryConverter() {
        }

        public boolean canConvertTo(Class targetClass) {
            return FMBinary.class == targetClass || FMBinaryInterface.class == targetClass || FileReference.class == targetClass;
        }

        public Object convertData(FMData param, Class targetClass) {
            if (param.isEmpty()) {
                return null;
            }
            FMBinaryInterface result = null;
            if (targetClass == FMBinary.class || targetClass == FMBinaryInterface.class) {
                result = param.getFMBinary();
            }
            try {
                String stringData;
                if (!(result != null && !result.getStreamTypes().isEmpty() || targetClass != FMBinaryInterface.class && targetClass != FileReference.class || (stringData = param.getStringData()) == null || stringData.length() <= 0)) {
                    result = new FileReference(stringData);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not extract FileReference", e);
            }
            return result;
        }
    }

    public final class FMContainerInputStream
    extends InputStream {
        private final int whichStream;
        private final byte[] oneByte = new byte[1];
        private final int length;
        private int streamPosition = 0;

        private FMContainerInputStream(int streamIndex) {
            this.whichStream = streamIndex;
            this.length = FMBinary.this._getSize(FMBinary.this.cToken, streamIndex);
        }

        public int read() {
            int readResult = this.read(this.oneByte, 0, 1);
            if (readResult != 1) {
                return readResult;
            }
            return this.oneByte[0];
        }

        public int available() {
            return this.length - this.streamPosition;
        }

        public synchronized int read(byte[] b, int off, int len) {
            if (b == null || off < 0 || len < 0) {
                throw new IllegalArgumentException("Unable to read binary data.");
            }
            if (b.length == 0) {
                return -1;
            }
            if (this.streamPosition >= this.length) {
                return -1;
            }
            if (this.streamPosition + len > this.length) {
                len = this.length - this.streamPosition;
            }
            if (len <= 0) {
                return 0;
            }
            if (off == 0) {
                FMBinary.this._getData(FMBinary.this.cToken, this.whichStream, this.streamPosition, len, b);
            } else {
                byte[] tmpBuffer = new byte[len];
                FMBinary.this._getData(FMBinary.this.cToken, this.whichStream, this.streamPosition, len, tmpBuffer);
                System.arraycopy(tmpBuffer, 0, b, off, len);
            }
            this.streamPosition += len;
            return len;
        }

        public synchronized long skip(long n) {
            if (n < 0L) {
                return 0L;
            }
            if (n > (long)this.available()) {
                n = this.available();
            }
            this.streamPosition = (int)((long)this.streamPosition + n);
            return n;
        }

        public synchronized void reset() throws IOException {
            this.streamPosition = 0;
        }

        public int getLength() {
            return this.length;
        }
    }
}

