/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.design;

import com.prosc.fmkit.FeedbackException;
import java.util.regex.Pattern;

public class FieldNameValidator {
    private static final Pattern SPECIAL_WORDS_PATTERN = Pattern.compile("\\s(and|or|note|xor|true|false)\\s", 2);
    private static final Pattern INVALID__CHARS = Pattern.compile("[,+\\-\\*\\/\\^\\&\\=\\\u2260\\>\\<\\(\\)\\[\\]\\{\\}\\\"\\;\\:\\$\n]");
    private boolean allowTableName;

    public FieldNameValidator(boolean allowTableName) {
        this.allowTableName = allowTableName;
    }

    public void validate(String fieldName) throws FeedbackException {
        if (!this.allowTableName) {
            this.validatePart(fieldName);
        } else {
            String[] parts = fieldName.split("\\:\\:");
            if (parts.length > 2) {
                throw new FeedbackException("Too many components in field name \"" + fieldName + "\"");
            }
            for (String eachPart : parts) {
                this.validatePart(eachPart);
            }
        }
    }

    private void validatePart(String fieldName) throws FeedbackException {
        if (fieldName.length() > 100) {
            throw new FeedbackException("Field name \"" + fieldName + "\" is too long");
        }
        if (INVALID__CHARS.matcher(fieldName).find()) {
            throw new FeedbackException("Field name \"" + fieldName + "\" contains invalid characters");
        }
        if (SPECIAL_WORDS_PATTERN.matcher(fieldName).find()) {
            throw new FeedbackException("Field name \"" + fieldName + "\" contains invalid words");
        }
        char firstChar = fieldName.charAt(0);
        if (Character.isDigit(firstChar) || Character.isWhitespace(firstChar) || firstChar == '.') {
            throw new FeedbackException("Field name \"" + fieldName + "\" starts with an invalid character");
        }
    }
}

