/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.fmkit.FileMakerOperation;
import com.prosc.fmkit.FmCalculationException;
import com.prosc.fmkit.FmScriptException;
import com.prosc.fmkit.Plugin;
import com.prosc.fmkit.PluginBridge;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.ScriptCall;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMType;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PluginContext {
    private static final Logger log = Logger.getLogger(PluginContext.class.getName());
    private boolean unsafeCalls;
    private long cStartScript;
    private long envCallback;
    private long cCurrentEnv;
    private PluginBridge theBridge;
    private Plugin thePlugin;
    private Thread filemakerThread;
    private PluginFunction whichFunction;
    private FMType functionResult;

    PluginContext(PluginBridge theBridge, Plugin thePlugin, boolean unsafeCalls, long cStartScript, long envCallback, long cCurrentEnv, Thread filemakerThread, PluginFunction whichFunction) {
        this.theBridge = theBridge;
        this.thePlugin = thePlugin;
        this.unsafeCalls = unsafeCalls;
        this.cStartScript = cStartScript;
        this.envCallback = envCallback;
        this.cCurrentEnv = cCurrentEnv;
        this.filemakerThread = filemakerThread;
        this.whichFunction = whichFunction;
    }

    public boolean isUnsafeCalls() {
        return this.unsafeCalls;
    }

    public Thread getFilemakerThread() {
        return this.filemakerThread;
    }

    PluginFunction getWhichFunction() {
        return this.whichFunction;
    }

    public void triggerScript(ScriptCall script) throws FmScriptException {
        try {
            this.triggerScript(script.getFilename(), script.getScriptName(), script.getScriptControl(), script.getParams());
        }
        catch (FmScriptException e) {
            script.setExecutionException(e);
            throw e;
        }
    }

    private void triggerScript(final String filename, final String scriptname, final int currentScriptSettings, final String parameter) throws FmScriptException {
        if (filename == null) {
            throw new NullPointerException("filename must not be null.");
        }
        if (this.getFilemakerThread() == Thread.currentThread()) {
            long paramToken = 0L;
            if (parameter != null && parameter.length() > 0) {
                FMData fmParam = new FMData();
                new FMText(parameter).writeToData(fmParam);
                paramToken = fmParam.getCToken();
            }
            log.fine("Queuing script " + scriptname + " in file " + filename + " from thread " + Thread.currentThread().getName());
            short errorCode = this._triggerScript(filename, scriptname, currentScriptSettings, paramToken, this.cStartScript);
            log.fine("Script queued");
            if (errorCode != 0) {
                throw new FmScriptException(errorCode, filename, scriptname);
            }
        } else {
            log.fine("Current Thread is " + Thread.currentThread().getName() + "; queueing triggerScript to happen on main thread");
            this.theBridge.queueFileMakerOperation(new FileMakerOperation(){

                public void run(PluginContext context) {
                    try {
                        log.fine("Triggering script from main thread: " + Thread.currentThread().getName());
                        PluginContext.this.triggerScript(filename, scriptname, currentScriptSettings, parameter);
                    }
                    catch (FmScriptException e) {
                        log.log(Level.SEVERE, "An error occurred while executing script " + scriptname + " in file " + filename + ": " + e.toString(), e);
                    }
                }
            });
        }
    }

    private native short _triggerScript(String var1, String var2, int var3, long var4, long var6);

    public FMData evaluateExpression(String expression) throws FmCalculationException {
        if (Thread.currentThread() != this.filemakerThread) {
            log.warning("evaluateExpression called from non-FileMaker thread: " + Thread.currentThread());
        }
        log.fine("evaluateExpression: " + expression);
        if (expression == null) {
            throw new IllegalArgumentException("null value passed to evaluateExpression");
        }
        short errorCode = this._evaluateExpression(expression, this.cCurrentEnv, this.envCallback, this.cCurrentEnv == 0L);
        if (errorCode != 0) {
            throw new FmCalculationException(errorCode);
        }
        long dataToken = this._getExpressionResult();
        log.finer("dataToken = " + dataToken);
        FMData result = new FMData(dataToken);
        log.fine("result is " + result);
        return result;
    }

    public String getFontName(FMText text, short fontId) {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }

    private native String _getFontName(long var1, short var3, long var4, long var6, boolean var8);

    public FMData executeSql(String sql, char columnDelimiter, char rowDelimiter) throws FmCalculationException {
        if (sql == null) {
            throw new IllegalArgumentException("A null value was passed to executeSql");
        }
        log.fine("executeSql: " + sql);
        try {
            short errorCode = PluginContext._executeSql(sql, columnDelimiter, rowDelimiter, this.cCurrentEnv, this.envCallback, this.cCurrentEnv == 0L);
            if (errorCode != 0) {
                throw new FmCalculationException(errorCode);
            }
            long dataToken = PluginContext._getSqlResult();
            log.finer("dataToken = " + dataToken);
            FMData result = new FMData(dataToken);
            log.fine("result is " + result);
            return result;
        }
        catch (UnsatisfiedLinkError e) {
            String message = "Could not call executeSql because the optional SQL library is not loaded.";
            throw new RuntimeException(message, e);
        }
    }

    public Object getFieldValue(String filename, String fieldName) throws FmCalculationException {
        String typeInfo;
        if (filename == null) {
            throw new NullPointerException("filename must not be null.");
        }
        log.log(Level.INFO, "Getting field value for filename " + filename + ", fieldname " + fieldName);
        try {
            typeInfo = this.evaluateExpression("FieldType(\"" + filename + "\" ; \"" + fieldName + "\")").getStringData();
            log.log(Level.INFO, typeInfo);
        }
        catch (FmCalculationException e) {
            throw new RuntimeException("Unknown field '" + fieldName + "'.  You must pass a \"table::field\" fieldname to the FMPro.getFieldValue function", e);
        }
        FMData value = this.evaluateExpression(fieldName);
        int firstSpaceIndex = typeInfo.indexOf(32);
        int secondSpace = typeInfo.indexOf(32, firstSpaceIndex + 1);
        String typeName = typeInfo.substring(firstSpaceIndex + 1, secondSpace);
        Class targetClass = FMType.classForFMType(typeName);
        try {
            return FMType.converterForClass(targetClass).convertData(value, targetClass);
        }
        catch (FMType.UnsupportedTypeConversionException e) {
            log.log(Level.WARNING, "Unable to convert " + value + " to " + targetClass, e);
            return value.getStringData();
        }
    }

    private native short _evaluateExpression(String var1, long var2, long var4, boolean var6);

    private native long _getExpressionResult();

    private static native short _executeSql(String var0, char var1, char var2, long var3, long var5, boolean var7);

    private static native long _getSqlResult();

    public String toString() {
        return "PluginContext{theBridge=" + this.theBridge + ", thePlugin=" + this.thePlugin + '}';
    }

    public void dumpDebugInfo() {
        log.info("unsafe calls: " + this.unsafeCalls + "\ncStartScript: " + this.cStartScript + "\ncCurrentEnv: " + this.cCurrentEnv);
    }

    public synchronized void setFunctionResult(FMType functionResult) {
        this.functionResult = functionResult;
    }

    public synchronized FMType getFunctionResult() {
        return this.functionResult;
    }
}

