/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveMap<V>
implements Map<String, V>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final Map<String, V> lower = new HashMap<String, V>();
    private final Map<String, String> originalKeyNameByLowercaseName = new HashMap<String, String>();

    private String toLowerCase(Object key) {
        if (key == null) {
            return null;
        }
        return key.toString().toLowerCase();
    }

    @Override
    public int size() {
        return this.lower.size();
    }

    @Override
    public boolean isEmpty() {
        return this.lower.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.lower.containsKey(this.toLowerCase(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.lower.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.lower.get(this.toLowerCase(key));
    }

    public V get(Object key, V defaultValue) {
        V result = this.lower.get(this.toLowerCase(key));
        return result == null ? defaultValue : result;
    }

    @Override
    public V put(String key, V value) {
        String lowerKey = this.toLowerCase(key);
        this.originalKeyNameByLowercaseName.put(lowerKey, key);
        return this.lower.put(lowerKey, value);
    }

    @Override
    public V remove(Object key) {
        String lowerKey = this.toLowerCase(key);
        this.originalKeyNameByLowercaseName.remove(lowerKey);
        return this.lower.remove(lowerKey);
    }

    @Override
    public void clear() {
        this.originalKeyNameByLowercaseName.clear();
        this.lower.clear();
    }

    @Override
    public Set<String> keySet() {
        return new HashSet<String>(this.originalKeyNameByLowercaseName.values());
    }

    @Override
    public Collection<V> values() {
        return this.lower.values();
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> t) {
        for (Map.Entry<String, V> eachEntry : t.entrySet()) {
            this.put(eachEntry.getKey(), eachEntry.getValue());
        }
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        HashSet<Map.Entry<String, V>> result = new HashSet<Map.Entry<String, V>>(this.size());
        for (Map.Entry<String, V> eachLowerEntry : this.lower.entrySet()) {
            result.add(new CaseInsensitiveEntry(eachLowerEntry));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CaseInsensitiveEntry
    implements Map.Entry<String, V> {
        private final Map.Entry<String, V> lowerEntry;

        public CaseInsensitiveEntry(Map.Entry<String, V> lowerEntry) {
            this.lowerEntry = lowerEntry;
        }

        @Override
        public String getKey() {
            return (String)CaseInsensitiveMap.this.originalKeyNameByLowercaseName.get(this.lowerEntry.getKey());
        }

        @Override
        public V getValue() {
            return this.lowerEntry.getValue();
        }

        @Override
        public V setValue(V value) {
            return CaseInsensitiveMap.this.put(this.getKey(), value);
        }
    }
}

