/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.beanshell;

import com.prosc.beanshell.BeanShellModel;
import com.prosc.beanshell.BeanShellPlugin;
import com.prosc.fmkit.FunctionSignature;
import com.prosc.fmkit.Plugin;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.types.Converter;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMType;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public class GroovyFunction
implements PluginFunction,
Serializable {
    private Script compiledScript;
    private static Converter paramConverter;
    private boolean isGuiFunction;
    private FunctionSignature functionSignature;

    public GroovyFunction(ClassLoader classLoader, FunctionSignature signature, String script, boolean isGui) {
        this.functionSignature = signature;
        GroovyShell shell = new GroovyShell(classLoader, new Binding(new HashMap(this.functionSignature.getArgNames().size())));
        this.compiledScript = shell.parse(script);
        this.isGuiFunction = isGui;
    }

    public GroovyFunction(FunctionSignature functionSignature, Script compiledScript, boolean isGui) {
        this.functionSignature = functionSignature;
        this.compiledScript = compiledScript;
        this.isGuiFunction = isGui;
    }

    public String getName() {
        return this.functionSignature.getName();
    }

    public short getFunctionID() {
        return (short)this.getName().hashCode();
    }

    public String getPrototype() {
        return this.functionSignature.getPrototype();
    }

    public int getMinArgs() {
        return this.functionSignature.getMinArgs();
    }

    public int getMaxArgs() {
        return this.functionSignature.getMaxArgs();
    }

    public int getFlags() {
        return 65280;
    }

    public boolean isGuiFunction() {
        return this.isGuiFunction;
    }

    public Object[] convertParams(FMData[] rawParams) {
        Object[] result = new String[rawParams.length];
        for (int i = 0; i < rawParams.length; ++i) {
            FMData eachRaw = rawParams[i];
            result[i] = eachRaw == null ? null : paramConverter.convertData(eachRaw, String.class);
        }
        return result;
    }

    public Object invoke(Plugin pluginInstance, Object[] parameters) throws IllegalAccessException, InvocationTargetException {
        BeanShellPlugin plugin = (BeanShellPlugin)pluginInstance;
        BeanShellModel model = plugin.getBeanShellModel();
        Thread.currentThread().setContextClassLoader(model.getClassLoader());
        model.clearOldVariables();
        plugin.errorVars = new HashMap<String, String>();
        Binding binding = this.compiledScript.getBinding();
        for (int i = 0; i < parameters.length; ++i) {
            binding.setVariable(this.functionSignature.getArgNames().get(i), parameters[i]);
        }
        binding.setVariable("fmpro", model.getFmpro());
        FMType result = BeanShellPlugin.convertedResult(this.compiledScript.run());
        model.setBinding(binding);
        return result;
    }

    public String toString() {
        return "PluginFunction{name='" + this.getName() + "'" + "}";
    }

    static {
        try {
            paramConverter = FMType.converterForClass(String.class);
        }
        catch (FMType.UnsupportedTypeConversionException e) {
            throw new RuntimeException(e);
        }
    }
}

