/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.license.client;

import com.prosc.license.client.ExpiredLicenseException;
import com.prosc.license.client.InvalidLicenseException;
import com.prosc.license.client.License;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Registration
implements Serializable {
    private static final Logger log = Logger.getLogger(Registration.class.getName());
    private final byte version;
    private final short productCode;
    private final Date majorReleaseDate;
    private String licenseKey;
    private License cachedLicense;
    private String companyName;
    private final long createdDate = System.currentTimeMillis();
    private long expirationDate = 0L;
    private boolean requireDemoLicense = false;
    private static final long DEMO_TIMEOUT_MILLIS = 0x6DDD00L;
    private boolean portfolioAllowed = true;

    public Registration(byte version, short productCode, Date majorReleaseDate) {
        this.version = version;
        this.productCode = productCode;
        this.majorReleaseDate = majorReleaseDate;
    }

    public Registration(byte version, short productCode, String majorReleaseDate) {
        this(version, productCode, Registration.dateFor(majorReleaseDate));
    }

    private static Date dateFor(String majorReleaseDate) {
        try {
            return DateFormat.getDateInstance(3, Locale.US).parse(majorReleaseDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
        this.cachedLicense = null;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public void setLicenseKey(String key) {
        this.licenseKey = key;
        this.cachedLicense = null;
    }

    public byte getVersion() {
        return this.version;
    }

    public void checkLicense() throws InvalidLicenseException {
        boolean isExpired;
        String licenseKey = this.getLicenseKey();
        String companyName = this.getCompanyName();
        if ((licenseKey == null || licenseKey.length() == 0) && this.requireDemoLicense) {
            throw new InvalidLicenseException("This product must be registered with a valid license key.", licenseKey);
        }
        if (this.cachedLicense == null) {
            this.cachedLicense = !(licenseKey != null && licenseKey.length() != 0 || companyName != null && companyName.length() != 0) ? this.createDemoLicense() : this.createLicense(licenseKey, companyName);
            if (this.cachedLicense.getVariant() == 0) {
                log.info("Registered successfully with demo license; will run for two hours after launch.");
                if (this.getExpirationDate() == 0L) {
                    this.setExpirationDate(this.createdDate + 0x6DDD00L);
                    log.log(Level.INFO, "Expiration date " + new Date(this.getExpirationDate()));
                }
                if (this.cachedLicense.getExpirationDate() < this.getExpirationDate()) {
                    this.setExpirationDate(this.cachedLicense.getExpirationDate());
                }
            } else {
                log.fine("Registered successfully.");
                this.setExpirationDate(this.cachedLicense.getExpirationDate());
            }
        }
        boolean bl = isExpired = System.currentTimeMillis() > this.expirationDate || this.cachedLicense.getVariant() == 0 && System.currentTimeMillis() < this.createdDate;
        if (this.cachedLicense.isPortfolio() && this.isPortfolioAllowed()) {
            if (this.cachedLicense.getVariant() == 0 || this.cachedLicense.getVersion() != 1) {
                throw new InvalidLicenseException("Portfolio licenses cannot use DEMO variants, and cannot have version numbers which are not '1'", this.cachedLicense);
            }
        } else {
            if (this.productCode != this.cachedLicense.getProductCode()) {
                throw new InvalidLicenseException("License key provided is for a different product (expected " + this.productCode + "; found " + this.cachedLicense.getProductCode() + ")", licenseKey, companyName);
            }
            if (this.cachedLicense.getVersion() > 0 && this.cachedLicense.getVersion() < this.version) {
                throw new InvalidLicenseException("License is for an older product version.", licenseKey, companyName);
            }
            if (isExpired) {
                if (this.cachedLicense.getVariant() == 0) {
                    throw new ExpiredLicenseException("DEMO mode expired! (" + this.productCode + ") You can continue to run in demo mode by restarting FileMaker, or you can register with a valid license key from http://www.360works.com.", this.cachedLicense.getEncryptedKey());
                }
                throw new ExpiredLicenseException("This license key expired on " + new Date(this.getExpirationDate()), this.cachedLicense.getEncryptedKey());
            }
        }
        if (this.majorReleaseDate != null && this.cachedLicense.getMaxReleaseDate() != 0L && this.majorReleaseDate.getTime() > this.cachedLicense.getMaxReleaseDate()) {
            DateFormat df = DateFormat.getDateInstance();
            throw new InvalidLicenseException("Your license covers products released up to " + df.format(new Date(this.cachedLicense.getMaxReleaseDate())) + ", but the release date is " + df.format(this.majorReleaseDate), this.cachedLicense.getEncryptedKey());
        }
        if (this.cachedLicense.getVariant() == 127) {
            throw new InvalidLicenseException("This license has been deactivated.", this.cachedLicense.getEncryptedKey());
        }
    }

    protected License createLicense(String licenseKey, String companyName) throws InvalidLicenseException {
        return new License(licenseKey, companyName);
    }

    protected License createDemoLicense() {
        return new License(0, this.productCode, this.version, 0, System.currentTimeMillis(), System.currentTimeMillis() + 0x6DDD00L, Long.MAX_VALUE, null, null);
    }

    public String getLicenseInfo() {
        try {
            this.checkLicense();
            StringBuffer result = new StringBuffer();
            result.append("Major Version: ").append(this.getVersion()).append("\n");
            result.append("Type: ").append(this.cachedLicense.getVariantName()).append("\n");
            result.append("Registered To: ").append(this.cachedLicense.getRegisteredTo()).append("\n");
            if (this.expirationDate != Long.MAX_VALUE) {
                String expirationLabel = this.cachedLicense.isPortfolio() ? "Portfolio renewal date: " : "Expires on: ";
                result.append(expirationLabel).append(DateFormat.getDateTimeInstance().format(new Date(this.expirationDate))).append("\n");
            }
            return result.toString();
        }
        catch (InvalidLicenseException e) {
            return e.getMessage();
        }
    }

    public License getLicense() {
        if (this.cachedLicense == null) {
            try {
                this.checkLicense();
            }
            catch (InvalidLicenseException e) {
                log.log(Level.FINER, "License is invalid", e);
            }
        }
        return this.cachedLicense;
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    private void setExpirationDate(long expirationDate) {
        this.expirationDate = expirationDate;
    }

    public boolean isRequireDemoLicense() {
        return this.requireDemoLicense;
    }

    public void setRequireDemoLicense(boolean requireDemoLicense) {
        this.requireDemoLicense = requireDemoLicense;
    }

    private boolean isPortfolioAllowed() {
        return this.portfolioAllowed;
    }

    public void setPortfolioAllowed(boolean portfolioAllowed) {
        this.portfolioAllowed = portfolioAllowed;
    }
}

