/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.license.client;

import com.prosc.license.client.LicenseConflictException;
import com.prosc.license.client.LicenseConflictNode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LicenseConflictChecker {
    private static final Logger log = Logger.getLogger(LicenseConflictChecker.class.getName());
    private final byte[] bytePattern;
    private final InetAddress groupAddress;
    private final int port;
    private final int checkFrequency;
    private final int conflictCountThreshold;
    private final HashMap<String, InetAddress> conflicts;
    private final MulticastSocket socket;
    private final String nodeName;

    public LicenseConflictChecker(byte[] bytePattern, int checkFrequency, InetAddress groupAddress, int port, int conflictCountThreshold, String nodeName) throws IOException {
        this.bytePattern = bytePattern;
        this.groupAddress = groupAddress;
        this.port = port;
        this.checkFrequency = checkFrequency;
        this.conflictCountThreshold = conflictCountThreshold;
        this.conflicts = new HashMap(conflictCountThreshold);
        if (nodeName == null) {
            nodeName = UUID.randomUUID().toString();
        }
        if (nodeName.length() > 40) {
            nodeName = nodeName.substring(0, 40);
        }
        while (nodeName.getBytes("utf-8").length > 40) {
            nodeName = nodeName.substring(0, nodeName.length() - 1);
        }
        this.nodeName = nodeName;
        this.socket = new MulticastSocket(port);
        this.socket.setSoTimeout(checkFrequency);
        this.socket.joinGroup(groupAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForConflicts() throws LicenseConflictException {
        Thread licenseCheckSend = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                byte[] nodeBytes;
                try {
                    nodeBytes = LicenseConflictChecker.this.nodeName.getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                byte[] bytesToSend = new byte[LicenseConflictChecker.this.bytePattern.length + nodeBytes.length];
                System.arraycopy(LicenseConflictChecker.this.bytePattern, 0, bytesToSend, 0, LicenseConflictChecker.this.bytePattern.length);
                System.arraycopy(nodeBytes, 0, bytesToSend, LicenseConflictChecker.this.bytePattern.length, nodeBytes.length);
                DatagramPacket packetOut = new DatagramPacket(bytesToSend, 0, bytesToSend.length, LicenseConflictChecker.this.groupAddress, LicenseConflictChecker.this.port);
                try {
                    while (true) {
                        MulticastSocket multicastSocket = LicenseConflictChecker.this.socket;
                        synchronized (multicastSocket) {
                            try {
                                LicenseConflictChecker.this.socket.leaveGroup(LicenseConflictChecker.this.groupAddress);
                                try {
                                    log.finer("Sending packet...");
                                    LicenseConflictChecker.this.socket.send(packetOut);
                                }
                                finally {
                                    LicenseConflictChecker.this.socket.joinGroup(LicenseConflictChecker.this.groupAddress);
                                }
                            }
                            catch (IOException e) {
                                log.log(Level.WARNING, "Unable to send license check packet; ignoring and continuing: " + e.toString(), e);
                            }
                        }
                        Thread.sleep(LicenseConflictChecker.this.checkFrequency);
                    }
                }
                catch (InterruptedException e) {
                    log.log(Level.INFO, "LicenseCheckSend thread was interrupted; exiting");
                    return;
                }
            }
        }, "LicenseCheckSend");
        licenseCheckSend.start();
        try {
            try {
                byte[] bufferIn = new byte[this.bytePattern.length + 40];
                DatagramPacket packetIn = new DatagramPacket(bufferIn, bufferIn.length);
                while (true) {
                    try {
                        log.finer("Waiting to receive packets...");
                        try {
                            this.conflicts.clear();
                            while (true) {
                                MulticastSocket multicastSocket = this.socket;
                                synchronized (multicastSocket) {
                                    this.socket.receive(packetIn);
                                }
                                if (packetIn.getLength() != this.bytePattern.length || !this.byteArrayEquals(packetIn.getData(), packetIn.getOffset(), this.bytePattern.length, this.bytePattern, 0)) continue;
                                int nameOffset = packetIn.getOffset() + this.bytePattern.length;
                                int nameLength = packetIn.getLength() - nameOffset;
                                String whichNode = new String(packetIn.getData(), nameOffset, nameLength, "utf-8");
                                if (whichNode.equals(this.nodeName)) {
                                    log.finer("We're seeing ourselves, ignore");
                                    continue;
                                }
                                InetAddress conflictingAddress = packetIn.getAddress();
                                if (this.conflicts.put(whichNode, conflictingAddress) == null) {
                                    log.fine("Found a conflict with " + whichNode + " " + conflictingAddress);
                                }
                                if (this.conflicts.size() >= this.conflictCountThreshold) {
                                    ArrayList<LicenseConflictNode> result = new ArrayList<LicenseConflictNode>(this.conflicts.size());
                                    for (Map.Entry<String, InetAddress> entry : this.conflicts.entrySet()) {
                                        result.add(new LicenseConflictNode(entry.getKey(), entry.getValue()));
                                    }
                                    log.warning("Found " + this.conflicts.size() + " other conflicting license keys in use, only " + this.conflictCountThreshold + " keys are allowed");
                                    throw new LicenseConflictException(result);
                                }
                                log.fine("Found " + this.conflicts.size() + " conflicts; less than threshold of " + this.conflictCountThreshold);
                            }
                        }
                        catch (SocketTimeoutException e) {
                            log.finer("No other nodes found");
                        }
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, "Error while checking for license conflicts. Will ignore error and keep trying. " + e.toString(), e);
                        Thread.sleep(this.checkFrequency);
                    }
                    Thread.sleep(1L);
                }
            }
            catch (LicenseConflictException e) {
                log.log(Level.INFO, "LicenseConflict detected: " + e, e);
                throw e;
            }
            catch (InterruptedException e) {
                log.info("LicenseCheckReceive thread was interrupted; exiting");
                log.log(Level.INFO, "Will now interrupt licenseCheckSend thread");
                licenseCheckSend.interrupt();
                MulticastSocket multicastSocket = this.socket;
                synchronized (multicastSocket) {
                    try {
                        this.socket.leaveGroup(this.groupAddress);
                    }
                    catch (IOException e2) {
                        log.log(Level.WARNING, "Error when trying to leave multicast group: " + e2, e2);
                    }
                    finally {
                        this.socket.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            log.log(Level.INFO, "Will now interrupt licenseCheckSend thread");
            licenseCheckSend.interrupt();
            MulticastSocket multicastSocket = this.socket;
            synchronized (multicastSocket) {
                try {
                    this.socket.leaveGroup(this.groupAddress);
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Error when trying to leave multicast group: " + e, e);
                }
                finally {
                    this.socket.close();
                }
            }
            throw throwable;
        }
    }

    private boolean byteArrayEquals(byte[] bytes1, int offset1, int length, byte[] bytes2, int offset2) {
        for (int n = 0; n < length; ++n) {
            if (bytes1[offset1++] == bytes2[offset2++]) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws IOException {
        byte[] bytesToCheck = "HiThere".getBytes("utf-8");
        final LicenseConflictChecker conflictChecker = new LicenseConflictChecker(bytesToCheck, 5000, InetAddress.getByName("230.0.10.78"), 4345, 2, null);
        new Thread(new Runnable(){

            public void run() {
                try {
                    conflictChecker.checkForConflicts();
                }
                catch (LicenseConflictException e) {
                    String message = "Found " + e.getConflictingAddresses().size() + " conflicting nodes";
                    for (LicenseConflictNode node : e.getConflictingAddresses()) {
                        message = message + "\n" + node.toString();
                    }
                    log.info(message);
                }
            }
        }, LicenseConflictChecker.class.getName()).start();
    }
}

