/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.license.client;

import com.prosc.license.client.Base32;
import com.prosc.license.client.Base32LicenseChars;
import com.prosc.license.client.ByteArrayParser;
import com.prosc.license.client.InvalidLicenseException;
import com.prosc.license.client.LicenseDecryptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class DefaultLicenseDecryptor
implements LicenseDecryptor {
    private Number productId;
    private Number version;
    private Number orderId;
    private Date orderDate;
    private Byte variant;
    private Date expirationDate;
    private Date maxReleaseDate;
    private Byte companyHash;
    private static final String INVALID_LICENSE_STRING = "Invalid license string.";
    public static final int HASH_LENGTH = 4;
    private char algorithmVersion;
    public static final byte[] SALT = "NaCl".getBytes();
    public static final Date EPOCH;

    public DefaultLicenseDecryptor(String licenseKey) throws InvalidLicenseException {
        block12: {
            ByteArrayParser parser = new ByteArrayParser(this.payloadForLicenseString(licenseKey));
            try {
                if (this.algorithmVersion == 'B' || this.algorithmVersion == 'C') {
                    this.productId = parser.readShort();
                    this.version = parser.readShort();
                    this.variant = parser.readByte();
                    this.companyHash = parser.readByte();
                    this.orderId = parser.readInteger();
                    if (parser.bytesRemaining() >= 8) {
                        this.expirationDate = new Date(parser.readLong());
                    }
                    this.orderDate = null;
                    break block12;
                }
                if (this.algorithmVersion == 'D') {
                    this.productId = parser.readShort();
                    this.version = parser.readByte();
                    this.variant = parser.readByte();
                    this.companyHash = parser.readByte();
                    this.orderId = parser.readIntegerMidget();
                    this.orderDate = this.dateForDays(parser.readShort());
                    if (parser.bytesRemaining() <= 0) break block12;
                    byte fieldIdentifierBitSet = parser.readByte();
                    if ((fieldIdentifierBitSet & 1) == 1) {
                        this.expirationDate = this.dateForDays(parser.readShort());
                    }
                    if ((fieldIdentifierBitSet & 2) == 2) {
                        this.maxReleaseDate = this.dateForDays(parser.readShort());
                    }
                    if ((fieldIdentifierBitSet & 4) == 4) {
                        // empty if block
                    }
                    if ((fieldIdentifierBitSet & 8) == 8) {
                        // empty if block
                    }
                    if ((fieldIdentifierBitSet & 0x10) == 16) {
                        // empty if block
                    }
                    if ((fieldIdentifierBitSet & 0x20) == 32) {
                        // empty if block
                    }
                    if ((fieldIdentifierBitSet & 0x40) == 64) {
                        // empty if block
                    }
                    if ((fieldIdentifierBitSet & 0x80) != 128) break block12;
                }
                throw new IllegalStateException("Unknown algorithm version: " + this.algorithmVersion);
            }
            catch (IOException e) {
                throw new InvalidLicenseException("License string was incorrectly formatted.", licenseKey);
            }
        }
    }

    private Date dateForDays(Short aShort) {
        if (aShort == null) {
            return new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.set(2000, 0, 1, 0, 0, 0);
        cal.add(6, aShort.shortValue());
        return cal.getTime();
    }

    public String toString() {
        return "DefaultLicenseDecryptor{productId=" + this.productId + ", version=" + this.version + ", orderId=" + this.orderId + ", expirationDate=" + this.expirationDate + ", maxReleaseDate=" + this.maxReleaseDate + ", variant=" + this.variant + ", companyHash=" + this.companyHash + '}';
    }

    public byte[] payloadForLicenseString(String licenseString) throws InvalidLicenseException {
        if (licenseString != null) {
            licenseString = licenseString.trim();
        }
        if (licenseString == null || licenseString.length() == 0) {
            throw new InvalidLicenseException("License string is empty", licenseString);
        }
        licenseString = licenseString.toUpperCase();
        this.algorithmVersion = licenseString.charAt(0);
        try {
            byte[] licenseBytes = this.licenseStringToBytes(licenseString.substring(1));
            byte[] digestBytes = new byte[4];
            byte[] payload = new byte[licenseBytes.length - digestBytes.length];
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(licenseBytes);
            byteInputStream.read(digestBytes, 0, digestBytes.length);
            byteInputStream.read(payload, 0, payload.length);
            MessageDigest checksum = MessageDigest.getInstance("MD5");
            if (this.algorithmVersion == 'D' || this.algorithmVersion == 'C') {
                checksum.reset();
                checksum.update(SALT);
            }
            byte[] payloadHashTmp = checksum.digest(payload);
            byte[] payloadHash = new byte[4];
            System.arraycopy(payloadHashTmp, 0, payloadHash, 0, payloadHash.length);
            if (MessageDigest.isEqual(payloadHash, digestBytes)) {
                return payload;
            }
            throw new InvalidLicenseException(INVALID_LICENSE_STRING, licenseString);
        }
        catch (NegativeArraySizeException err) {
            throw new InvalidLicenseException(INVALID_LICENSE_STRING, licenseString, err);
        }
        catch (NumberFormatException err) {
            throw new InvalidLicenseException(INVALID_LICENSE_STRING, licenseString, err);
        }
        catch (IllegalArgumentException err) {
            throw new InvalidLicenseException(INVALID_LICENSE_STRING, licenseString, err);
        }
        catch (NoSuchAlgorithmException err) {
            throw new RuntimeException(err);
        }
    }

    protected byte[] licenseStringToBytes(String licenseString) throws NumberFormatException, InvalidLicenseException {
        switch (this.algorithmVersion) {
            case 'B': {
                BigInteger bigInt = new BigInteger(licenseString, 36);
                bigInt = bigInt.testBit(0) ? bigInt.shiftRight(1).negate() : bigInt.shiftRight(1);
                return bigInt.toByteArray();
            }
            case 'C': {
                return Base32.decode(licenseString);
            }
            case 'D': {
                return Base32LicenseChars.decode(licenseString);
            }
        }
        throw new InvalidLicenseException("This license type is not supported. You may have switched the 'License Key' and 'Registered To' fields, or need to upgrade to a newer version of the product.", licenseString);
    }

    public Number getProductId() {
        return this.productId;
    }

    public Number getVersion() {
        return this.version;
    }

    public Number getOrderId() {
        return this.orderId;
    }

    public Date getOrderDate() {
        if (this.orderDate == null) {
            this.orderDate = this.lookupOrderDateByOrderNumber();
        }
        return this.orderDate;
    }

    private Date lookupOrderDateByOrderNumber() {
        try {
            DateFormat df = DateFormat.getDateInstance(3, Locale.US);
            if (this.orderId.intValue() == 0) {
                return df.parse("7/1/10");
            }
            if (this.orderId.intValue() <= 11636) {
                return df.parse("4/15/2009");
            }
            if (this.orderId.intValue() <= 13350) {
                return df.parse("6/16/2009");
            }
            if (this.orderId.intValue() <= 14713) {
                return df.parse("7/31/2009");
            }
            if (this.orderId.intValue() <= 15851) {
                return df.parse("9/10/2009");
            }
            if (this.orderId.intValue() <= 17097) {
                return df.parse("10/30/2009");
            }
            if (this.orderId.intValue() <= 18850) {
                return df.parse("12/21/2009");
            }
            if (this.orderId.intValue() <= 19518) {
                return df.parse("2/1/2010");
            }
            if (this.orderId.intValue() <= 22097) {
                return df.parse("4/30/2010");
            }
            if (this.orderId.intValue() <= 23662) {
                return df.parse("7/1/2010");
            }
            return df.parse("7/1/2010");
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Byte getVariant() {
        return this.variant;
    }

    public Byte getCompanyHash() {
        return this.companyHash;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public boolean isRegisteredTo(String licenseeName) {
        if (licenseeName == null) {
            throw new NullPointerException("licenseeName must not be null.");
        }
        byte hashcodeByte = (byte)licenseeName.hashCode();
        byte b = (byte)Math.abs(hashcodeByte);
        if (b == -128) {
            if (this.companyHash == -128) {
                return true;
            }
            b = 127;
        }
        return b == this.companyHash;
    }

    public long getMaxReleaseDate() {
        if (this.maxReleaseDate == null) {
            if (this.productId.intValue() == 35) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(this.getOrderDate());
                ((Calendar)cal).add(1, 1);
                this.maxReleaseDate = cal.getTime();
            } else {
                this.maxReleaseDate = new Date(Long.MAX_VALUE);
            }
        }
        return this.maxReleaseDate.getTime();
    }

    static {
        try {
            EPOCH = DateFormat.getDateInstance(3, Locale.US).parse("1/1/2000");
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

