/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;

public class IOUtils {
    private static final Logger log = Logger.getLogger(IOUtils.class.getName());
    public static final int CHUNK_SIZE = 8192;
    private static String systemEncoding = System.getProperty("file.encoding");

    public static long writeInputToOutput(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int lastBytesRead;
        if (in == null) {
            throw new IllegalArgumentException("You cannot pass a null InputStream");
        }
        if (out == null) {
            throw new IllegalArgumentException("You cannot pass a null OutputStream");
        }
        byte[] buffer = new byte[bufferSize];
        long totalBytesRead = 0L;
        while ((lastBytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, lastBytesRead);
            totalBytesRead += (long)lastBytesRead;
        }
        out.flush();
        return totalBytesRead;
    }

    public static long writeFixedByteCount(InputStream in, FileOutputStream out, long size) throws IOException {
        long totalBytesRead;
        int bytesRead;
        byte[] buffer = new byte[8192];
        for (totalBytesRead = 0L; totalBytesRead < size; totalBytesRead += (long)bytesRead) {
            long nextChunk = size - totalBytesRead;
            if (nextChunk > (long)buffer.length) {
                nextChunk = buffer.length;
            }
            if ((bytesRead = in.read(buffer, 0, (int)nextChunk)) == -1) break;
            out.write(buffer, 0, bytesRead);
        }
        return totalBytesRead;
    }

    public static long writeInputToOutput(InputStream in, OutputStream out, byte[] stopSequence) throws IOException {
        int eachByte;
        int result;
        int sequenceMark = 0;
        int sequenceLength = stopSequence.length;
        for (result = 0; sequenceMark < sequenceLength && result < 1600 && (eachByte = in.read()) != -1; ++result) {
            out.write(eachByte);
            if (eachByte == stopSequence[sequenceMark]) {
                ++sequenceMark;
                continue;
            }
            sequenceMark = 0;
        }
        return result;
    }

    public static byte[] inputStreamAsBytes(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Null stream was passed to inputStreamAsBytes");
        }
        ByteArrayOutputStream allBytes = new ByteArrayOutputStream(stream.available());
        IOUtils.writeInputToOutput(stream, (OutputStream)allBytes, 8192);
        allBytes.close();
        return allBytes.toByteArray();
    }

    public static String inputStreamAsString(InputStream stream) throws IOException {
        return IOUtils.inputStreamAsString(stream, "utf-8");
    }

    public static String inputStreamAsString(InputStream stream, String charset) throws IOException {
        return new String(IOUtils.inputStreamAsBytes(stream), charset);
    }

    public static StringBuffer readerAsString(Reader reader, StringBuffer toAppendTo) throws IOException {
        int charsRead;
        char[] buffer = new char[8192];
        while ((charsRead = reader.read(buffer)) != -1) {
            toAppendTo.append(buffer, 0, charsRead);
        }
        return toAppendTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String urlConnectionAsString(URLConnection theConnection) throws IOException {
        InputStream theStream = theConnection.getInputStream();
        try {
            String string = IOUtils.inputStreamAsString(theStream);
            return string;
        }
        finally {
            theStream.close();
        }
    }

    public static void postDataToUrlConnection(String postArgs, URLConnection theConnection) throws IOException {
        theConnection.setDoOutput(true);
        theConnection.setRequestProperty("content-length", "" + postArgs.length());
        PrintStream out = new PrintStream(theConnection.getOutputStream(), false, "utf-8");
        out.print(postArgs);
        out.flush();
        out.close();
    }

    public static String getUrlContents(String theUrl) throws IOException {
        return IOUtils.getUrlContents(theUrl, null);
    }

    public static String getUrlContents(String theUrl, String postArgs) throws IOException {
        return IOUtils.getUrlContents(theUrl, postArgs, null);
    }

    public static String getUrlContents(String theUrl, String postArgs, Integer timeout) throws IOException {
        log.log(Level.INFO, "Reading URL contents of " + theUrl + " postArgs size = " + (postArgs == null ? 0 : postArgs.length()));
        URLConnection theConnection = new URL(theUrl).openConnection();
        if (timeout != null) {
            theConnection.setConnectTimeout(timeout);
            theConnection.setReadTimeout(timeout);
        }
        if (postArgs != null) {
            IOUtils.postDataToUrlConnection(postArgs, theConnection);
        }
        return IOUtils.urlConnectionAsString(theConnection);
    }

    public static void enableSSL() {
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        try {
            Security.addProvider((Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] fileAsBytes(String whichFile) throws IOException {
        return IOUtils.fileAsBytes(new File(whichFile));
    }

    public static byte[] fileAsBytes(File whichFile) throws IOException {
        log.log(Level.FINE, "Reading file contents " + whichFile);
        byte[] data = new byte[(int)whichFile.length()];
        FileInputStream in = new FileInputStream(whichFile);
        in.read(data);
        in.close();
        return data;
    }

    public static String fileAsString(File whichFile) throws IOException {
        return IOUtils.fileAsString(whichFile, "UTF-8");
    }

    public static String fileAsString(File whichFile, String charset) throws IOException {
        return new String(IOUtils.fileAsBytes(whichFile), charset);
    }

    public static File ensureUniqueFilename(File whichFile) {
        if (whichFile.exists()) {
            int suffixMarker = whichFile.getName().lastIndexOf(46);
            String suffix = "";
            String prefix = whichFile.getPath();
            if (suffixMarker != -1) {
                suffix = whichFile.getName().substring(suffixMarker);
                prefix = whichFile.getParent() + File.separator + whichFile.getName().substring(0, suffixMarker);
            }
            int appendInt = 1;
            while (whichFile.exists()) {
                whichFile = new File(prefix + '-' + appendInt + suffix);
                ++appendInt;
            }
        }
        return whichFile;
    }

    public static String getMimeType(String fileName) {
        if (fileName == null) {
            return null;
        }
        String mimeType = IOUtils.getExactMimeType(fileName);
        if (mimeType == null) {
            mimeType = "untyped/binary";
        }
        return mimeType;
    }

    public static String getExactMimeType(String fileName) {
        if (fileName == null) {
            return null;
        }
        String mimeType = URLConnection.getFileNameMap().getContentTypeFor(fileName);
        if (mimeType == null) {
            try {
                String suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
                if ("js".equals(suffix)) {
                    mimeType = "text/javascript";
                } else if ("tgz".equals(suffix)) {
                    mimeType = "application/x-tar";
                } else if ("css".equals(suffix)) {
                    mimeType = "text/css";
                } else if ("ico".equals(suffix)) {
                    mimeType = "image/x-icon";
                } else if ("sit".equals(suffix)) {
                    mimeType = "application/x-stuffit";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return mimeType;
    }

    public static String urlEncodeMap(Map dict) {
        String urlString = "";
        Iterator iterator = dict.keySet().iterator();
        while (iterator.hasNext()) {
            String aKey = (String)iterator.next();
            Object anObject = dict.get(aKey);
            aKey = IOUtils.encode(aKey);
            if (anObject instanceof List) {
                Iterator en = ((List)anObject).iterator();
                while (en.hasNext()) {
                    String nextElement = (String)en.next();
                    urlString = urlString + aKey + "=" + IOUtils.encode(nextElement);
                    if (!en.hasNext()) continue;
                    urlString = urlString + "&";
                }
            } else {
                urlString = urlString + aKey + "=" + IOUtils.encode((String)anObject);
            }
            if (!iterator.hasNext()) continue;
            urlString = urlString + "&";
        }
        return urlString;
    }

    public static String systemEncoding() {
        return systemEncoding;
    }

    public static String encode(String input) {
        try {
            return URLEncoder.encode(input, systemEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decode(String input) {
        try {
            return URLDecoder.decode(input, systemEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                String msg = "Failed to close " + closeable;
                log.log(Level.WARNING, msg, e);
                throw new RuntimeException(msg, e);
            }
        }
    }

    public static void closeQuietly(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                String msg = "Failed to close outputStream " + outputStream;
                log.log(Level.WARNING, msg, e);
                throw new RuntimeException(msg, e);
            }
        } else {
            log.log(Level.INFO, "Received null outputStream");
        }
    }

    public static void closeQuietly(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                String msg = "Failed to close reader " + reader;
                log.log(Level.WARNING, msg, e);
                throw new RuntimeException(msg);
            }
        } else {
            log.log(Level.INFO, "Received null reader");
        }
    }

    public static void closeQuietly(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to close inputStream " + inputStream, e);
            }
        } else {
            log.log(Level.INFO, "Received null inputStream");
        }
    }

    public static void closeQuietly(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to close writer " + writer, e);
            }
        } else {
            log.log(Level.INFO, "Received null writer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest) throws IOException {
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        try {
            IOUtils.writeInputToOutput((InputStream)in, (OutputStream)out, 8192);
        }
        finally {
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                IOUtils.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            IOUtils.copyFile(srcDir, dstDir);
        }
    }

    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to close socket " + socket, e);
            }
        } else {
            log.log(Level.INFO, "Received null socket");
        }
    }

    public static void closeQuietly(ServerSocket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to close socket " + socket, e);
            }
        } else {
            log.log(Level.INFO, "Received null socket");
        }
    }

    public static void writeReaderToWriter(Reader reader, Writer writer) throws IOException {
        IOUtils.writeReaderToWriter(reader, writer, new char[1024]);
    }

    private static void writeReaderToWriter(Reader reader, Writer writer, char[] buffer) throws IOException {
        int charsRead;
        int off = 0;
        int len = buffer.length;
        do {
            charsRead = reader.read(buffer, off, len);
            off += charsRead;
            writer.write(buffer, 0, charsRead);
        } while (charsRead != -1);
    }

    public static boolean deleteRecursive(File fileToDelete) {
        boolean b;
        if (fileToDelete.isDirectory()) {
            File[] children = fileToDelete.listFiles();
            for (int n = 0; n < children.length; ++n) {
                if (IOUtils.deleteRecursive(children[n])) continue;
                return false;
            }
        }
        if (!(b = fileToDelete.delete())) {
            log.log(Level.WARNING, "Could not delete " + fileToDelete);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDir(String dir2zip, String zipFileName) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFileName));
        try {
            IOUtils._zipDir(dir2zip, zos);
        }
        finally {
            zos.close();
        }
    }

    public static void _zipDir(String dir2zip, ZipOutputStream zos) throws IOException {
        File zipDir = new File(dir2zip);
        String[] dirList = zipDir.list();
        byte[] readBuffer = new byte[8192];
        for (int i = 0; i < dirList.length; ++i) {
            int bytesIn;
            File f = new File(zipDir, dirList[i]);
            if (f.isDirectory()) {
                String filePath = f.getPath();
                IOUtils._zipDir(filePath, zos);
                continue;
            }
            FileInputStream fis = new FileInputStream(f);
            ZipEntry anEntry = new ZipEntry(f.getPath());
            zos.putNextEntry(anEntry);
            while ((bytesIn = fis.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytesIn);
            }
            fis.close();
        }
    }

    public static void unzipDir(String file2unzip) throws IOException {
        ZipFile zipfile = new ZipFile(file2unzip);
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        while (e.hasMoreElements()) {
            int count;
            ZipEntry entry = e.nextElement();
            System.out.println("Extracting: " + entry);
            BufferedInputStream is = new BufferedInputStream(zipfile.getInputStream(entry));
            byte[] data = new byte[8192];
            FileOutputStream fos = new FileOutputStream(entry.getName());
            BufferedOutputStream dest = new BufferedOutputStream(fos, 8192);
            while ((count = is.read(data, 0, 8192)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzipStream(ZipInputStream stream, File dir) throws IOException {
        ZipEntry eachEntry;
        boolean hasEntries = false;
        while ((eachEntry = stream.getNextEntry()) != null) {
            hasEntries = true;
            String entryName = eachEntry.getName();
            if (File.separatorChar == '/') {
                entryName = entryName.replace('\\', File.separatorChar);
            }
            File eachFile = new File(dir, entryName);
            if (eachEntry.isDirectory()) {
                eachFile.mkdirs();
            } else {
                eachFile.getParentFile().mkdirs();
                FileOutputStream outStream = new FileOutputStream(eachFile);
                try {
                    IOUtils.writeInputToOutput((InputStream)stream, (OutputStream)outStream, 8192);
                }
                finally {
                    outStream.close();
                }
            }
            if (eachEntry.getTime() == -1L) continue;
            eachFile.setLastModified(eachEntry.getTime());
        }
        return hasEntries;
    }

    public static void moveFile(File source, File dest) throws IOException {
        IOUtils.moveFile(source, dest, false);
    }

    public static void moveFile(@NotNull File source, @NotNull File dest, boolean overwriteDest) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/prosc/io/IOUtils.moveFile must not be null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/prosc/io/IOUtils.moveFile must not be null");
        }
        if (dest.exists() && !overwriteDest) {
            throw new IOException("File already exists.  " + dest.getAbsolutePath() + " already exists.");
        }
        if (source.getCanonicalPath().equals(dest.getCanonicalPath())) {
            return;
        }
        if (!source.renameTo(dest)) {
            IOUtils.copyFile(source, dest);
            source.delete();
        }
    }

    public static boolean mkdirs(File dir) throws FileNotFoundException {
        File realParent;
        if (dir.exists()) {
            return false;
        }
        for (realParent = dir; realParent != null && !realParent.exists(); realParent = realParent.getParentFile()) {
        }
        if (realParent != null && "/Volumes".equals(realParent.getPath()) && System.getProperty("os.name").toLowerCase().startsWith("mac")) {
            throw new FileNotFoundException("You cannot create a directory in the /Volumes folder. This is reserved for mounted volumes.");
        }
        if (!dir.mkdirs()) {
            if (realParent != null && !realParent.canWrite()) {
                throw new FileNotFoundException("Directory " + dir.getAbsolutePath() + " could not be created because the parent directory " + realParent.getAbsolutePath() + " is not writeable for user '" + System.getProperty("user.name") + "'");
            }
            throw new FileNotFoundException("Directory " + dir.getAbsolutePath() + " could not be created because of an unknown error.");
        }
        return true;
    }

    public static IOException ioExceptionWithCause(IOException ioException, Throwable e) {
        if (e != null) {
            ioException.initCause(e);
        }
        return ioException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean areInputStreamsEqual(InputStream i1, InputStream i2) throws IOException {
        byte[] buf1 = new byte[8192];
        byte[] buf2 = new byte[8192];
        try {
            int len;
            DataInputStream d2 = new DataInputStream(i2);
            while ((len = i1.read(buf1)) > 0) {
                d2.readFully(buf2, 0, len);
                for (int i = 0; i < len; ++i) {
                    if (buf1[i] == buf2[i]) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = d2.read() < 0;
            return bl;
        }
        catch (EOFException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            i1.close();
            i2.close();
        }
    }
}

