/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.unicode;

import com.prosc.fmkit.unicode.Debug;
import com.prosc.fmkit.unicode.EndOfInputException;
import com.prosc.fmkit.unicode.IllegalInputException;
import com.prosc.fmkit.unicode.SCSU;

public class Expand
extends SCSU {
    protected int iOut = 0;
    protected int iIn = 0;

    protected void defineWindow(int iWindow, byte bOffset) throws IllegalInputException {
        int iOffset;
        int n = iOffset = bOffset < 0 ? bOffset + 256 : bOffset;
        if (iOffset == 0) {
            throw new IllegalInputException();
        }
        if (iOffset < 104) {
            this.dynamicOffset[iWindow] = iOffset << 7;
        } else if (iOffset < 168) {
            this.dynamicOffset[iWindow] = (iOffset << 7) + 44032;
        } else {
            if (iOffset < 249) {
                throw new IllegalInputException("iOffset == " + iOffset);
            }
            this.dynamicOffset[iWindow] = fixedOffset[iOffset - 249];
        }
        this.selectWindow(iWindow);
    }

    protected void defineExtendedWindow(char chOffset) {
        int iWindow = chOffset >>> 13;
        this.dynamicOffset[iWindow] = ((chOffset & 0x1FFF) << 7) + 65536;
        this.selectWindow(iWindow);
    }

    protected int expandUnicode(byte[] in, int iCur, StringBuffer sb) throws IllegalInputException, EndOfInputException {
        while (iCur < in.length - 1) {
            byte b = in[iCur];
            if (b >= -32 && b <= -25) {
                Debug.out("SelectWindow: ", b);
                this.selectWindow(b - -32);
                return iCur;
            }
            if (b >= -24 && b <= -17) {
                this.defineWindow(b - -24, in[iCur + 1]);
                return iCur + 1;
            }
            if (b == -15) {
                if (iCur >= in.length - 2) break;
                this.defineExtendedWindow(Expand.charFromTwoBytes(in[iCur + 1], in[iCur + 2]));
                return iCur + 2;
            }
            if (b == -16) {
                if (iCur >= in.length - 2) break;
                ++iCur;
            }
            char ch = Expand.charFromTwoBytes(in[iCur], in[iCur + 1]);
            sb.append(ch);
            ++this.iOut;
            iCur += 2;
        }
        if (iCur == in.length) {
            return iCur;
        }
        throw new EndOfInputException();
    }

    public static char charFromTwoBytes(byte hi, byte lo) {
        char ch = (char)(lo >= 0 ? lo : 256 + lo);
        return (char)(ch + (char)((hi >= 0 ? hi : 256 + hi) << 8));
    }

    protected String expandSingleByte(byte[] in) throws IllegalInputException, EndOfInputException {
        int iCur;
        StringBuffer sb = new StringBuffer(in.length);
        this.iOut = 0;
        block9: for (iCur = 0; iCur < in.length; ++iCur) {
            int iStaticWindow = 0;
            int iDynamicWindow = this.getCurrentWindow();
            switch (in[iCur]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    Debug.out("SQn:", iStaticWindow);
                    if (iCur >= in.length - 1) {
                        Debug.out("SQn missing argument: ", in, iCur);
                        break block9;
                    }
                    iDynamicWindow = iStaticWindow = in[iCur] - 1;
                    ++iCur;
                }
                default: {
                    int ch;
                    if (in[iCur] >= 0) {
                        ch = in[iCur] + staticOffset[iStaticWindow];
                        sb.append((char)ch);
                        ++this.iOut;
                        continue block9;
                    }
                    ch = in[iCur] + 256;
                    ch -= 128;
                    Debug.out("Dynamic: ", (char)(ch += this.dynamicOffset[iDynamicWindow]));
                    if (ch < 65536) {
                        sb.append((char)ch);
                        ++this.iOut;
                        continue block9;
                    }
                    Debug.out("Extension character: ", ch);
                    sb.append((char)(55296 + ((ch -= 65536) >> 10)));
                    ++this.iOut;
                    sb.append((char)(56320 + (ch & 0xFFFF03FF)));
                    ++this.iOut;
                    continue block9;
                }
                case 11: {
                    if ((iCur += 2) >= in.length) {
                        Debug.out("SDn missing argument: ", in, iCur - 1);
                        break block9;
                    }
                    this.defineExtendedWindow(Expand.charFromTwoBytes(in[iCur - 1], in[iCur]));
                    continue block9;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    if (++iCur >= in.length) {
                        Debug.out("SDn missing argument: ", in, iCur - 1);
                        break block9;
                    }
                    this.defineWindow(in[iCur - 1] - 24, in[iCur]);
                    continue block9;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    this.selectWindow(in[iCur] - 16);
                    continue block9;
                }
                case 15: {
                    iCur = this.expandUnicode(in, iCur + 1, sb);
                    continue block9;
                }
                case 14: {
                    if ((iCur += 2) >= in.length) {
                        Debug.out("SQU missing argument: ", in, iCur - 2);
                        break block9;
                    }
                    int ch = Expand.charFromTwoBytes(in[iCur - 1], in[iCur]);
                    Debug.out("Quoted: ", (char)ch);
                    sb.append((char)ch);
                    ++this.iOut;
                    continue block9;
                }
                case 12: {
                    throw new IllegalInputException();
                }
            }
        }
        if (iCur >= in.length) {
            sb.setLength(this.iOut);
            this.iIn = iCur;
            return sb.toString();
        }
        Debug.out("Length ==" + in.length + " iCur =", iCur);
        throw new EndOfInputException();
    }

    public String expand(byte[] in) throws IllegalInputException, EndOfInputException {
        String str = this.expandSingleByte(in);
        Debug.out("expand output: ", str.toCharArray());
        return str;
    }

    public void reset() {
        this.iOut = 0;
        this.iIn = 0;
        super.reset();
    }

    public int charsWritten() {
        return this.iOut;
    }

    public int bytesRead() {
        return this.iIn;
    }
}

