/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.types;

import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.types.Converter;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public final class InputStreamInfo {
    private InputStream stream;
    private String name;
    private long length;
    private String contentType;
    private File file;

    public InputStreamInfo(File file) throws FileNotFoundException {
        this(file.isDirectory() ? null : new FileInputStream(file), file.getName(), file.length());
        this.file = file;
    }

    public InputStreamInfo(InputStream stream, String name, long length) {
        this(stream, name, length, null);
    }

    public InputStreamInfo(InputStream stream, String name, long length, String optionalContentType) {
        this.stream = stream;
        this.name = name;
        this.length = length;
        this.contentType = optionalContentType;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String input) {
        this.name = input;
    }

    public long getLength() {
        return this.length;
    }

    public String getContentType() {
        return this.contentType;
    }

    public File getFile() {
        return this.file;
    }

    public static void registerConverters() {
        FMType.addConverter(new InputStreamInfoConverter());
    }

    private static final class InputStreamInfoConverter
    implements Converter {
        private InputStreamInfoConverter() {
        }

        public boolean canConvertTo(Class targetClass) {
            return targetClass == InputStreamInfo.class;
        }

        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            InputStreamInfo result = null;
            try {
                result = PluginUtils.getInputStreamInfo(param, context);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return result;
        }
    }
}

