/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.types;

import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.types.Converter;
import com.prosc.fmkit.types.FMCharacterStyle;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMTextReader;
import com.prosc.fmkit.types.FMType;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FMText
extends FMType {
    private static final Logger log = Logger.getLogger(FMText.class.getName());
    public static final int Encoding_Native = 0;
    public static final int Encoding_UTF8 = 1;
    public static final int Encoding_ASCII_DOS = 2;
    public static final int Encoding_ASCII_Windows = 3;
    public static final int Encoding_ASCII_Mac = 4;
    public static final int Encoding_ISO_8859_1 = 5;
    public static final int Encoding_ShiftJIS_Mac = 6;
    public static final int Encoding_ShiftJIS_Win = 7;
    public static final int Encoding_Korean_Mac = 8;
    public static final int Encoding_Korean_Win = 9;
    public static final int Encoding_Korean_Johab = 10;
    public static final int Encoding_ChineseTrad_Mac = 11;
    public static final int Encoding_ChineseTrad_Win = 12;
    public static final int Encoding_ChineseSimp_Mac = 13;
    public static final int Encoding_ChineseSimp_Win = 14;
    public static final int Encoding_Cyrillic_Mac = 15;
    public static final int Encoding_Cyrillic_Win = 16;
    public static final int Encoding_ISO_8859_5 = 17;
    public static final int Encoding_CentralEurope_Mac = 18;
    public static final int Encoding_EasternEurope_Win = 20;
    public static final int Encoding_ISO_8859_2 = 21;
    public static final int Encoding_Turkish_Mac = 22;
    public static final int Encoding_Turkish_Win = 23;
    public static final int Encoding_ISO_8859_3 = 24;
    public static final int Encoding_ISO_8859_9 = 25;
    public static final int Encoding_Baltic_Win = 26;
    public static final int Encoding_ISO_8859_4 = 27;
    public static final int Encoding_Arabic_Mac = 28;
    public static final int Encoding_Arabic_Win = 29;
    public static final int Encoding_ISO_8859_6 = 30;
    public static final int Encoding_Greek_Mac = 31;
    public static final int Encoding_Greek_Win = 32;
    public static final int Encoding_ISO_8859_7 = 33;
    public static final int Encoding_Hebrew_Mac = 34;
    public static final int Encoding_Hebrew_Win = 35;
    public static final int Encoding_ISO_8859_8 = 36;
    public static final int Encoding_ISO_8859_15 = 37;
    public static final int Size_Invalid = 0xFFFFFFF;
    public static final int Size_End = -1;
    private long cToken;
    private FMData fmData;
    private String stringValue;

    public FMText(String value) {
        this(value, false);
    }

    public FMText(String value, boolean convertNewlines) {
        if (convertNewlines) {
            value = PluginUtils.convertLineBreaksToFileMaker(value);
        }
        if (value == null) {
            value = "";
        }
        this.stringValue = value;
        this.cToken = this._createText(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FMText(Reader source) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("You cannot supply a null reader");
        }
        log.fine("Started reading");
        try {
            int charsRead;
            this.cToken = this._createEmptyText();
            char[] buff1 = new char[524288];
            char[] buff2 = new char[524288];
            while ((charsRead = source.read(buff1)) != -1) {
                int destIndex = 0;
                boolean foundCarriageReturn = false;
                for (int n = 0; n < charsRead; ++n) {
                    char c = buff1[n];
                    if (c == '\r') {
                        foundCarriageReturn = true;
                        buff2[destIndex++] = c;
                        continue;
                    }
                    if (c == '\n') {
                        if (!foundCarriageReturn) {
                            buff2[destIndex++] = 13;
                        }
                        foundCarriageReturn = false;
                        continue;
                    }
                    buff2[destIndex++] = c;
                    foundCarriageReturn = false;
                }
                this._appendCharArray(this.cToken, buff2, 0, destIndex);
            }
        }
        finally {
            source.close();
        }
        log.fine("Finished reading");
    }

    public FMText(long cToken, FMData fmData) {
        this.cToken = cToken;
        this.fmData = fmData;
    }

    public String toString() {
        if (this.fmData == null) {
            return super.toString();
        }
        try {
            return this.getAsString();
        }
        catch (ThreadDeath e) {
            log.log(Level.SEVERE, "Received ThreadDeath: " + e.toString(), e);
            throw e;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Could not convert to String", t);
            return super.toString();
        }
    }

    public String getAsString() {
        if (this.fmData == null) {
            this.fmData = new FMData();
            this.writeToData(this.fmData);
        }
        return this.fmData.getStringData();
    }

    public void writeToData(FMData destination) {
        this._writeToData(this.cToken, destination.getCToken());
    }

    protected static void registerConverters() {
        FMType.addConverter(new FMTextConverter());
        FMType.addConverter(new StringConverter());
        FMType.addConverter(new ReaderConverter());
    }

    private native long _createEmptyText();

    private native void _appendCharArray(long var1, char[] var3, int var4, int var5);

    private native long _createText(String var1);

    private native void _writeToData(long var1, long var3);

    public long getTextLength() {
        return this._getTextLength(this.cToken);
    }

    public void readCharArray(long pointer, char[] cbuf, int off, int len) {
        this._getCharArray(this.cToken, pointer, cbuf, off, len);
    }

    private native long _getTextLength(long var1);

    private native void _getCharArray(long var1, long var3, char[] var5, int var6, int var7);

    private native void jni_assign(long var1, String var3, int var4);

    public void assign(String text, int encoding) {
        this.jni_assign(this.cToken, text, encoding);
    }

    private native void jni_assignWide(String var1);

    public void assignWide(String text) {
        this.jni_assignWide(text);
    }

    private native void jni_assignUnicode(String var1);

    public void assignUnicode(String text) {
        this.jni_assignUnicode(text);
    }

    private native void jni_AssignWithLength(String var1, long var2, int var4);

    public void assignWithLength(String text, long strLength, int encoding) {
        this.jni_AssignWithLength(text, strLength, encoding);
    }

    private native void jni_AssignWideWithLength(String var1, long var2);

    public void assignWideWithLength(String text, long strLength) {
        this.jni_AssignWideWithLength(text, strLength);
    }

    private native void jni_assignUnicodeWithLength(String var1, long var2);

    public void assignUnicodeWithLength(String text, long strLength) {
        this.jni_assignUnicodeWithLength(text, strLength);
    }

    private native void jni_setText(String var1);

    public void setText(String text) {
        this.jni_setText(text);
    }

    private native void jni_appendText(long var1, long var3);

    public void appendText(FMText text) {
        this.jni_appendText(this.cToken, text.cToken);
    }

    private native void jni_insertText(String var1, long var2);

    public void insertText(String text, long position) {
        this.jni_insertText(text, position);
    }

    private native void jni_deleteText(long var1);

    public void deleteText(long position) {
        this.jni_deleteText(position);
    }

    private native long jni_find(String var1, long var2);

    public long find(String text, long position) {
        return this.jni_find(text, position);
    }

    private native long jni_findPrev(String var1, long var2);

    public long findPrev(String text, long position) {
        return this.jni_findPrev(text, position);
    }

    private native long jni_findIgnoringCase(String var1, int var2);

    public long findIgnoringCase(String text, int position) {
        return this.jni_findIgnoringCase(text, position);
    }

    private native long jni_findPrevIgnoringCase(String var1, int var2);

    public long findPrevIgnoringCase(String text, int position) {
        return this.jni_findPrevIgnoringCase(text, position);
    }

    private native void jni_uppercase();

    public void uppercase() {
        this.jni_uppercase();
    }

    private native void jni_lowercase();

    public void lowercase() {
        this.jni_lowercase();
    }

    public void setStyle(FMCharacterStyle style, long position, long length) {
        this.jni_setStyle(this.cToken, style.cToken, position, length);
    }

    private native void jni_setStyle(long var1, long var3, long var5, long var7);

    public FMCharacterStyle getStyle(long position) {
        return new FMCharacterStyle(this.jni_getStyle(this.cToken, position));
    }

    private native long jni_getStyle(long var1, long var3);

    public FMData getFmData() {
        return this.fmData;
    }

    public FMCharacterStyle getDefaultStyle() {
        return new FMCharacterStyle(this.jni_getDefaultStyle(this.cToken));
    }

    private native long jni_getDefaultStyle(long var1);

    private static class ReaderConverter
    implements Converter {
        private ReaderConverter() {
        }

        public boolean canConvertTo(Class targetClass) {
            return targetClass == Reader.class || targetClass == FMTextReader.class;
        }

        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            return new FMTextReader(param.getFMText());
        }
    }

    private static class StringConverter
    implements Converter {
        private StringConverter() {
        }

        public boolean canConvertTo(Class targetClass) {
            return String.class == targetClass;
        }

        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            if (param == null || param.isEmpty()) {
                return null;
            }
            FMText fmText = param.getFMText();
            if (fmText != null && fmText.getTextLength() > 100000L) {
                if (fmText.getTextLength() > Integer.MAX_VALUE) {
                    throw new RuntimeException("Text is too large: " + fmText.getTextLength() + " chars");
                }
                try {
                    int charsRead;
                    FMTextReader reader = new FMTextReader(fmText);
                    char[] buffer = new char[65536];
                    StringBuffer toAppendTo = new StringBuffer((int)fmText.getTextLength());
                    while ((charsRead = reader.read(buffer)) != -1) {
                        for (int i = 0; i < charsRead; ++i) {
                            if (buffer[i] != '\r') continue;
                            buffer[i] = 10;
                        }
                        toAppendTo.append(buffer, 0, charsRead);
                    }
                    String stringData = toAppendTo.toString();
                    return stringData.length() == 0 ? null : stringData;
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Could not read FMText into String", e);
                }
            }
            String stringData = param.getStringData();
            return (stringData = stringData.replace('\r', '\n')) == null || stringData.length() == 0 ? null : stringData;
        }
    }

    private static class FMTextConverter
    implements Converter {
        private FMTextConverter() {
        }

        public boolean canConvertTo(Class targetClass) {
            return FMText.class == targetClass;
        }

        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            return param.getFMText();
        }
    }
}

