/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.beanshell;

import com.prosc.beanshell.BeanShellPlugin;
import com.prosc.fm.FMFileUtils;
import com.prosc.fmkit.FmCalculationException;
import com.prosc.fmkit.FmScriptException;
import com.prosc.fmkit.InvalidClipboardException;
import com.prosc.fmkit.PluginBridge;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.ScriptCall;
import com.prosc.fmkit.types.FMBinary;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMType;
import com.prosc.license.client.InvalidLicenseException;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import javax.swing.JOptionPane;

public class FMPro {
    private BeanShellPlugin plugin;

    public FMPro(BeanShellPlugin plugin) {
        this.plugin = plugin;
    }

    public Object getFieldValue(String fileName, String fieldName) throws FmCalculationException {
        return this.plugin.getPluginBridge().getCurrentContext().getFieldValue(fileName, fieldName);
    }

    public String evaluate(String calc) throws FmCalculationException {
        FMData fmData = this.plugin.getPluginBridge().getCurrentContext().evaluateExpression(calc);
        return fmData == null ? null : fmData.getStringData(false);
    }

    public InputStream getContainerStream(String containerFieldName) throws FmCalculationException, IOException {
        FMData fmData = this.plugin.getPluginBridge().getCurrentContext().evaluateExpression(containerFieldName);
        return fmData == null || fmData.getFMBinary() == null ? null : fmData.getFMBinary().getBestInputStream();
    }

    public FMType getFMTypeByName(String fieldName) throws FmCalculationException {
        FMData fmData = this.plugin.getPluginBridge().getCurrentContext().evaluateExpression(fieldName);
        return (FMType)(fmData == null ? null : fmData.getFMType());
    }

    public String getContainerFileName(String containerFieldName) throws FmCalculationException {
        FMData fmData = this.plugin.getPluginBridge().getCurrentContext().evaluateExpression(containerFieldName);
        return fmData == null || fmData.getFMBinary() == null ? null : fmData.getFMBinary().getFileName();
    }

    public void performScript(String filename, String scriptName) throws FmCalculationException, FmScriptException {
        this.performScript(filename, scriptName, null);
    }

    public void performScript(String filename, String scriptName, String parameters) throws FmCalculationException, FmScriptException {
        PluginContext currentContext = this.plugin.getPluginBridge().getCurrentContext();
        currentContext.triggerScript(new ScriptCall(filename, scriptName, parameters));
    }

    public String merge(String template) {
        return PluginUtils.mergeString(this.plugin.getPluginBridge().getCurrentContext(), template, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FMBinary getAsContainer(InputStream bytes, String filename) throws IOException {
        try {
            FMBinary fMBinary = FMBinary.fmBinaryForData(bytes, filename);
            return fMBinary;
        }
        finally {
            bytes.close();
        }
    }

    public String convertPathToFileMaker(String file) {
        return FMFileUtils.convertToFileMaker(file);
    }

    public File fileForFMPath(String file) {
        return PluginUtils.fileForFMPath(file);
    }

    public Frame filemakerWindow() {
        return JOptionPane.getRootFrame();
    }

    public String executeSql(String sql) throws FmCalculationException, InvalidLicenseException {
        return this.executeSql(sql, ',', '\n');
    }

    public String executeSql(String sql, String columnDelimiter, String rowDelimiter) throws FmCalculationException, InvalidLicenseException {
        if (columnDelimiter.length() != 1) {
            throw new IllegalArgumentException("columnDelimiter must be exactly 1 character long");
        }
        if (rowDelimiter.length() != 1) {
            throw new IllegalArgumentException("rowDelimiter must be exactly 1 character long");
        }
        return this.executeSql(sql, columnDelimiter.charAt(0), rowDelimiter.charAt(0));
    }

    public String executeSql(String sql, char columnDelimiter, char rowDelimiter) throws FmCalculationException, InvalidLicenseException {
        this.plugin.excludeFreeLicense();
        PluginContext context = this.plugin.getPluginBridge().getCurrentContext();
        FMData data = context.executeSql(sql, columnDelimiter, rowDelimiter);
        return data.getStringData(false);
    }

    public String[][] executeSqlArray(String sql) throws FmCalculationException, InvalidLicenseException {
        char colDelim = '\ufffb';
        char rowDelim = '\ufffc';
        String rawResult = this.executeSql(sql, colDelim, rowDelim);
        String[] rowSplit = rawResult.split("" + rowDelim);
        int rowCount = rowSplit.length;
        LinkedList<String[]> result = new LinkedList<String[]>();
        for (int i = 0; i < rowCount; ++i) {
            result.add(rowSplit[i].split("" + colDelim));
        }
        return (String[][])result.toArray((T[])new String[result.size()][]);
    }

    public String getFileMakerClipboard() throws InvalidLicenseException {
        this.plugin.excludeFreeLicense();
        String format = this.plugin.getPluginBridge().getBestFileMakerClipboardFormat();
        return this.getClipboardContents(format);
    }

    public void setFileMakerClipboard(String xmlData) throws InvalidLicenseException, InvalidClipboardException {
        this.plugin.excludeFreeLicense();
        PluginBridge.ClipboardType type = this.plugin.getPluginBridge().getClipboardType(xmlData);
        String fmFormat = this.plugin.getPluginBridge().getClipboardFormatString(type);
        this.setClipboardContents(fmFormat, xmlData, true);
    }

    public String getBestFileMakerClipboardFormat() throws InvalidLicenseException {
        this.plugin.excludeFreeLicense();
        return this.plugin.getPluginBridge().getBestFileMakerClipboardFormat();
    }

    public String getClipboardContents(String format) throws InvalidLicenseException {
        this.plugin.excludeFreeLicense();
        try {
            byte[] clipBytes = this.plugin.getPluginBridge().getClipboardData(format, true);
            if (clipBytes == null) {
                return null;
            }
            String characterEncoding = "utf-8";
            if (format.contains("utf16")) {
                characterEncoding = "UnicodeLittleUnmarked";
            }
            return new String(clipBytes, characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setClipboardContents(String format, String data) throws InvalidLicenseException {
        this.setClipboardContents(format, data, true);
    }

    public void setClipboardContents(String format, String data, boolean clearExisting) throws InvalidLicenseException {
        this.plugin.excludeFreeLicense();
        try {
            this.plugin.getPluginBridge().setClipboardData(format, data.getBytes("UTF-8"), true, clearExisting);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getClipboardFormats() throws InvalidLicenseException {
        this.plugin.excludeFreeLicense();
        return this.plugin.getPluginBridge().getClipboardFormats();
    }
}

