/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.beanshell;

import com.prosc.beanshell.FunctionDefinition;
import com.prosc.beanshell.GroovyFunction;
import com.prosc.fmkit.FunctionSignature;
import com.prosc.fmkit.Plugin;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.types.FMData;
import groovy.lang.Script;
import java.lang.reflect.InvocationTargetException;

public class CompiledFunction
implements PluginFunction {
    private FunctionSignature functionSignature;
    private GroovyFunction groovyFunction;
    private FunctionDefinition functionDefinition;
    private ClassLoader classLoader;

    public CompiledFunction(ClassLoader classLoader, FunctionDefinition functionDefinition) {
        this.functionDefinition = functionDefinition;
        this.functionSignature = new FunctionSignature(functionDefinition.getSignature());
        this.classLoader = classLoader;
    }

    public String getName() {
        return this.functionSignature.getName();
    }

    public short getFunctionID() {
        return (short)this.getName().hashCode();
    }

    public String getPrototype() {
        return this.functionSignature.getPrototype();
    }

    public int getMinArgs() {
        return this.functionSignature.getMinArgs();
    }

    public int getMaxArgs() {
        return this.functionSignature.getMaxArgs();
    }

    public int getFlags() {
        return 65281;
    }

    public boolean isGuiFunction() {
        return this.functionDefinition.isGuiFunction();
    }

    public Object[] convertParams(FMData[] rawParams, PluginContext pluginContext) {
        return this.getGroovyFunction().convertParams(rawParams, pluginContext);
    }

    public Object invoke(Plugin pluginInstance, Object[] parameters) throws IllegalAccessException, InvocationTargetException {
        return this.getGroovyFunction().invoke(pluginInstance, parameters);
    }

    public PluginFunction getGroovyFunction() {
        if (this.groovyFunction == null) {
            try {
                String s = this.functionDefinition.getClassName();
                if (s.endsWith(".script")) {
                    s = s.substring(0, s.lastIndexOf(".script"));
                }
                Class<?> clazz = this.classLoader.loadClass(s);
                Script compiledScript = (Script)clazz.newInstance();
                this.groovyFunction = new GroovyFunction(this.functionSignature, compiledScript, this.functionDefinition.isGuiFunction());
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to instantiate compiled ScriptMaster function: " + this.functionSignature.getSignature(), e);
            }
        }
        return this.groovyFunction;
    }
}

