/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.beanshell;

import com.prosc.beanshell.BeanShellModel;
import com.prosc.beanshell.CompiledFunction;
import com.prosc.beanshell.FMPro;
import com.prosc.beanshell.FunctionDefinition;
import com.prosc.beanshell.GroovyFunction;
import com.prosc.fm.FMFileUtils;
import com.prosc.fmkit.CaseInsensitiveMap;
import com.prosc.fmkit.FMFunction;
import com.prosc.fmkit.FeedbackException;
import com.prosc.fmkit.FunctionSignature;
import com.prosc.fmkit.IdleHandler;
import com.prosc.fmkit.PluginBridge;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.QuadChar;
import com.prosc.fmkit.RegisterablePlugin;
import com.prosc.fmkit.StaticFunction;
import com.prosc.fmkit.VersionInfo;
import com.prosc.fmkit.design.DesignInfo;
import com.prosc.fmkit.types.FMBinaryInterface;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMType;
import com.prosc.license.client.ExpiredLicenseException;
import com.prosc.license.client.InvalidLicenseException;
import com.prosc.license.client.License;
import com.prosc.license.client.Registration;
import com.prosc.security.JarUtils;
import com.prosc.shared.StringUtils;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class BeanShellPlugin
extends RegisterablePlugin
implements IdleHandler {
    private static final Logger log = Logger.getLogger(BeanShellPlugin.class.getName());
    private static String pluginName = "360Works ScriptMaster";
    private static String pluginHelpText = "Allows execution of interpreted java/groovy code.";
    private static String pluginVersionString = "4.132";
    private static String pluginPrefix;
    static boolean masqueradeAsRuntime;
    private static QuadChar quadChar;
    private Map<String, String> vars = new LinkedHashMap<String, String>();
    Map<String, String> errorVars = new HashMap<String, String>(0);
    private String lastScript;
    private BeanShellModel beanShellModel;
    private Map<String, URL> loadedJars = new HashMap<String, URL>();
    private Collection<File> tmpJars = new LinkedList<File>();
    private String userId = System.getProperty("user.name", String.valueOf(Math.random()));
    private boolean isScriptMasterRuntime = false;
    private Map<String, FunctionDefinition> registeredFunctions = new LinkedHashMap<String, FunctionDefinition>();
    private Set<String> runtimeFunctionsSet;

    public QuadChar getShortId() {
        return quadChar;
    }

    public String getName() {
        return pluginName;
    }

    public short getProductCode() {
        return this.isScriptMasterRuntime ? (short)48 : 24;
    }

    public String getHelpText() {
        return pluginHelpText;
    }

    @FMFunction(prototype="licenseKey; registeredTo")
    public FMType SMRegister(String licenseKey, String registeredTo) throws InvalidLicenseException {
        return super.defaultRegister(licenseKey, registeredTo);
    }

    protected VersionInfo getVersion() {
        VersionInfo result = this.isScriptMasterRuntime ? new VersionInfo(1, pluginVersionString, "7/15/2010") : new VersionInfo(4, pluginVersionString, "7/15/2010");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        super.init();
        try {
            JarInputStream jarInput = new JarInputStream(new BufferedInputStream(BeanShellModel.getPluginJarStream()));
            if (jarInput.getManifest() == null) {
                throw new IllegalStateException("Could not read manifest from jar at " + PluginBridge.getPluginJar());
            }
            try {
                Attributes attributes = jarInput.getManifest().getMainAttributes();
                if ("true".equals(attributes.getValue("is-scriptmaster-runtime"))) {
                    this.isScriptMasterRuntime = true;
                    pluginName = attributes.getValue("plugin-name");
                    quadChar = new QuadChar(attributes.getValue("plugin-options").substring(0, 4));
                    pluginHelpText = attributes.getValue("plugin-help");
                    pluginVersionString = attributes.getValue("plugin-version");
                    pluginPrefix = attributes.getValue("plugin-prefix");
                    if (pluginPrefix == null) {
                        pluginPrefix = quadChar.toString();
                    }
                    String[] runtimeFunctions = new String[]{"SMVersion", "SMLastError", "SMRegister", "SMGetVariable"};
                    this.runtimeFunctionsSet = new HashSet<String>(Arrays.asList(runtimeFunctions));
                    File modulesJar = PluginBridge.getPluginJar();
                    if (FMFileUtils.isMac) {
                        modulesJar = masqueradeAsRuntime ? new File("/Users/jesse/Desktop/", "scriptmaster_modules.jar") : new File(modulesJar.getParentFile(), "scriptmaster_modules.jar");
                    }
                    this.loadClassesAndRegisterModules(PluginBridge.getPluginJar().getName(), modulesJar.toURI().toURL(), BeanShellModel.pluginJarSkipAmount(), false);
                }
            }
            finally {
                jarInput.close();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problem reading functions from ScriptMaster runtime file", e);
        }
        if (this.isScriptMasterRuntime) {
            this.setRegistration(null);
            try {
                this.getRegistration().checkLicense();
            }
            catch (InvalidLicenseException e) {}
        } else {
            Registration registration1 = this.getRegistration();
            if (registration1 == null || registration1.getLicense() == null || registration1.getLicense().getVariant() == 0 || registration1.getLicense().getVariant() == 7) {
                try {
                    Registration customRegistration = new Registration(this.getVersion().licenseVersion, this.getProductCode(), this.getVersion().majorReleaseDate);
                    customRegistration.setCompanyName("Unregistered");
                    customRegistration.setLicenseKey("B79K1TT0ME47OS8ALGHLEYP");
                    customRegistration.checkLicense();
                    this.setRegistration(customRegistration);
                    log.info("Registered with hard-coded license key");
                }
                catch (InvalidLicenseException e) {
                    log.log(Level.WARNING, "Could not set the license key to the hard-coded value. This should never happen.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClassesAndRegisterModules(String jarName, URL modulesJar, long streamSkipAmount, boolean isExternallyLoaded) throws IOException, FeedbackException, ClassNotFoundException, CertificateException {
        long skip;
        log.log(Level.INFO, "Loaded modules lib at {0}", modulesJar);
        this.loadedJars.put(jarName, modulesJar);
        this.beanShellModel.setAdditionalClasspathUrls(this.loadedJars.values().toArray(new URL[this.loadedJars.size()]));
        InputStream moduleStream = modulesJar.openStream();
        for (skip = streamSkipAmount; skip > 0L; skip -= moduleStream.skip(streamSkipAmount)) {
        }
        JarInputStream jarInput = new JarInputStream(new BufferedInputStream(moduleStream));
        try {
            JarEntry jarEntry;
            while ((jarEntry = jarInput.getNextJarEntry()) != null) {
                log.fine("jarEntry: " + jarEntry.getName() + " / size: " + jarEntry.getSize());
                if ("META-INF/modules.dat".equals(jarEntry.getName())) {
                    String signature;
                    int bytesRead;
                    block20: {
                        if (isExternallyLoaded) {
                            log.fine("Validating jar file certificate");
                            moduleStream = modulesJar.openStream();
                            for (skip = streamSkipAmount; skip > 0L; skip -= moduleStream.skip(streamSkipAmount)) {
                            }
                            JarInputStream verifyStream = new JarInputStream(new BufferedInputStream(moduleStream));
                            try {
                                Collection<X509Certificate> certs;
                                try {
                                    certs = JarUtils.verifyJar(verifyStream, true);
                                }
                                catch (GeneralSecurityException e) {
                                    throw new CertificateException("SMLoadModules can only load modules from jars that have been signed by 360Works. Please contact plugins@360works.com for assistance.");
                                }
                                if (certs.size() != 1) {
                                    throw new IllegalStateException("Expected to find exactly one certificate signer, but found " + certs.size());
                                }
                                X509Certificate signer = certs.iterator().next();
                                String certSubjectName = signer.getSubjectDN().getName();
                                if ("CN=360Works, OU=360Works, O=360Works, L=Roswell, ST=Georgia, C=US".equals(certSubjectName)) {
                                    break block20;
                                }
                                throw new CertificateException("SMLoadModules can only load modules from jars that have been signed by 360Works. Please contact plugins@360works.com for assistance.");
                            }
                            finally {
                                verifyStream.close();
                            }
                        }
                    }
                    log.fine("Found serialized list of functions at " + jarEntry.getName() + "; reading and registering them");
                    int bufferSize = (int)jarEntry.getSize();
                    if (bufferSize == -1) {
                        bufferSize = 1024;
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(bufferSize);
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = jarInput.read(buffer)) != -1) {
                        baos.write(buffer, 0, bytesRead);
                    }
                    ObjectInputStream funcStream = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
                    int functionCount = funcStream.readInt();
                    ArrayList<FunctionDefinition> definitions = new ArrayList<FunctionDefinition>(functionCount);
                    for (int n = 0; n < functionCount; ++n) {
                        String script = (String)funcStream.readObject();
                        signature = (String)funcStream.readObject();
                        boolean isGui = funcStream.readBoolean();
                        short functionId = funcStream.readShort();
                        FunctionDefinition newFunction = new FunctionDefinition(signature, functionId, script, isGui);
                        definitions.add(newFunction);
                    }
                    log.info("definitions: " + definitions);
                    funcStream.close();
                    for (FunctionDefinition eachDef : definitions) {
                        signature = eachDef.getSignature();
                        if (signature == null) {
                            throw new FeedbackException("name must not be null.");
                        }
                        signature = this.validateSignature(signature, this.getContext());
                        log.log(Level.INFO, "Registering module from jar file: '" + signature + "'");
                        CompiledFunction function = new CompiledFunction(this.beanShellModel.getClassLoader(), eachDef);
                        this.getPluginBridge().registerFunction(function);
                        this.registeredFunctions.put(signature, eachDef);
                    }
                    break;
                }
                log.finest("Ignoring jar entry: " + jarEntry.getName());
                jarInput.closeEntry();
            }
        }
        finally {
            jarInput.close();
            moduleStream.close();
        }
    }

    public boolean customizeFunction(StaticFunction eachFunction) {
        String name = eachFunction.getName();
        if (this.isScriptMasterRuntime) {
            if (!this.runtimeFunctionsSet.contains(name)) {
                log.fine("Disabling function because we are in runtime mode: " + eachFunction);
                return false;
            }
            if (name.startsWith("SM")) {
                eachFunction.setName(pluginPrefix + name.substring(2));
                return true;
            }
        } else if ("SMRegister".equals(name)) {
            return false;
        }
        if ("EvaluateGroovy".equals(name)) {
            log.log(Level.INFO, "Function " + eachFunction + " runs in swing");
            eachFunction.setGuiFunction(true);
        } else if ("SMCreatePlugin".equals(name)) {
            eachFunction.setGuiFunction(true);
        }
        return super.customizeFunction(eachFunction);
    }

    public void doIdle(int idleState) {
    }

    public void setPluginBridge(PluginBridge bridge) {
        this.beanShellModel = new BeanShellModel(new FMPro(this));
    }

    public String getSupportUrl() {
        return "http://www.fmforums.com/forum/showforum.php?fid/215/keyword/scriptmaster/";
    }

    public void shutdown() {
        this.deleteTempJars();
    }

    protected boolean isRegistrationRequired(PluginFunction whichFunction) {
        return this.isScriptMasterRuntime && whichFunction instanceof CompiledFunction;
    }

    protected String licenseKeyPrefKey() {
        if (this.isScriptMasterRuntime) {
            return this.getShortId().toString() + "licenseKey";
        }
        return super.licenseKeyPrefKey();
    }

    protected String companyNamePrefKey() {
        if (this.isScriptMasterRuntime) {
            return this.getShortId().toString() + "companyName";
        }
        return super.companyNamePrefKey();
    }

    BeanShellModel getBeanShellModel() {
        return this.beanShellModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FMFunction(prototype="groovyScript")
    public FMType EvaluateGroovy(String groovyScript) throws Throwable {
        try {
            this.errorVars = this.vars;
            this.lastScript = groovyScript;
            if (groovyScript == null) {
                FMType fMType = null;
                return fMType;
            }
            Object result = this.beanShellModel.evaluateGroovy(groovyScript = PluginUtils.convertLineBreaksFromFilemaker(groovyScript), this.vars);
            if (result == null) {
                FMType fMType = null;
                return fMType;
            }
            this.errorVars = new HashMap<String, String>();
            this.lastScript = null;
            FMType fMType = BeanShellPlugin.convertedResult(result);
            return fMType;
        }
        finally {
            this.vars = new LinkedHashMap<String, String>();
        }
    }

    static FMType convertedResult(Object result) {
        if (result instanceof String) {
            String resultWithLineBreaksConverted = PluginUtils.convertLineBreaksToFileMaker((String)result);
            log.log(Level.FINE, "Returning TEXT {0}", resultWithLineBreaksConverted);
            return new FMText(resultWithLineBreaksConverted);
        }
        return FMType.bestTypeForJavaObject(result);
    }

    @FMFunction(prototype="variableName ; value")
    public FMType SMSetVariable(String variableName, String value) {
        if (variableName == null || variableName.length() == 0) {
            throw new NullPointerException("variableName must not be empty.");
        }
        if ("fmpro".equals(variableName)) {
            throw new IllegalArgumentException("'fmpro' is a reserved variable name.");
        }
        value = PluginUtils.convertLineBreaksFromFilemaker(value);
        this.vars.put(variableName, value);
        this.beanShellModel.clearOldVariables();
        return this.successValue();
    }

    @FMFunction(prototype="variableName")
    public FMType SMGetVariable(String variableName) {
        Object value = this.beanShellModel.getScriptMasterVariable(variableName);
        return BeanShellPlugin.convertedResult(value);
    }

    public FMType SMVersion() {
        return new FMText(this.getVersion().stringVersion);
    }

    public FMType SMLastError() {
        if (this.getLastError() == null) {
            return new FMText("");
        }
        String msg = this.getLastErrorString();
        if (this.lastScript != null) {
            msg = msg + "\n\n" + this.errorVarsDump() + "\n\n---Script---\n" + this.lastScriptDump();
        }
        return new FMText(msg);
    }

    protected void setLastError(Throwable t, Object[] parameters) {
        super.setLastError(t, parameters);
        log.severe("ScriptMaster bound variables: " + this.errorVarsDump());
    }

    protected String getLastErrorString() {
        return this.getLastError() == null ? null : this.getLastError().toString();
    }

    private String lastScriptDump() {
        if (this.lastScript == null) {
            return "<no script>";
        }
        int maxChars = 1024;
        if (this.lastScript.length() > maxChars) {
            return "Script:\n" + this.lastScript.substring(0, maxChars) + "...";
        }
        return "Script:\n" + this.lastScript;
    }

    private String errorVarsDump() {
        return "Parameters:\n" + this.errorVars.toString();
    }

    public FMType SMLastStackTrace() {
        if (this.getLastError() == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        this.getLastError().printStackTrace(new PrintWriter(stringWriter));
        String stackTrace = stringWriter.toString();
        stackTrace = PluginUtils.convertLineBreaksToFileMaker(stackTrace);
        return new FMText(stackTrace);
    }

    @FMFunction(prototype="externalJar")
    public FMType SMLoadJar(FMData externalJar) throws FeedbackException, IOException, ClassNotFoundException, CertificateException {
        URL jarUrl;
        String jarName;
        if (externalJar == null) {
            throw new FeedbackException("SMLoadJar was called with an empty data parameter.");
        }
        Object nativeType = externalJar.getFMType();
        if (nativeType instanceof FMBinaryInterface) {
            FMBinaryInterface binary = (FMBinaryInterface)nativeType;
            jarName = binary.getFileName();
            if (jarName == null) {
                throw new RuntimeException(".jar file does not have a name!  This may happen if you use copy & paste to insert a .jar into a container field.");
            }
            if (this.loadedJars.get(jarName) != null) {
                return this.successValue();
            }
            File containerFile = this.fileForContainerData(binary);
            jarUrl = containerFile.toURI().toURL();
        } else if (nativeType instanceof FMText) {
            String s = ((FMText)nativeType).getAsString();
            try {
                jarUrl = new URL(s);
            }
            catch (MalformedURLException e) {
                File file = PluginUtils.fileForFMPath(s);
                if (!file.exists()) {
                    throw new FeedbackException("Could not locate a file at " + s);
                }
                jarUrl = file.toURI().toURL();
            }
            jarName = jarUrl.getFile();
            if (this.loadedJars.get(jarName) != null) {
                return this.successValue();
            }
        } else {
            throw new IllegalArgumentException("Cannot convert a " + nativeType.getClass() + " into a URL");
        }
        this.loadClassesAndRegisterModules(jarName, jarUrl, 0L, true);
        return this.successValue();
    }

    @FMFunction
    public FMType SMReset() {
        this.loadedJars.clear();
        this.deleteTempJars();
        this.beanShellModel.setAdditionalClasspathUrls(this.loadedJars.values().toArray(new URL[this.loadedJars.size()]));
        this.vars.clear();
        for (FunctionDefinition function : this.registeredFunctions.values()) {
            this.getPluginBridge().unregisterFunction(function.getFunctionId());
        }
        this.registeredFunctions.clear();
        return this.successValue();
    }

    private void deleteTempJars() {
        for (File eachJar : this.tmpJars) {
            eachJar.delete();
        }
    }

    @FMFunction(prototype="signature; script{; key1=value1; key2=value2; ...}")
    public FMType RegisterGroovy(String signature, String script, String[] paramStrings) throws Exception {
        CaseInsensitiveMap<String> params;
        if (signature == null) {
            throw new FeedbackException("name must not be null.");
        }
        if (paramStrings == null) {
            paramStrings = new String[]{};
        }
        boolean isGui = !"false".equalsIgnoreCase((params = PluginUtils.convertKeyValuesToCaseInsensitiveMap(paramStrings, true)).get("isGui"));
        signature = this.validateSignature(signature, this.getContext());
        log.log(Level.INFO, "Registering function '" + signature + "'");
        GroovyFunction function = new GroovyFunction(this.beanShellModel.getClassLoader(), new FunctionSignature(signature), script, isGui);
        this.getPluginBridge().registerFunction(function);
        this.registeredFunctions.put(signature, new FunctionDefinition(signature, function.getFunctionID(), script, isGui));
        return this.successValue();
    }

    @FMFunction
    public FMText SMGetRegisteredModules() {
        return new FMText(StringUtils.join(this.registeredFunctions.keySet(), "\r"));
    }

    @FMFunction
    public FMText SMGetLoadedJars() {
        return new FMText(StringUtils.join(this.loadedJars.keySet(), "\r"));
    }

    @FMFunction(prototype="pluginName; quadChar; pluginPrefix; helpText; versionString; folderToWriteTo; isCrossPlatform")
    public FMType SMCreatePlugin(String pluginName, String quadChar, String pluginPrefix, String helpText, String versionString, String folderToWriteTo, boolean crossPlatform) throws IOException, InvalidLicenseException, FeedbackException {
        this.excludeFreeLicense();
        this.expireAfterOneYear();
        if (pluginName == null) {
            throw new FeedbackException("pluginName must not be empty.");
        }
        if (quadChar == null || quadChar.length() != 4) {
            throw new FeedbackException("quadChar must be exactly 4 characters");
        }
        if (helpText == null) {
            helpText = "";
        }
        if (versionString == null) {
            throw new FeedbackException("versionString must not be empty.");
        }
        if (folderToWriteTo == null) {
            throw new FeedbackException("folderToWriteTo must not be empty.");
        }
        File macSourcePluginDir = null;
        File windowsSourcePlugin = null;
        if (FMFileUtils.isMac) {
            macSourcePluginDir = PluginBridge.getPluginFile();
            if (crossPlatform) {
                windowsSourcePlugin = this.chooseFile(JOptionPane.getRootFrame(), null, "Where is the Windows ScriptMaster plugin?");
            }
        } else {
            windowsSourcePlugin = PluginBridge.getPluginFile();
            if (crossPlatform) {
                macSourcePluginDir = this.chooseFile(JOptionPane.getRootFrame(), null, "Where is the Mac ScriptMaster .fmplugin directory?");
            }
        }
        String orderIdString = String.valueOf(this.getRegistration().getLicense().getOrderID());
        String registeredTo = this.getRegistration().getCompanyName();
        String registerFunction = this.beanShellModel.generatePlugin(pluginName, quadChar, pluginPrefix, helpText, versionString, orderIdString, macSourcePluginDir, windowsSourcePlugin, new File(folderToWriteTo), registeredTo, new ArrayList<FunctionDefinition>(this.registeredFunctions.values()));
        return new FMText(registerFunction);
    }

    private String validateSignature(String signature, PluginContext context) throws FeedbackException {
        Map<String, List<String>> functions = new DesignInfo(context).getFunctions();
        String name = signature;
        int index = name.indexOf(40);
        if (index != -1) {
            name = name.substring(0, index);
        }
        name = name.trim();
        for (List<String> eachList : functions.values()) {
            for (String eachBuiltInFunctionName : eachList) {
                if (!eachBuiltInFunctionName.equalsIgnoreCase(name)) continue;
                throw new FeedbackException(eachBuiltInFunctionName + " is a built-in FileMaker function and cannot be registered.");
            }
        }
        signature = signature.replace(',', ';');
        if (!name.matches("^[a-zA-Z]\\w*$")) {
            throw new FeedbackException("Function name contains invalid characters");
        }
        return signature;
    }

    void excludeFreeLicense() throws InvalidLicenseException {
        this.checkLicense();
        if (this.isScriptMasterRuntime) {
            return;
        }
        License license = this.getRegistration().getLicense();
        if (license.getVariant() == 7) {
            throw new InvalidLicenseException("You must purchase an Advanced Edition or Portfolio License to use this feature", license);
        }
    }

    private void expireAfterOneYear() throws ExpiredLicenseException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(this.getRegistration().getLicense().getOrderDate());
        cal.add(1, 1);
        if (cal.getTimeInMillis() < System.currentTimeMillis()) {
            throw new ExpiredLicenseException("This function expired on " + cal.getTime() + ". You must renew your annual license to continue using it.", this.getRegistration().getLicense());
        }
    }

    private File chooseFile(Frame nativeFrame, File initialDir, String title) {
        JFileChooser chooser = initialDir != null ? new JFileChooser(initialDir.getAbsolutePath()) : new JFileChooser();
        chooser.setDialogTitle(title);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(2);
        int choice = chooser.showDialog(nativeFrame, null);
        if (choice == 0 && chooser.getSelectedFile() != null) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public URL urlFromData(FMData data) throws IOException {
        URL result;
        if (data == null) {
            throw new IllegalArgumentException("You must supply a non-null parameter");
        }
        Object nativeType = data.getFMType();
        if (nativeType instanceof FMBinaryInterface) {
            File containerFile = this.fileForContainerData((FMBinaryInterface)nativeType);
            return containerFile.toURI().toURL();
        }
        if (nativeType instanceof FMText) {
            String s = ((FMText)nativeType).getAsString();
            try {
                result = new URL(s);
            }
            catch (MalformedURLException e) {
                File file = PluginUtils.fileForFMPath(s);
                result = file.toURI().toURL();
            }
        } else {
            throw new IllegalArgumentException("Cannot convert a " + nativeType.getClass() + " into a URL");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File fileForContainerData(FMBinaryInterface fmBinary) throws IOException {
        InputStream is = null;
        FileOutputStream out = null;
        String name = fmBinary.getFileName();
        if (!name.toLowerCase().endsWith(".jar") && !name.toLowerCase().endsWith(".zip")) {
            throw new IllegalArgumentException("External libs must have a .jar or .zip suffix");
        }
        try {
            File jarDir = new File(System.getProperty("java.io.tmpdir"), "ScriptMaster_" + this.userId);
            if (!jarDir.exists()) {
                jarDir.mkdirs();
            }
            File tmp = File.createTempFile("ScriptMaster", name, jarDir);
            tmp.deleteOnExit();
            is = fmBinary.getStreamForType(QuadChar.FileData);
            out = new FileOutputStream(tmp);
            BeanShellPlugin.writeInputToOutput(is, out, 1024);
            this.tmpJars.add(tmp);
            File file = tmp;
            return file;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private static long writeInputToOutput(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int lastBytesRead;
        byte[] buffer = new byte[bufferSize];
        long totalBytesRead = 0L;
        while ((lastBytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, lastBytesRead);
            totalBytesRead += (long)lastBytesRead;
        }
        if (out != null) {
            out.flush();
        }
        return totalBytesRead;
    }

    static {
        masqueradeAsRuntime = false;
        quadChar = new QuadChar(masqueradeAsRuntime ? "test" : "3BSH");
    }
}

