/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.beanshell;

import com.prosc.beanshell.BeanShellPlugin;
import com.prosc.beanshell.EvaluateException;
import com.prosc.beanshell.FMPro;
import com.prosc.beanshell.FunctionDefinition;
import com.prosc.beanshell.compilation.CompiledClass;
import com.prosc.beanshell.compilation.FunctionCompiler;
import com.prosc.fmkit.FeedbackException;
import com.prosc.fmkit.PluginBridge;
import com.prosc.io.IOUtils;
import com.prosc.security.JarUtils;
import com.prosc.shared.DebugTimer;
import com.prosc.shared.StringParser;
import com.prosc.shared.StringUtils;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import org.codehaus.groovy.control.CompilationFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanShellModel {
    private static final Logger log = Logger.getLogger(BeanShellModel.class.getName());
    public static final String GROOVY = "groovy";
    public static final String JAVASCRIPT = "javascript";
    private Binding binding;
    private ClassLoader customClassLoader;
    private URL[] urls;
    private Map threadMap = Collections.synchronizedMap(new HashMap());
    private FMPro fmpro;

    public BeanShellModel(FMPro fmpro) {
        this.fmpro = fmpro;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String evaluateRuntimeCommand(String command, boolean runInBackground) throws IOException, InterruptedException, EvaluateException {
        log.log(Level.INFO, command);
        BufferedReader input = null;
        BufferedReader error = null;
        try {
            Process process = Runtime.getRuntime().exec(command);
            if (runInBackground) {
                String string = null;
                return string;
            }
            input = new BufferedReader(new InputStreamReader(process.getInputStream()));
            error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new EvaluateException(this._readerContents(error), exitCode);
            }
            String string = this._readerContents(input);
            return string;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (error != null) {
                    error.close();
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed closing output stream", e);
            }
        }
    }

    private String _readerContents(BufferedReader reader) throws IOException {
        String eachLine;
        StringBuffer result = new StringBuffer();
        while ((eachLine = reader.readLine()) != null) {
            result.append(eachLine).append("\r");
        }
        return result.toString();
    }

    public Object evaluateGroovy(String script, Map vars) throws CompilationFailedException {
        this.binding = new Binding(new HashMap(vars));
        this.binding.setVariable("fmpro", this.fmpro);
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        GroovyShell shell = new GroovyShell(this.getClassLoader(), this.binding);
        return shell.evaluate(script);
    }

    ClassLoader getClassLoader() {
        if (this.urls == null) {
            return this.getClass().getClassLoader();
        }
        if (this.customClassLoader == null) {
            this.customClassLoader = new URLClassLoader(this.urls, this.getClass().getClassLoader());
        }
        return this.customClassLoader;
    }

    public void setAdditionalClasspathUrls(URL[] urls) {
        this.urls = urls;
        this.customClassLoader = null;
    }

    public Object getScriptMasterVariable(String variableName) {
        if (variableName == null) {
            return null;
        }
        if (this.binding == null) {
            throw new IllegalStateException("You can only get ScriptMaster variables after evaluating a script, and before setting any new variables.");
        }
        return this.binding.getVariable(variableName);
    }

    public void clearOldVariables() {
        this.binding = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        BeanShellModel shellModel = new BeanShellModel(null);
        LinkedList<FunctionDefinition> functions = new LinkedList<FunctionDefinition>();
        functions.add(new FunctionDefinition("helloWorld", 1, "println('Hello world')", true));
        JarOutputStream jarStream = new JarOutputStream(new FileOutputStream("/tmp/new.jar"));
        try {
            shellModel.generateModulesJar(functions, jarStream);
        }
        finally {
            jarStream.close();
        }
        URL[] testUrls = new URL[]{new URL("file:/tmp/new.jar")};
        URLClassLoader pluginClassLoader = new URLClassLoader(new URL[]{new URL("file:/Applications/FileMaker%20Pro%2011%20Advanced/Extensions/MyPluginName.fmplugin/Contents/Resources/Java/plugin.jar")});
        URLClassLoader classLoader = new URLClassLoader(testUrls, (ClassLoader)pluginClassLoader);
        Class<?> aClass = classLoader.loadClass("scriptmaster.Module_LTE1NTQxMzU1ODQX");
        Script s = (Script)aClass.newInstance();
        s.run();
    }

    public boolean isRunning(Object id) {
        if (id != null) {
            Thread t = (Thread)this.threadMap.get(id);
            return t != null && t.isAlive();
        }
        return !this.threadMap.isEmpty();
    }

    public void cancel(Object id) {
        if (id != null) {
            Thread t = (Thread)this.threadMap.get(id);
            if (t != null) {
                t.interrupt();
            }
        } else {
            Thread[] allThreads = this.threadMap.values().toArray(new Thread[0]);
            this.threadMap.clear();
            for (int i = 0; i < allThreads.length; ++i) {
                Thread eachThread = allThreads[i];
                try {
                    eachThread.interrupt();
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Failed interrupting thread " + eachThread, e);
                }
            }
        }
    }

    public FMPro getFmpro() {
        return this.fmpro;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String generatePlugin(String pluginName, String quadChar, String pluginPrefix, String helpText, String versionString, String licenseKey, File macSourcePluginDir, File windowsSourcePluginFile, File folderToWriteTo, String registeredTo, Collection<FunctionDefinition> functionsToInclude) throws IOException, FeedbackException {
        if (pluginName.indexOf(46) != -1) {
            throw new IllegalArgumentException("pluginName cannot contain dot characters");
        }
        if (quadChar.length() != 4) {
            throw new IllegalArgumentException("quadChar must consist of exactly 4 alphanumeric characters");
        }
        if (helpText == null) {
            helpText = "";
        }
        helpText = helpText.replaceAll("[\\x0A\\x0D]", " ");
        try {
            new BigDecimal(versionString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("versionString must be a strictly numeric value");
        }
        if (!folderToWriteTo.exists()) {
            throw new IllegalArgumentException("No folder exists at " + folderToWriteTo.getAbsolutePath());
        }
        String generatedLicenseKey = this.callWebService(pluginName, helpText, versionString, quadChar, licenseKey, functionsToInclude);
        DebugTimer dt = new DebugTimer("Customizing plugin from jar file");
        folderToWriteTo = new File(folderToWriteTo, pluginName);
        if (macSourcePluginDir != null) {
            dt.markTime("Generating mac plugin");
            File macDir = new File(folderToWriteTo, "MAC");
            File macDestPluginDir = new File(macDir, pluginName + ".fmplugin");
            if (macDestPluginDir.exists()) {
                IOUtils.deleteRecursive(macDestPluginDir);
            }
            if (!macDestPluginDir.exists() && !macDestPluginDir.mkdirs()) {
                throw new IOException("Could not create Mac plugin directory: " + macDestPluginDir);
            }
            BeanShellModel.copyRecursive(macSourcePluginDir, macDestPluginDir);
            File newJarFile = new File(macDestPluginDir, "Contents/Resources/Java/plugin.jar");
            JarOutputStream jarOutput = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(newJarFile)));
            JarInputStream jarInput = new JarInputStream(new BufferedInputStream(BeanShellModel.getPluginJarStream()));
            try {
                this.writeModifiedJar(pluginName, quadChar, pluginPrefix, helpText, versionString, jarInput, jarOutput);
            }
            finally {
                jarInput.close();
                jarOutput.close();
            }
            File scriptMasterModulesFile = new File(newJarFile.getParentFile(), "scriptmaster_modules.jar");
            JarOutputStream modulesOut = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(scriptMasterModulesFile)));
            try {
                this.generateModulesJar(functionsToInclude, modulesOut);
            }
            finally {
                modulesOut.close();
            }
        }
        if (windowsSourcePluginFile != null) {
            dt.markTime("Generating windows plugin");
            File winDir = new File(folderToWriteTo, "WIN");
            File winDestPlugin = new File(winDir, pluginName + ".fmx");
            if (!winDir.exists() && !winDir.mkdirs()) {
                throw new IOException("Could not create Windows plugin directory: " + winDir);
            }
            FileOutputStream winDestStream = new FileOutputStream(winDestPlugin);
            try {
                int jarSize = JarUtils.getJarSize(windowsSourcePluginFile);
                int fmxSize = (int)(windowsSourcePluginFile.length() - (long)jarSize);
                FileInputStream winSourceStream = new FileInputStream(windowsSourcePluginFile);
                try {
                    this.writeBytes(winSourceStream, winDestStream, fmxSize);
                }
                finally {
                    winSourceStream.close();
                }
                JarOutputStream jarOutput = new JarOutputStream(new BufferedOutputStream(winDestStream));
                try {
                    JarInputStream jarInput = new JarInputStream(new BufferedInputStream(BeanShellModel.getPluginJarStream()));
                    try {
                        this.writeModifiedJar(pluginName, quadChar, pluginPrefix, helpText, versionString, jarInput, jarOutput);
                    }
                    finally {
                        jarInput.close();
                        dt.stop();
                    }
                    this.generateModulesJar(functionsToInclude, jarOutput);
                }
                finally {
                    jarOutput.close();
                }
            }
            finally {
                winDestStream.close();
            }
        }
        dt.stop();
        String registerFunction = pluginPrefix + "Register( \"" + generatedLicenseKey + "\"; \"" + registeredTo + "\" )";
        File registrationInfo = new File(folderToWriteTo, "Registration.txt");
        FileWriter writer = new FileWriter(registrationInfo, false);
        try {
            writer.write("To register your generated plugin in FileMaker, add this script step to your startup script:\n\nSet Variable[$register; " + registerFunction + "]");
        }
        finally {
            writer.close();
        }
        return registerFunction;
    }

    static InputStream getPluginJarStream() throws IOException {
        File file = BeanShellPlugin.masqueradeAsRuntime ? new File("/Users/jesse/Desktop/plugin.jar") : PluginBridge.getPluginJar();
        FileInputStream result = new FileInputStream(file);
        for (long skipAmount = BeanShellModel.pluginJarSkipAmount(); skipAmount > 0L; skipAmount -= ((InputStream)result).skip(skipAmount)) {
        }
        return result;
    }

    static long pluginJarSkipAmount() throws IOException {
        File file = PluginBridge.getPluginJar();
        long skipAmount = 0L;
        if (!file.getName().endsWith(".jar")) {
            int jarSize = JarUtils.getJarSize(file);
            skipAmount = file.length() - (long)jarSize;
        }
        return skipAmount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String callWebService(String pluginName, String helpText, String version, String quadChar, String licenseKey, Collection<FunctionDefinition> functionsList) throws IOException, FeedbackException {
        String string;
        StringBuffer functionString = new StringBuffer();
        for (FunctionDefinition definition : functionsList) {
            if (functionString.length() > 0) {
                functionString.append("\n");
            }
            functionString.append(definition.getSignature());
        }
        StringBuffer soapCall = new StringBuffer();
        soapCall.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?> <Envelope xmlns=\"http://schemas.xmlsoap.org/soap/envelope/\"> <Header> <ns2:AuthenticatedUser xmlns=\"http://360works.com/x_360Store\" xmlns:ns2=\"http://360works.com\"> <ns2:username>smcreate</ns2:username> <ns2:password>9createsm9</ns2:password> </ns2:AuthenticatedUser> </Header> <Body> <CreateScriptMasterPlugin xmlns=\"http://360works.com/x_360Store\" xmlns:ns2=\"http://360works.com\"> <PluginName>");
        StringUtils.escapeXMLString(pluginName, soapCall);
        soapCall.append("</PluginName><HelpText>");
        StringUtils.escapeXMLString(helpText, soapCall);
        soapCall.append("</HelpText><Version>");
        StringUtils.escapeXMLString(version, soapCall);
        soapCall.append("</Version><QuadChar>");
        StringUtils.escapeXMLString(quadChar, soapCall);
        soapCall.append("</QuadChar><InputLicenseKey>");
        StringUtils.escapeXMLString(licenseKey, soapCall);
        soapCall.append("</InputLicenseKey><FunctionsList>");
        StringUtils.escapeXMLString(functionString.toString(), soapCall);
        soapCall.append("</FunctionsList></CreateScriptMasterPlugin></Body></Envelope>");
        URL url = new URL("http://fmswpe.360works.com/websvcmgr.php");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("content-type", "text/xml");
        conn.setDoOutput(true);
        try {
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream(), "utf-8");
            wr.write(soapCall.toString());
            wr.close();
        }
        catch (IOException e) {
            throw new FeedbackException("You do not have a network connection. You must be online in order to generate plugins.");
        }
        InputStream responseStream = conn.getInputStream();
        try {
            String response = IOUtils.inputStreamAsString(responseStream);
            string = new StringParser(response).getStringBetween("<ResultLicenseKey>", "</ResultLicenseKey>", false);
        }
        catch (Throwable throwable) {
            try {
                responseStream.close();
                throw throwable;
            }
            catch (IOException e) {
                IOException ioException = e;
                if (conn.getResponseCode() == 500) {
                    InputStream errStream = conn.getErrorStream();
                    try {
                        String error = IOUtils.inputStreamAsString(errStream);
                        if (error.contains("<faultstring>")) {
                            error = new StringParser(error).getStringBetween("<faultstring>", "</faultstring>", false);
                        }
                        FeedbackException exception = new FeedbackException("Server error: " + error);
                        if (ioException != null) {
                            exception.initCause(ioException);
                        }
                        throw exception;
                    }
                    catch (Throwable throwable2) {
                        errStream.close();
                        throw throwable2;
                    }
                }
                throw e;
            }
        }
        responseStream.close();
        return string;
    }

    private void writeBytes(InputStream in, OutputStream out, long size) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        for (long bytesWritten = 0L; bytesWritten < size; bytesWritten += (long)bytesRead) {
            bytesRead = in.read(buffer);
            out.write(buffer, 0, bytesRead);
        }
    }

    private void writeModifiedJar(String pluginName, String quadChar, String pluginPrefix, String helpText, String versionString, JarInputStream jarInput, JarOutputStream jarOutput) throws IOException {
        Manifest manifest = jarInput.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("plugin-name", pluginName);
        String value = attributes.getValue("plugin-options");
        value = quadChar + value.substring(4);
        attributes.putValue("plugin-options", value);
        attributes.putValue("is-scriptmaster-runtime", "true");
        attributes.putValue("plugin-help", helpText);
        attributes.putValue("plugin-version", versionString);
        attributes.putValue("plugin-prefix", pluginPrefix);
        jarOutput.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
        manifest.write(jarOutput);
        jarOutput.closeEntry();
        this.copyJarInputToOutput(jarInput, jarOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateModulesJar(Collection<FunctionDefinition> functionsToInclude, JarOutputStream modulesOut) throws IOException {
        block6: {
            JarEntry modules = new JarEntry("META-INF/modules.dat");
            modulesOut.putNextEntry(modules);
            ObjectOutputStream objectOut = new ObjectOutputStream(new BufferedOutputStream(modulesOut));
            objectOut.writeInt(functionsToInclude.size());
            log.info("Wrote functions size: " + functionsToInclude.size());
            for (FunctionDefinition definition : functionsToInclude) {
                objectOut.writeObject(definition.getScript());
                objectOut.writeObject(definition.getSignature());
                objectOut.writeBoolean(definition.isGuiFunction());
                objectOut.writeShort(definition.getFunctionId());
            }
            objectOut.flush();
            modulesOut.closeEntry();
            FunctionCompiler compiler = new FunctionCompiler();
            for (FunctionDefinition eachDef : functionsToInclude) {
                String script = eachDef.getScript();
                ClassLoader cl = this.getClassLoader();
                List<CompiledClass> compiledClasses = compiler.compile(eachDef.getClassName(), script, cl);
                for (CompiledClass eachCompiledClass : compiledClasses) {
                    log.log(Level.INFO, "Adding " + eachDef.getSignature() + " / " + eachCompiledClass.getName());
                    JarEntry eachEntry = new JarEntry(eachCompiledClass.getName().replace('.', '/') + ".class");
                    modulesOut.putNextEntry(eachEntry);
                    modulesOut.write(eachCompiledClass.getBytes());
                    modulesOut.closeEntry();
                }
            }
            if (this.urls == null) break block6;
            for (URL eachModuleJar : this.urls) {
                JarInputStream stream = null;
                try {
                    stream = new JarInputStream(eachModuleJar.openStream());
                    this.copyJarInputToOutput(stream, modulesOut);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
                IOUtils.closeQuietly(stream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyJarInputToOutput(JarInputStream jarInput, JarOutputStream jarOutput) throws IOException {
        JarEntry inputEntry;
        while ((inputEntry = jarInput.getNextJarEntry()) != null) {
            String path = inputEntry.getName();
            try {
                if (path.startsWith("META-INF/") && path.indexOf(47) == path.lastIndexOf(47) && (path.endsWith(".RSA") || path.endsWith(".DSA") || path.endsWith(".SF"))) continue;
                JarEntry newEntry = new JarEntry(inputEntry);
                newEntry.setCompressedSize(-1L);
                jarOutput.putNextEntry(newEntry);
                try {
                    IOUtils.writeInputToOutput((InputStream)jarInput, (OutputStream)jarOutput, 8192);
                }
                finally {
                    jarOutput.closeEntry();
                }
            }
            catch (ZipException e) {
                if (e.getMessage().startsWith("duplicate entry")) {
                    log.fine("Duplicate entry, ignored: " + e.getMessage());
                    continue;
                }
                log.log(Level.WARNING, "Exception while adding " + inputEntry, e);
            }
            finally {
                jarInput.closeEntry();
            }
        }
    }

    public static void copyRecursive(File srcFile, File dstDir) throws IOException {
        if (srcFile.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcFile.list();
            for (int i = 0; i < children.length; ++i) {
                BeanShellModel.copyRecursive(new File(srcFile, children[i]), new File(dstDir, children[i]));
            }
        } else if (!"plugin.jar".equals(srcFile.getName())) {
            IOUtils.copyFile(srcFile, dstDir);
        }
    }
}

