/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class VirtualSpace {
    Rectangle2D.Float window;
    Rectangle2D.Float user;
    boolean invert = true;

    public VirtualSpace(Rectangle2D.Float window, Rectangle2D.Float user) {
        this.user = user;
        this.window = window;
    }

    Point2D.Float getPoint(Point2D.Float userPt) {
        return this.getPoint(userPt.x, userPt.y);
    }

    Point2D.Float getPoint(float x, float y) {
        return new Point2D.Float(this.getX(x), this.getY(y));
    }

    Line2D.Float getLine(Line2D.Float line) {
        return new Line2D.Float(this.getX(line.x1), this.getY(line.y1), this.getX(line.x2), this.getY(line.y2));
    }

    Rectangle2D.Float getRect(Rectangle2D.Float r) {
        Point2D.Float pt1 = this.getPoint(new Point2D.Float(r.x, r.y));
        Point2D.Float pt2 = this.getPoint(new Point2D.Float(r.x + r.width, r.y + r.height));
        return new Rectangle2D.Float(pt1.x, pt1.y, pt2.x - pt1.x, pt2.y - pt1.y);
    }

    float getX(float x) {
        return (x - this.user.x) * this.window.width / this.user.width + this.window.x;
    }

    float getY(float y) {
        return (1.0f - (y - this.user.y) / this.user.height) * this.window.height + this.window.y;
    }
}

