/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import pGraph.Chart;

class StackLine
extends Chart {
    float crossWidth = 2.5f;

    StackLine(double[][] amounts, String[] xLabels, Paint[] paints, boolean inset) {
        super(amounts, xLabels, paints, inset);
        for (int x = 0; x < this.totals.length; ++x) {
            this.max = Math.max(this.totals[x], this.max);
        }
        this.min = 0.0;
        this.range = this.max;
        this.valuesLength = 1;
    }

    public void paint(Graphics2D g, Rectangle2D.Float bounds) {
        double[] subTotals = new double[this.totals.length];
        float columnWidth = bounds.width / ((float)this.groupLength * ((float)this.values.length + 2.0f));
        float start = (float)(this.values.length + 2) / 2.0f * columnWidth + bounds.x;
        float step = columnWidth * (float)(this.values.length + 2);
        for (int i = 0; i < this.values.length && this.values[i].length > 0; ++i) {
            g.setPaint(this.paints[i]);
            GeneralPath p = new GeneralPath();
            Point2D.Float p1 = new Point2D.Float(start, bounds.y + bounds.height);
            p.moveTo(p1.x, p1.y);
            for (int j = 0; j < this.values[i].length; ++j) {
                Point2D.Float pt = new Point2D.Float(start + step * (float)j, bounds.y + (float)((this.max - this.totals[j] + subTotals[j]) * (double)bounds.height / this.range));
                if (this.inset) {
                    if (i == 0) {
                        GeneralPath sf = new GeneralPath();
                        sf.moveTo(p1.x, p1.y);
                        sf.lineTo(p1.x + columnWidth / 2.0f, p1.y - columnWidth / 2.0f);
                        sf.lineTo(pt.x + columnWidth / 2.0f, pt.y - columnWidth / 2.0f);
                        sf.lineTo(pt.x, pt.y);
                        g.fill(sf);
                        int shade = (int)(128.0 * Math.sin(Math.atan((p1.y - pt.y) / (p1.x - pt.x))));
                        g.setPaint(shade < 0 ? new Color(255, 255, 255, shade + 128) : new Color(0, 0, 0, shade));
                        g.fill(sf);
                        g.setPaint(this.paints[i]);
                    }
                    if (j == this.values[i].length - 1) {
                        GeneralPath q = new GeneralPath();
                        q.moveTo(pt.x, pt.y);
                        q.lineTo(pt.x + columnWidth / 2.0f, pt.y - columnWidth / 2.0f);
                        q.lineTo(pt.x + columnWidth / 2.0f, pt.y - columnWidth / 2.0f + (float)(Math.abs(this.values[i][j]) * (double)bounds.height / this.range));
                        q.lineTo(pt.x, pt.y + (float)(Math.abs(this.values[i][j]) * (double)bounds.height / this.range));
                        g.fill(q);
                        g.setPaint(new Color(0, 0, 0, 128));
                        g.fill(q);
                        g.setPaint(this.paints[i]);
                    }
                }
                p.lineTo(pt.x, pt.y);
                g.fill(new Ellipse2D.Float(pt.x - this.crossWidth, pt.y - this.crossWidth, this.crossWidth * 2.0f, this.crossWidth * 2.0f));
                int n = j;
                subTotals[n] = subTotals[n] + this.values[i][j];
                p1 = pt;
            }
            p.lineTo(start + step * (float)(this.totals.length - 1), bounds.y + bounds.height);
            g.fill(p);
        }
    }
}

