/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import pGraph.Chart;

class StackBar
extends Chart {
    StackBar(double[][] amounts, String[] xLabels, Paint[] paints, boolean inset) {
        super(amounts, xLabels, paints, inset);
        for (int x = 0; x < this.totals.length; ++x) {
            this.max = Math.max(this.totals[x], this.max);
        }
        this.min = 0.0;
        this.range = this.max;
        this.valuesLength = 1;
    }

    public void paint(Graphics2D g, Rectangle2D.Float bounds) {
        double[] subTotals = new double[this.totals.length];
        float columnWidth = bounds.width / ((float)this.groupLength * ((float)this.valuesLength + 2.0f));
        for (int i = 0; i < this.values.length; ++i) {
            g.setPaint(this.paints[i]);
            for (int j = 0; j < this.values[i].length; ++j) {
                Point2D.Float pt = new Point2D.Float(bounds.x + ((float)j * ((float)this.valuesLength + 2.0f) + 1.0f) * columnWidth, bounds.y + (float)((this.max - this.totals[j] + subTotals[j]) * (double)bounds.height / this.range));
                g.fill(new Rectangle2D.Float(pt.x, pt.y, columnWidth, (float)(this.values[i][j] * (double)bounds.height / this.range)));
                if (this.inset) {
                    GeneralPath p = new GeneralPath();
                    if (i == 0) {
                        p.moveTo(pt.x, pt.y);
                        p.lineTo(pt.x + columnWidth / 2.0f, pt.y - columnWidth / 2.0f);
                        p.lineTo(pt.x + 3.0f * columnWidth / 2.0f, pt.y - columnWidth / 2.0f);
                        p.lineTo(pt.x + columnWidth, pt.y);
                        g.fill(p);
                    }
                    GeneralPath q = new GeneralPath();
                    q.moveTo(pt.x + columnWidth, pt.y);
                    q.lineTo(pt.x + 3.0f * columnWidth / 2.0f, pt.y - columnWidth / 2.0f);
                    q.lineTo(pt.x + 3.0f * columnWidth / 2.0f, pt.y - columnWidth / 2.0f + (float)(Math.abs(this.values[i][j]) * (double)bounds.height / this.range));
                    q.lineTo(pt.x + columnWidth, pt.y + (float)(Math.abs(this.values[i][j]) * (double)bounds.height / this.range));
                    g.fill(q);
                    if (i == 0) {
                        g.setPaint(new Color(255, 255, 255, 128));
                        g.fill(p);
                    }
                    g.setPaint(new Color(0, 0, 0, 128));
                    g.fill(q);
                    g.setPaint(this.paints[i]);
                }
                int n = j;
                subTotals[n] = subTotals[n] + this.values[i][j];
            }
        }
    }
}

