/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import pGraph.Chart;
import pGraph.VirtualSpace;

class Scatter
extends Chart {
    double[][] xAmounts;
    double[][] yAmounts;
    Rectangle2D.Float valueBounds;
    Line2D.Float[] trends;
    Point2D.Float[][] valuePoints;
    boolean join;

    Scatter(double[][] amounts, String[] xLabels, Paint[] paints, boolean inset, boolean trend, boolean join) {
        int x;
        this.join = join;
        float minX = 0.0f;
        float minY = 0.0f;
        float maxX = 0.0f;
        float maxY = 0.0f;
        this.valuePoints = new Point2D.Float[amounts.length][];
        for (x = 0; x < amounts.length; ++x) {
            this.valuePoints[x] = new Point2D.Float[amounts[x].length / 2];
            for (int y = 0; y < amounts[x].length; y += 2) {
                Point2D.Float pt = new Point2D.Float((float)amounts[x][y], (float)amounts[x][y + 1]);
                minX = Math.min(minX, pt.x);
                maxX = Math.max(maxX, pt.x);
                minY = Math.min(minY, pt.y);
                maxY = Math.max(maxY, pt.y);
                this.valuePoints[x][y / 2] = pt;
            }
        }
        this.init(amounts, xLabels, paints, inset);
        this.valueBounds = new Rectangle2D.Float(minX, minY, maxX - minX, maxY - minY);
        if (trend) {
            this.trends = new Line2D.Float[amounts.length];
            for (x = 0; x < amounts.length; ++x) {
                this.trends[x] = this.getTrend(this.valuePoints[x], this.valueBounds);
            }
        }
    }

    public Line2D.Float getTrend(Point2D.Float[] points, Rectangle2D.Float bounds) {
        float sumID = 0.0f;
        float sumI = 0.0f;
        float sumD = 0.0f;
        float sumI2 = 0.0f;
        for (int i = 0; i < points.length; ++i) {
            Point2D.Float pt = points[i];
            sumID += pt.y * pt.x;
            sumI += pt.x;
            sumD += pt.y;
            sumI2 += pt.x * pt.x;
        }
        float m = ((float)points.length * sumID - sumI * sumD) / ((float)points.length * sumI2 - sumI * sumI);
        float c = (sumD * sumI2 - sumI * sumID) / ((float)points.length * sumI2 - sumI * sumI);
        Point2D.Float pt1 = new Point2D.Float(bounds.x, m * bounds.x + c);
        Point2D.Float pt2 = new Point2D.Float(bounds.x + bounds.width, m * (bounds.x + bounds.width) + c);
        if (pt1.y < bounds.y) {
            pt1 = new Point2D.Float((bounds.y - c) / m, bounds.y);
        }
        if (pt1.y > bounds.y + bounds.height) {
            pt1 = new Point2D.Float((bounds.y + bounds.height - c) / m, bounds.y + bounds.height);
        }
        if (pt2.y < bounds.y) {
            pt2 = new Point2D.Float((bounds.y - c) / m, bounds.y);
        }
        if (pt2.y > bounds.y + bounds.height) {
            pt2 = new Point2D.Float((bounds.y + bounds.height - c) / m, bounds.y + bounds.height);
        }
        return new Line2D.Float(pt1, pt2);
    }

    public void paint(Graphics2D g, VirtualSpace vs) {
        Point2D.Float pPt = null;
        for (int x = 0; x < this.valuePoints.length; ++x) {
            g.setPaint(this.paints[x]);
            for (int y = 0; y < this.valuePoints[x].length; ++y) {
                Point2D.Float pt = vs.getPoint(this.valuePoints[x][y]);
                g.fill(new Ellipse2D.Float(pt.x - 2.5f, pt.y - 2.5f, 5.0f, 5.0f));
                if (!this.join) continue;
                if (y > 0) {
                    g.draw(new Line2D.Float(pt, pPt));
                }
                pPt = pt;
            }
            if (this.trends == null) continue;
            g.draw(vs.getLine(this.trends[x]));
        }
    }

    public void paint(Graphics2D g, Rectangle2D.Float bounds) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

