/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import pGraph.Chart;

class Pie
extends Chart {
    private Font percentFont;
    private Font groupFont;

    public Pie(Font groupFont, Font percentFont, double[][] values, String[] groups, Paint[] paints, boolean inset) {
        super(values, groups, paints, inset);
        this.percentFont = percentFont;
        this.groupFont = groupFont;
    }

    public Point2D.Float rotate(float offset3D, float angle, Rectangle2D.Float r) {
        double ang = Math.toRadians(angle);
        return new Point2D.Float((float)(Math.cos(ang) * (double)r.width / 2.0 + (double)r.x + (double)(r.width / 2.0f)), (float)(-Math.sin(ang) * (double)r.height / 2.0 + (double)r.y + (double)(r.height / 2.0f) + (double)(angle > 180.0f ? offset3D : 0.0f)));
    }

    public void paint(Graphics2D g, Rectangle2D.Float bounds) {
        int graphsAcross = (int)Math.ceil(Math.sqrt(this.groupLength));
        int graphsDown = (int)Math.ceil((float)this.groupLength / (float)graphsAcross);
        FontMetrics groupFontMetrics = g.getFontMetrics(this.groupFont);
        Rectangle2D.Float groupRect = (Rectangle2D.Float)groupFontMetrics.getStringBounds("100.0%", g);
        for (int x = 0; x < this.groupLength; ++x) {
            Rectangle2D.Float graphBounds = new Rectangle2D.Float(bounds.x + (bounds.width + 5.0f) / (float)graphsAcross * (float)(x % graphsAcross), bounds.y + (bounds.height + 5.0f) / (float)graphsDown * (float)(x / graphsAcross), (bounds.width - (float)((graphsAcross - 1) * 5)) / (float)graphsAcross, (bounds.height - (float)((graphsDown - 1) * 5)) / (float)graphsDown);
            if (x < this.groups.length) {
                g.setFont(this.groupFont);
                g.setPaint(Color.black);
                g.drawString(this.groups[x], graphBounds.x, graphBounds.y - groupRect.y);
                graphBounds.y += groupRect.height + 5.0f;
                graphBounds.height -= groupRect.height + 5.0f;
            }
            FontMetrics percentFontMetrics = null;
            Rectangle2D.Float percentRect = null;
            if (this.percentFont != null) {
                percentFontMetrics = g.getFontMetrics(this.percentFont);
                percentRect = (Rectangle2D.Float)percentFontMetrics.getStringBounds("99.9%", g);
                graphBounds.setRect((double)graphBounds.x + 7.5 + (double)percentRect.width, (double)graphBounds.y + 7.5 + (double)percentRect.height, (double)graphBounds.width - 2.0 * (7.5 + (double)percentRect.width), (double)graphBounds.height - 2.0 * (7.5 + (double)percentRect.height));
                g.setFont(this.percentFont);
            }
            float offset3D = this.inset ? graphBounds.height * 0.100000024f / (float)graphsAcross : 0.0f;
            Rectangle2D.Float inner = new Rectangle2D.Float(graphBounds.x, graphBounds.y, graphBounds.width, graphBounds.height - offset3D);
            Rectangle2D.Float outer = new Rectangle2D.Float(graphBounds.x - 5.0f, graphBounds.y - 5.0f, graphBounds.width + 10.0f, graphBounds.height - offset3D + 10.0f);
            double subTotal = 0.0;
            for (int y = 0; y < this.values.length; ++y) {
                if (x >= this.values[y].length) continue;
                float arcStart = (float)(subTotal * 360.0 / this.totals[x]);
                float arcLength = (float)(this.values[y][x] * 360.0 / this.totals[x]);
                subTotal += this.values[y][x];
                g.setPaint(this.paints[y]);
                g.fill(new Arc2D.Float(inner, arcStart, arcLength, 2));
                if (arcStart + arcLength > 180.0f) {
                    float start = Math.max(180.0f, arcStart);
                    float length = arcLength - start + arcStart;
                    GeneralPath gp = new GeneralPath(new Arc2D.Float(inner, start, length, 0));
                    gp.append(new Arc2D.Float(graphBounds.x, graphBounds.y + offset3D, graphBounds.width, graphBounds.height - offset3D, start + length, -length, 0), true);
                    g.fill(gp);
                }
                if (this.percentFont == null || !(arcLength > 1.0f)) continue;
                g.setPaint(Color.black);
                String percentString = (float)Math.round(this.values[y][x] / this.totals[x] * 1000.0) / 10.0f + "%";
                float percentWidth = ((Rectangle2D.Float)percentFontMetrics.getStringBounds((String)percentString, (Graphics)g)).width;
                float percentAngle = arcStart + arcLength / 2.0f;
                Rectangle2D.Float text = new Rectangle2D.Float(outer.x - (percentWidth + 5.0f) / 2.0f, outer.y - (percentRect.height + 5.0f) / 2.0f, outer.width + percentWidth + 5.0f, outer.height + percentRect.height + 5.0f);
                g.draw(new Line2D.Float(this.rotate(offset3D, percentAngle, inner), this.rotate(offset3D, percentAngle, outer)));
                Point2D.Float textPos = this.rotate(offset3D, percentAngle, text);
                g.drawString(percentString, textPos.x - percentWidth / 2.0f, textPos.y - percentRect.y / 2.0f);
            }
            g.setPaint(new Color(0, 0, 0, 128));
            GeneralPath gp = new GeneralPath(new Arc2D.Float(graphBounds.x, graphBounds.y, graphBounds.width, graphBounds.height - offset3D, 180.0f, 180.0f, 0));
            gp.append(new Arc2D.Float(graphBounds.x, graphBounds.y + offset3D, graphBounds.width, graphBounds.height - offset3D, 0.0f, -180.0f, 0), true);
            g.fill(gp);
        }
    }
}

