/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.swing.JOptionPane;
import pGraph.Axes;
import pGraph.Axes2;
import pGraph.Bar;
import pGraph.Chart;
import pGraph.Line;
import pGraph.Pie;
import pGraph.Scatter;
import pGraph.StackBar;
import pGraph.StackLine;

public class Main
extends Applet {
    private String unregisteredMsg = "Unregistered - www.fmsolutions.co.nz";
    private Paint background = Color.white;
    private String title;
    private String[] legend;
    private Font titleFont;
    private Font legendFont = null;
    private Font valueFont;
    private Font groupFont;
    private Paint[] paints;
    private int margin = 5;
    private Chart chart;
    private boolean waterMark;
    private boolean showValues;
    private static final Font waterMarkFont = new Font("sans-serif", 0, 20);

    public static void main(String[] arg) {
        JOptionPane.showMessageDialog(null, "pGraph 1.2b\nDeveloped by Prototec Ltd.\nMarketed and Distributed by Skagerrak Software Ltd.");
    }

    private String getParameter(String paramName, String defaultValue) {
        try {
            return URLDecoder.decode(this.getParameter(paramName), "UTF-8");
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void init() {
        this.waterMark = !this.getParameter("registrationserial", "").equals(this.registration(this.getParameter("registrationname", "") + "pGraph1"));
        this.showValues = this.getParameter("showvalues", "").equalsIgnoreCase("true");
        String fontName = this.getParameter("font", "arial");
        int titleFontSize = Integer.parseInt(this.getParameter("titlesize", "18"));
        this.titleFont = new Font(fontName, 0, titleFontSize);
        int legendSize = Integer.parseInt(this.getParameter("legendsize", "" + (int)((double)titleFontSize * 0.7)));
        if (legendSize > 0) {
            this.legendFont = new Font(fontName, 0, legendSize);
        }
        this.valueFont = new Font(fontName, 0, Integer.parseInt(this.getParameter("valuesize", "" + (int)((double)titleFontSize * 0.6))));
        this.groupFont = new Font(fontName, 0, Integer.parseInt(this.getParameter("groupsize", "" + (int)((double)titleFontSize * 0.7))));
        this.title = this.getParameter("title", null);
        String data = this.getParameter("data", null);
        String[] dataSets = data == null ? new String[]{} : data.split("\\ *\\|\\ *");
        this.legend = new String[dataSets.length];
        data = this.getParameter("groups", null);
        String[] groups = data == null ? new String[]{} : data.split("\\ *\\,\\ *");
        double[][] amounts = new double[dataSets.length][];
        for (int i = 0; i < dataSets.length; ++i) {
            String[] dataSet = dataSets[i].split("\\ *\\,\\ *");
            if (dataSet.length <= 0) continue;
            this.legend[i] = dataSet[0];
            amounts[i] = new double[dataSet.length - 1];
            for (int j = 1; j < dataSet.length; ++j) {
                try {
                    amounts[i][j - 1] = Double.parseDouble(dataSet[j]);
                    continue;
                }
                catch (NumberFormatException e) {
                    amounts[i][j - 1] = 0.0;
                }
            }
        }
        this.paints = new Paint[amounts.length];
        int range = Math.min(this.paints.length, 9);
        for (int x = 0; x < this.paints.length; ++x) {
            float brightness = 0.8f - (float)((x + range) / range / 2) / (float)((this.paints.length + range) / range / 2) * 0.4f;
            float saturation = x / range / 2 % 2 == 0 ? 1.0f : 0.5f;
            float hue = (float)(x % range) / (float)range / 3.0f + (float)(x % 3) / 3.0f;
            Color col = Color.getHSBColor(hue * 0.85f, saturation, brightness);
            this.paints[x] = col;
        }
        String colourGroup = this.getParameter("colours", this.getParameter("c", null));
        String[] colourStrings = colourGroup == null ? new String[]{} : colourGroup.split("\\ *\\,\\ *");
        for (int x = 0; x < colourStrings.length && x < this.paints.length; ++x) {
            try {
                this.paints[x] = Color.decode("#" + colourStrings[x]);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String images = this.getParameter("images", null);
        if (images != null) {
            URL base;
            String[] imgs = images.split("\\ *\\,\\ *");
            MediaTracker mt = new MediaTracker(this);
            try {
                base = new URL(this.getParameter("imagedir", null));
            }
            catch (MalformedURLException e) {
                base = this.getDocumentBase();
            }
            for (int x = 0; x < imgs.length && x < this.paints.length; ++x) {
                try {
                    Image img = this.getImage(base, imgs[x]);
                    mt.addImage(img, x);
                    mt.waitForAll();
                    Rectangle imgRect = new Rectangle(0, 0, img.getWidth(null), img.getHeight(null));
                    BufferedImage bi = new BufferedImage(imgRect.width, imgRect.height, 1);
                    Graphics bg = bi.getGraphics();
                    bg.drawImage(img, 0, 0, null);
                    bg.dispose();
                    this.paints[x] = new TexturePaint(bi, imgRect);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        boolean inset = false;
        String type = this.getParameter("type", this.getParameter("t", "")).toLowerCase();
        if (type.length() > 1 && type.substring(0, 2).equals("3d")) {
            inset = true;
            type = type.substring(2, type.length());
        }
        if (type.equals("bar") || type.equals("b")) {
            this.chart = new Bar(amounts, groups, this.paints, inset);
        } else if (type.equals("line") || type.equals("l")) {
            this.chart = new Line(amounts, groups, this.paints, inset);
        } else if (type.equals("barstack") || type.equals("bs")) {
            this.chart = new StackBar(amounts, groups, this.paints, inset);
        } else if (type.equals("linestack") || type.equals("ls")) {
            this.chart = new StackLine(amounts, groups, this.paints, inset);
        }
        if (this.chart != null) {
            this.chart = new Axes(this.groupFont, this.valueFont, this.getParameter("xtitle", this.getParameter("x", null)), this.getParameter("ytitle", this.getParameter("y", null)), this.chart);
        } else if (type.equals("scatter") || type.equals("s")) {
            this.chart = new Scatter(amounts, groups, this.paints, inset, this.getParameter("trend", "").equalsIgnoreCase("true"), this.getParameter("join", "").equals("true"));
            this.chart = new Axes2(this.groupFont, this.valueFont, this.getParameter("xtitle", this.getParameter("x", null)), this.getParameter("ytitle", this.getParameter("y", null)), (Scatter)this.chart);
        } else {
            this.chart = new Pie(this.groupFont, this.showValues ? this.valueFont : null, amounts, groups, this.paints, inset);
        }
    }

    public void paint(Graphics b) {
        Dimension dim = this.getSize();
        Graphics2D g = (Graphics2D)b;
        g.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        g.setPaint(this.background);
        g.fill(new Rectangle(0, 0, dim.width, dim.height));
        g.setPaint(Color.black);
        Rectangle2D.Float chartRect = new Rectangle2D.Float(this.margin, this.margin, dim.width - 2 * this.margin, dim.height - 2 * this.margin);
        if (this.title != null) {
            Rectangle2D.Float titleRect = (Rectangle2D.Float)this.getFontMetrics(this.titleFont).getStringBounds(this.title, g);
            g.setFont(this.titleFont);
            g.drawString(this.title, chartRect.x + (chartRect.width - titleRect.width) / 2.0f, chartRect.y - titleRect.y);
            chartRect.y += titleRect.height + (float)this.margin;
            chartRect.height -= titleRect.height + (float)this.margin;
        }
        if (this.legend.length > 0 && this.legendFont != null) {
            int x;
            FontMetrics legendFontMetrics = this.getFontMetrics(this.legendFont);
            Rectangle2D.Float legendFontRect = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
            for (x = 0; x < this.legend.length; ++x) {
                Rectangle2D.Float lFR = (Rectangle2D.Float)legendFontMetrics.getStringBounds(this.legend[x], g);
                if (!(lFR.width > legendFontRect.width)) continue;
                legendFontRect = lFR;
            }
            chartRect.width -= (float)this.margin * 1.5f + legendFontRect.height + legendFontRect.width;
            g.setFont(this.legendFont);
            for (x = 0; x < this.legend.length; ++x) {
                g.setPaint(this.paints[x]);
                g.fill(new Rectangle2D.Float(chartRect.x + chartRect.width + (float)this.margin, chartRect.y + (float)x * (legendFontRect.height + 1.0f), legendFontRect.height, legendFontRect.height));
                g.setPaint(Color.black);
                g.drawString(this.legend[x], chartRect.x + chartRect.width + (float)this.margin * 1.5f + legendFontRect.height, chartRect.y + (float)x * (legendFontRect.height + 1.0f) - legendFontRect.y);
            }
        }
        this.chart.paint(g, chartRect);
        if (this.waterMark) {
            g.setPaint(new Color(0, 0, 0, 64));
            Rectangle2D waterMarkSize = this.getFontMetrics(waterMarkFont).getStringBounds(this.unregisteredMsg, g);
            AffineTransform at = new AffineTransform();
            float scaleFactor = (float)Math.min((double)((float)dim.width * 0.7f) / waterMarkSize.getWidth(), (double)((float)dim.height * 0.5f) / waterMarkSize.getHeight());
            at.scale(scaleFactor, scaleFactor);
            g.setFont(waterMarkFont.deriveFont(at));
            g.drawString(this.unregisteredMsg, (float)((double)dim.width - waterMarkSize.getWidth() * (double)scaleFactor) / 2.0f, (float)((double)dim.height - waterMarkSize.getHeight() * (double)scaleFactor) / 2.0f);
        }
    }

    private String registration(String s) {
        try {
            String num = new BigInteger(MessageDigest.getInstance("MD5").digest(s.getBytes())).toString(10);
            return num.substring(1, 5) + '-' + num.substring(5, 9) + '-' + num.substring(9, 13) + '-' + num.substring(13, 17);
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }
}

