/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import pGraph.Chart;

class Line
extends Chart {
    Line(double[][] amounts, String[] xLabels, Paint[] paints, boolean inset) {
        super(amounts, xLabels, paints, inset);
    }

    public void paint(Graphics2D g, Rectangle2D.Float bounds) {
        float columnWidth = bounds.width / ((float)this.groupLength * ((float)this.values.length + 2.0f));
        float start = (float)(this.values.length + 2) / 2.0f * columnWidth + bounds.x;
        float step = columnWidth * (float)(this.values.length + 2);
        for (int i = 0; i < this.values.length && this.values[i].length > 0; ++i) {
            g.setPaint(this.paints[i]);
            GeneralPath p = new GeneralPath();
            Point2D.Float p1 = new Point2D.Float(start, bounds.y + (float)((this.max - this.values[i][0]) * (double)bounds.height / this.range));
            p.moveTo(p1.x, p1.y);
            for (int j = 0; j < this.values[i].length; ++j) {
                Point2D.Float pt = new Point2D.Float(start + step * (float)j, bounds.y + (float)((this.max - this.values[i][j]) * (double)bounds.height / this.range));
                p.lineTo(pt.x, pt.y);
                if (this.inset) {
                    GeneralPath sf = new GeneralPath();
                    sf.moveTo(p1.x, p1.y);
                    sf.lineTo(p1.x + columnWidth / 2.0f, p1.y - columnWidth / 2.0f);
                    sf.lineTo(pt.x + columnWidth / 2.0f, pt.y - columnWidth / 2.0f);
                    sf.lineTo(pt.x, pt.y);
                    g.fill(sf);
                    int shade = (int)(128.0 * Math.sin(Math.atan((p1.y - pt.y) / (p1.x - pt.x))));
                    g.setPaint(shade < 0 ? new Color(255, 255, 255, shade + 128) : new Color(0, 0, 0, shade));
                    g.fill(sf);
                    g.setPaint(this.paints[i]);
                }
                g.fill(new Ellipse2D.Float(pt.x - 2.5f, pt.y - 2.5f, 5.0f, 5.0f));
                p1 = pt;
            }
            g.draw(p);
        }
    }
}

