/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

abstract class Chart {
    protected Paint[] paints;
    protected double[][] values;
    protected double[] totals;
    public double max;
    public double min;
    public double range;
    public boolean inset;
    protected int valuesLength;
    protected int groupLength;
    public String[] groups;
    protected static final int margin = 5;
    protected static final float ratio3D = 0.9f;
    protected static final float crossWidth = 2.5f;

    public Chart(double[][] values, String[] groups, Paint[] paints, boolean inset) {
        this.init(values, groups, paints, inset);
    }

    public void init(double[][] values, String[] groups, Paint[] paints, boolean inset) {
        this.inset = inset;
        this.groups = groups;
        this.paints = paints;
        this.values = values;
        this.groupLength = 0;
        this.max = this.min = (double)0;
        this.totals = values.length > 0 ? new double[values[0].length] : new double[]{};
        Arrays.fill(this.totals, 0.0);
        for (int i = 0; i < values.length; ++i) {
            this.groupLength = Math.max(this.groupLength, values[i].length);
            for (int j = 0; j < values[i].length; ++j) {
                int n = j;
                this.totals[n] = this.totals[n] + values[i][j];
                this.max = Math.max(this.max, values[i][j]);
                this.min = Math.min(this.min, values[i][j]);
            }
        }
        this.range = this.max - this.min;
        this.valuesLength = values.length;
    }

    public Chart() {
    }

    public abstract void paint(Graphics2D var1, Rectangle2D.Float var2);
}

