/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import pGraph.Chart;
import pGraph.Scatter;
import pGraph.VirtualSpace;

class Axes2
extends Chart {
    private final int tickWidth = 2;
    private int graphXMagnitude;
    private int graphYMagnitude;
    private Scatter chart;
    private Font axesTitleFont;
    private Font axesFont;
    private double graphXStep;
    private double graphYStep;
    private String xTitle;
    private String yTitle;
    private Rectangle2D.Float valueBounds;

    protected String doubleToString(double d, int magnitude) {
        if (magnitude < 0) {
            String dd = Integer.toString((int)((d - (double)((int)d)) * Math.pow(10.0, -magnitude) + 0.5));
            while (dd.length() < -magnitude) {
                dd = "0" + dd;
            }
            return Integer.toString((int)d) + "." + dd;
        }
        return Integer.toString((int)d);
    }

    public Axes2(Font axesTitleFont, Font axesFont, String xTitle, String yTitle, Scatter chart) {
        this.axesTitleFont = axesTitleFont;
        this.axesFont = axesFont;
        this.chart = chart;
        this.xTitle = xTitle;
        this.yTitle = yTitle;
        this.graphXMagnitude = (int)(Math.log(Math.max(Math.abs(chart.valueBounds.x + chart.valueBounds.width), Math.abs(chart.valueBounds.x))) / Math.log(10.0));
        this.graphXStep = Math.pow(10.0, this.graphXMagnitude);
        double graphXMax = Math.ceil((double)chart.valueBounds.x + (double)chart.valueBounds.width / this.graphXStep) * this.graphXStep;
        double graphXMin = Math.floor((double)chart.valueBounds.x / this.graphXStep) * this.graphXStep;
        this.graphYMagnitude = (int)(Math.log(Math.max(Math.abs(chart.valueBounds.y + chart.valueBounds.height), Math.abs(chart.valueBounds.y))) / Math.log(10.0));
        this.graphYStep = Math.pow(10.0, this.graphYMagnitude);
        double graphYMax = Math.ceil((double)chart.valueBounds.y + (double)chart.valueBounds.height / this.graphYStep) * this.graphYStep;
        double graphYMin = Math.floor((double)chart.valueBounds.y / this.graphYStep) * this.graphYStep;
        this.valueBounds = new Rectangle2D.Float((float)graphXMin, (float)graphYMin, (float)(graphXMax - graphXMin), (float)(graphYMax - graphYMin));
    }

    private void drawDelta(Graphics2D g, double x, double y, double xPlus, double yPlus) {
        g.draw(new Line2D.Double(x, y, x + xPlus, y + yPlus));
    }

    public void paint(Graphics2D g, Rectangle2D.Float bounds) {
        Rectangle2D.Float stringBounds;
        String xAxisValue;
        int x;
        FontMetrics axesFontMetrics = g.getFontMetrics(this.axesFont);
        Rectangle2D.Float xAxisTitleRect = null;
        Rectangle2D.Float yAxisTitleRect = null;
        Rectangle2D.Float axesMaxRect = (Rectangle2D.Float)axesFontMetrics.getStringBounds(this.doubleToString(this.doubleToString(this.valueBounds.y + this.valueBounds.height, this.graphYMagnitude).length() > this.doubleToString(this.valueBounds.y, this.graphYMagnitude).length() ? (double)(this.valueBounds.y + this.valueBounds.height) : (double)this.valueBounds.y, this.graphYMagnitude), g);
        Rectangle2D.Float yAxis = new Rectangle2D.Float(bounds.x + axesMaxRect.width + 2.0f, bounds.y, 4.0f, bounds.height - (float)axesFontMetrics.getHeight() - 4.0f);
        if (this.yTitle != null) {
            yAxisTitleRect = (Rectangle2D.Float)g.getFontMetrics(this.axesTitleFont).getStringBounds(this.yTitle, g);
            yAxis.x += yAxisTitleRect.height + 5.0f;
        }
        if (this.xTitle != null) {
            xAxisTitleRect = (Rectangle2D.Float)g.getFontMetrics(this.axesTitleFont).getStringBounds(this.xTitle, g);
            yAxis.height -= xAxisTitleRect.height + 5.0f;
        }
        if (this.chart.groups.length > 0) {
            yAxis.height -= axesMaxRect.height + 2.0f + 5.0f;
        }
        Rectangle2D.Float graphBounds = new Rectangle2D.Float(yAxis.x + 2.0f, yAxis.y + 2.0f, bounds.width - yAxis.x, yAxis.height - 4.0f);
        if (this.valueBounds.x < -1.4E-45f) {
            graphBounds.width -= 4.0f;
            graphBounds.x += 4.0f;
        }
        if (this.valueBounds.x + this.valueBounds.width > Float.MIN_VALUE) {
            graphBounds.width -= 4.0f;
        }
        if (this.valueBounds.y + this.valueBounds.height > Float.MIN_VALUE) {
            graphBounds.height -= 4.0f;
            graphBounds.y += 4.0f;
        }
        if (this.valueBounds.y < -1.4E-45f) {
            graphBounds.height -= 4.0f;
        }
        if (this.chart.inset) {
            // empty if block
        }
        VirtualSpace vs = new VirtualSpace(graphBounds, this.valueBounds);
        this.chart.paint(g, vs);
        g.setPaint(Color.black);
        Point2D.Float zeroPt = vs.getPoint(0.0f, 0.0f);
        g.draw(new Line2D.Float(zeroPt.x, yAxis.y, zeroPt.x, yAxis.y + yAxis.height));
        g.draw(new Line2D.Float(yAxis.x, zeroPt.y, bounds.x + bounds.width, zeroPt.y));
        if (this.valueBounds.x < -1.4E-45f) {
            this.drawDelta(g, yAxis.x, zeroPt.y, 4.0, 2.0);
            this.drawDelta(g, yAxis.x, zeroPt.y, 4.0, -2.0);
        }
        if (this.valueBounds.x + this.valueBounds.width > Float.MIN_VALUE) {
            this.drawDelta(g, bounds.x + bounds.width, zeroPt.y, -4.0, 2.0);
            this.drawDelta(g, bounds.x + bounds.width, zeroPt.y, -4.0, -2.0);
        }
        if (this.valueBounds.y + this.valueBounds.height > Float.MIN_VALUE) {
            this.drawDelta(g, zeroPt.x, yAxis.y, -2.0, 4.0);
            this.drawDelta(g, zeroPt.x, yAxis.y, 2.0, 4.0);
        }
        if (this.valueBounds.y < -1.4E-45f) {
            this.drawDelta(g, zeroPt.x, yAxis.y + yAxis.height, -2.0, -4.0);
            this.drawDelta(g, zeroPt.x, yAxis.y + yAxis.height, 2.0, -4.0);
        }
        g.setFont(this.axesFont);
        float pos = vs.getY((float)((double)(this.valueBounds.y + this.valueBounds.height) + 2.0 * this.graphYStep));
        for (x = (int)((double)this.valueBounds.height / this.graphYStep); x > -1; --x) {
            float yPos = vs.getY((float)((double)this.valueBounds.y + (double)x * this.graphYStep));
            xAxisValue = this.doubleToString((double)this.valueBounds.y + (double)x * this.graphYStep, this.graphYMagnitude);
            stringBounds = (Rectangle2D.Float)axesFontMetrics.getStringBounds(xAxisValue, g);
            if (!(yPos - stringBounds.height > pos)) continue;
            this.drawDelta(g, zeroPt.x - 2.0f, yPos, 4.0, 0.0);
            g.drawString(xAxisValue, zeroPt.x - 4.0f - stringBounds.width, vs.getY((float)((double)this.valueBounds.y + (double)x * this.graphYStep)) + stringBounds.height / 2.0f);
            pos = yPos;
        }
        pos = vs.getX((float)((double)(this.valueBounds.x + this.valueBounds.width) + 2.0 * this.graphXStep));
        for (x = (int)((double)this.valueBounds.width / this.graphXStep); x > -1; --x) {
            float xPos = vs.getX((float)((double)this.valueBounds.x + (double)x * this.graphXStep));
            xAxisValue = this.doubleToString((double)this.valueBounds.x + (double)x * this.graphXStep, this.graphXMagnitude);
            stringBounds = (Rectangle2D.Float)axesFontMetrics.getStringBounds(xAxisValue, g);
            if (!(xPos + stringBounds.width < pos)) continue;
            this.drawDelta(g, vs.getX((float)((double)this.valueBounds.x + (double)x * this.graphXStep)), zeroPt.y - 2.0f, 0.0, 4.0);
            g.drawString(xAxisValue, vs.getX((float)((double)this.valueBounds.x + (double)x * this.graphXStep)) - stringBounds.width / 2.0f, zeroPt.y + 2.0f + stringBounds.height);
            pos = xPos;
        }
        if (this.xTitle != null) {
            g.setFont(this.axesTitleFont);
            g.drawString(this.xTitle, graphBounds.x + (graphBounds.width - xAxisTitleRect.width) / 2.0f, bounds.y + bounds.height - 5.0f);
        }
        if (this.yTitle != null) {
            AffineTransform t = g.getTransform();
            g.rotate(Math.toRadians(-90.0));
            g.setFont(this.axesTitleFont);
            g.drawString(this.yTitle, -yAxis.y - (yAxis.height + yAxisTitleRect.width) / 2.0f, bounds.x - yAxisTitleRect.y);
            g.setTransform(t);
        }
    }
}

