/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import pGraph.Chart;

class Axes
extends Chart {
    private final int tickWidth = 2;
    private int graphMagnitude;
    private Chart chart;
    private Font axesTitleFont;
    private Font axesFont;
    private double graphMax;
    private double graphMin;
    private double graphRange;
    private double graphStep;
    private String xTitle;
    private String yTitle;

    protected String doubleToString(double d) {
        if (this.graphMagnitude < 0) {
            String dd = Integer.toString((int)((d - (double)((int)d)) * Math.pow(10.0, -this.graphMagnitude) + 0.5));
            while (dd.length() < -this.graphMagnitude) {
                dd = "0" + dd;
            }
            return Integer.toString((int)d) + "." + dd;
        }
        return Integer.toString((int)d);
    }

    public Axes(Font axesTitleFont, Font axesFont, String xTitle, String yTitle, Chart chart) {
        this.axesTitleFont = axesTitleFont;
        this.axesFont = axesFont;
        this.chart = chart;
        this.xTitle = xTitle;
        this.yTitle = yTitle;
        this.graphMagnitude = (int)(Math.log(Math.max(Math.abs(chart.max), Math.abs(chart.min))) / Math.log(10.0));
        this.graphStep = Math.pow(10.0, this.graphMagnitude);
        this.graphMax = Math.ceil(chart.max / this.graphStep) * this.graphStep;
        this.graphMin = Math.floor(chart.min / this.graphStep) * this.graphStep;
        this.graphRange = this.graphMax - this.graphMin;
    }

    private void drawDelta(Graphics2D g, double x, double y, double xPlus, double yPlus) {
        g.draw(new Line2D.Double(x, y, x + xPlus, y + yPlus));
    }

    public void paint(Graphics2D g, Rectangle2D.Float bounds) {
        float tickRatio;
        int tickStep;
        FontMetrics axesFontMetrics = g.getFontMetrics(this.axesFont);
        Rectangle2D.Float xAxisTitleRect = null;
        Rectangle2D.Float yAxisTitleRect = null;
        Rectangle2D.Float axesMaxRect = (Rectangle2D.Float)axesFontMetrics.getStringBounds(this.doubleToString(this.doubleToString(this.graphMax).length() > this.doubleToString(this.graphMin).length() ? this.graphMax : this.graphMin), g);
        Rectangle2D.Float yAxis = new Rectangle2D.Float(bounds.x + axesMaxRect.width + 2.0f, bounds.y, 4.0f, bounds.height);
        if (this.yTitle != null) {
            yAxisTitleRect = (Rectangle2D.Float)g.getFontMetrics(this.axesTitleFont).getStringBounds(this.yTitle, g);
            yAxis.x += yAxisTitleRect.height + 5.0f;
        }
        if (this.xTitle != null) {
            xAxisTitleRect = (Rectangle2D.Float)g.getFontMetrics(this.axesTitleFont).getStringBounds(this.xTitle, g);
            yAxis.height -= xAxisTitleRect.height + 5.0f;
        }
        if (this.chart.groups.length > 0) {
            yAxis.height -= axesMaxRect.height + 2.0f + 5.0f;
        }
        Rectangle2D.Float graphBounds = new Rectangle2D.Float(yAxis.x + 2.0f, yAxis.y + 6.0f, bounds.width - yAxis.x - 6.0f, yAxis.height - (float)((this.chart.min < 0.0 ? 6 : 3) * 2));
        float columnWidth = graphBounds.width / ((float)this.chart.groupLength * ((float)this.chart.valuesLength + 2.0f));
        if (this.chart.inset) {
            float offSetAmount = columnWidth / 2.0f;
            graphBounds.y += offSetAmount;
            graphBounds.height -= offSetAmount;
        }
        Rectangle2D.Float scaledBounds = new Rectangle2D.Float(graphBounds.x, (float)((double)graphBounds.y + (this.graphMax - this.chart.max) * (double)graphBounds.height / this.graphRange), graphBounds.width, (float)((double)graphBounds.height * this.chart.range / this.graphRange));
        Rectangle2D.Float xAxis = new Rectangle2D.Float(yAxis.x + 2.0f, scaledBounds.y + (float)(this.chart.max * (double)scaledBounds.height / this.chart.range) - 2.0f, bounds.width - yAxis.x, yAxis.width);
        this.chart.paint(g, scaledBounds);
        g.setFont(this.axesFont);
        g.setPaint(Color.black);
        this.drawDelta(g, yAxis.x + yAxis.width / 2.0f, yAxis.y, 0.0, yAxis.height);
        this.drawDelta(g, yAxis.x + yAxis.width / 2.0f, yAxis.y, -yAxis.width / 2.0f, yAxis.width);
        this.drawDelta(g, yAxis.x + yAxis.width / 2.0f, yAxis.y, yAxis.width / 2.0f, yAxis.width);
        if (this.chart.min < 0.0) {
            this.drawDelta(g, yAxis.x + yAxis.width / 2.0f, yAxis.y + yAxis.height, -yAxis.width / 2.0f, -yAxis.width);
            this.drawDelta(g, yAxis.x + yAxis.width / 2.0f, yAxis.y + yAxis.height, yAxis.width / 2.0f, -yAxis.width);
        }
        if ((tickStep = (int)Math.ceil(axesMaxRect.height / (tickRatio = (float)((double)graphBounds.height / this.graphRange * this.graphStep)))) != 0) {
            for (int x = (int)(this.graphRange / this.graphStep); x > -1; --x) {
                if (x % tickStep != 0) continue;
                this.drawDelta(g, yAxis.x, graphBounds.y + tickRatio * (float)x, yAxis.width, 0.0);
                String xAxisValue = this.doubleToString(this.graphMax - (double)x * this.graphStep);
                g.drawString(xAxisValue, xAxis.x - 5.0f - ((Rectangle2D.Float)axesFontMetrics.getStringBounds((String)xAxisValue, (Graphics)g)).width, graphBounds.y + tickRatio * (float)x - axesMaxRect.y / 2.0f);
            }
        }
        this.drawDelta(g, xAxis.x, xAxis.y + xAxis.height / 2.0f, xAxis.width, 0.0);
        this.drawDelta(g, xAxis.x + xAxis.width, xAxis.y + xAxis.height / 2.0f, -xAxis.height, -xAxis.height / 2.0f);
        this.drawDelta(g, xAxis.x + xAxis.width, xAxis.y + xAxis.height / 2.0f, -xAxis.height, xAxis.height / 2.0f);
        float start = ((float)this.chart.valuesLength + 2.0f) / 2.0f * columnWidth + graphBounds.x;
        float step = columnWidth * ((float)this.chart.valuesLength + 2.0f);
        for (int x = 0; x < this.chart.groups.length; ++x) {
            if (this.chart.groups[x].length() <= 0) continue;
            this.drawDelta(g, start + (float)x * step, xAxis.y, 0.0, xAxis.height);
            Rectangle2D.Float axesFontRect = (Rectangle2D.Float)axesFontMetrics.getStringBounds(this.chart.groups[x], g);
            g.drawString(this.chart.groups[x], start + (float)x * step - axesFontRect.width / 2.0f, xAxis.y + xAxis.height - axesFontRect.y);
        }
        if (this.xTitle != null) {
            g.setFont(this.axesTitleFont);
            g.drawString(this.xTitle, graphBounds.x + (graphBounds.width - xAxisTitleRect.width) / 2.0f, bounds.y + bounds.height - 5.0f);
        }
        if (this.yTitle != null) {
            AffineTransform t = g.getTransform();
            g.rotate(Math.toRadians(-90.0));
            g.setFont(this.axesTitleFont);
            g.drawString(this.yTitle, -yAxis.y - (yAxis.height + yAxisTitleRect.width) / 2.0f, bounds.x - yAxisTitleRect.y);
            g.setTransform(t);
        }
    }
}

